<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title>About Omateq Digitals - Leading Web Development Company in Nigeria | 7+ Years Experience</title>
	<meta name="description" content="Learn about Omateq Digitals, Nigeria's premier web development company with 7+ years of experience. Expert team delivering school portals, inventory software, and digital training solutions.">
	<meta name="keywords" content="about omateq digitals, web development company Nigeria, software development team, IT company Suleja, web developers Abuja, digital training experts, school portal developers">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="About Omateq Digitals - Leading Web Development Company in Nigeria">
	<meta property="og:description" content="Discover our story, expertise, and commitment to delivering exceptional web development and digital training solutions across Nigeria.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/about-og.jpg">
	<meta property="og:site_name" content="Omateq Digitals">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="About Omateq Digitals - Leading Web Development Company">
	<meta name="twitter:description" content="Learn about our 7+ years of expertise in web development, software solutions, and digital training.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/about-og.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	<link rel="icon"  href="assets/imgs/favicon.png">
	
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
	</style>
</head>

<body>
<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
													<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2>About Us</h2>
						<ul>
							<li><a href="index.php">Home</a></li>
							<li>About Us</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Feature Section -->
    <section class="feature-section pt-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="feature-single-item">
                        <img src="assets/img/icon/feature-icon-1.svg" alt="icon">
                        <h3>Custom Web Solutions</h3>
                        <p>We create responsive, mobile-first websites and web applications that adapt perfectly to all devices and screen sizes, ensuring optimal user experience across all platforms.</p>
						<!-- <div class="feature-btn-box"> 
							<a href="contact.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Contact us</a>
						</div> -->
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-single-item">
                        <img src="assets/img/icon/feature-icon-2.svg" alt="icon">
                        <h3>Expert Development Team</h3>
                        <p>Our skilled developers specialize in modern web technologies, custom software development, and digital training programs, bringing years of experience to every project.</p>
						<!-- <div class="feature-btn-box"> 
							<a href="contact.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Contact us</a>
						</div> -->
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-single-item">
                        <img src="assets/img/icon/feature-icon-3.svg" alt="icon">
                        <h3>Business Growth Focus</h3>
                        <p>We focus on delivering solutions that drive real business value, from school portals and inventory systems to comprehensive digital skills training programs.</p>
						<!-- <div class="feature-btn-box"> 
							<a href="about.html#" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
						</div> -->
                    </div>
                </div>
            </div>
        </div>
    </section>
	<!-- End Feature Section -->
	
	<!-- Start About Section -->
	<section class="about-area section-padding">
		<div class="container">
			<div class="row d-flex align-items-center">
				<div class="col-lg-6 col-md-12">
					<div class="about-content">
									<h6 class="sub-title">About Omateq Digitals</h6> 
									<h2>Transforming Businesses Through Innovative Web Development & Digital Solutions</h2>
									<p>At Omateq Digitals, we specialize in creating comprehensive web solutions, custom software development, and digital skills training. Our mission is to empower businesses and individuals with cutting-edge technology solutions that drive growth and success.</p>
						<div class="skills">
							<div class="skill-item">
												<h6>Web Development <em>95%</em></h6>
								<div class="skill-progress">
													<div class="progres" data-value="95%"></div>
								</div>
							</div>
							<div class="skill-item">
												<h6>Custom Software <em>90%</em></h6>
								<div class="skill-progress">
													<div class="progres" data-value="90%"></div>
								</div>
							</div>
							<div class="skill-item">
												<h6>Digital Training <em>88%</em></h6>
								<div class="skill-progress">
													<div class="progres" data-value="88%"></div>
								</div>
							</div>
						</div>
						<div class="about-btn-box"> 
							<a class="default-btn" href="contact.php">Contact us <span></span></a>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-md-12">
					<div class="about-image">
						<img src="assets/img/about.jpg" alt="About image">
						<div class="years-design">
													<h2>9</h2>
													<h5>Years Of Excellence</h5>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End About Section -->
	
	<!-- Start Counter Section -->
	<section class="counter-area section-padding">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
													<span class="counter-number">7</span>
								<span>+</span>
							</h2>
													<h3 class="counter-heading">Years of Excellence</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
													<span class="counter-number">5</span>
								<span>+</span>
							</h2>
													<h3 class="counter-heading">Expert Developers</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
													<span class="counter-number">150</span>
								<span>+</span>
							</h2>
													<h3 class="counter-heading">Successful Projects</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
													<span class="counter-number">200</span>
								<span>+</span>
							</h2>
													<h3 class="counter-heading">Satisfied Clients</h3>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Counter Section -->
	
	
    <!-- Start Works Process Section -->
    <section class="workprocess-section bg-grey section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title">
                        <h6 class="sub-title">4 Step Work Process</h6>
                        <h2>Working Process</h2>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="workprocess-single-item">
                        <div class="workprocess-icon-box">
							<img src="assets/img/icon/workprocess-icon-1.svg" alt="icon">
                        </div>
                        <div class="workprocess-info">
                            <h3>Discovery & Planning</h3>
                            <p>We start by understanding your business needs, goals, and requirements through detailed consultation and analysis to create the perfect solution.</p>
                        </div>
						<div class="workprocess-number-bg"><span>01</span></div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="workprocess-single-item">
                        <div class="workprocess-icon-box">
							<img src="assets/img/icon/workprocess-icon-2.svg" alt="icon">
                        </div>
                        <div class="workprocess-info">
                            <h3>Design & Development</h3>
                            <p>Our expert team creates stunning, responsive designs and develops robust web applications using the latest technologies and best practices.</p>
                        </div>
						<div class="workprocess-number-bg"><span>02</span></div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="workprocess-single-item">
                        <div class="workprocess-icon-box">
							<img src="assets/img/icon/workprocess-icon-3.svg" alt="icon">
                        </div>
                        <div class="workprocess-info">
                            <h3>Testing & Quality Assurance</h3>
                            <p>We thoroughly test all functionality, performance, and security aspects to ensure your solution works flawlessly across all devices and browsers.</p>
                        </div>
						<div class="workprocess-number-bg"><span>03</span></div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="workprocess-single-item">
                        <div class="workprocess-icon-box">
							<img src="assets/img/icon/workprocess-icon-4.svg" alt="icon">
                        </div>
                        <div class="workprocess-info">
                            <h3>Launch & Support</h3>
                            <p>We deploy your solution and provide ongoing support, training, and maintenance to ensure continued success and optimal performance.</p>
                        </div>
						<div class="workprocess-number-bg"><span>04</span></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Works Process Section -->
	
	<!-- Start Hire Section -->
	<section class="hire-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 offset-lg-2 col-md-12">
					<div class="hire-content">
									<h6 class="sub-title">Ready to transform your business?</h6>
									<h2>Let's Build Your Digital Future Together</h2>
									<p>From custom web applications to comprehensive digital training programs, we're here to help you leverage technology for business growth. Contact us today to discuss your project and discover how we can bring your digital vision to life.</p>
						<div class="hire-btn">
											<a class="default-btn" href="tel:+2347069378861">Call Now<span></span></a>
											<a class="default-btn-one" href="contact.php">Contact Us<span></span></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Hire Section -->
	
	<!-- Start Partner section -->
	<section class="partner-section pt-100 pb-70">
		<div class="container">
			<div class="partner-title">
				<h6 class="sub-title">Trusted By 200+</h6>
				<h2>Our Clients</h2>
			</div>
			<div class="partner-list">
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-1.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-2.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-3.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-4.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-5.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-6.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-7.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-8.png" alt="image">
					</a>
				</div>
				<div class="partner-item">
					<a href="about.html#0">
						<img src="assets/img/partner/client-1.png" alt="image">
					</a>
				</div>
			</div>
		</div>
	</section>
	<!-- End Partner section -->
	
	<!-- Start Footer & Subscribe Section -->
	<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<!-- Structured Data (JSON-LD) -->
	<script type="application/ld+json">
	{
		"@context": "https://schema.org",
		"@type": "AboutPage",
		"mainEntity": {
			"@type": "Organization",
			"name": "Omateq Digitals",
			"alternateName": "Omateq Digitals Limited",
			"url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>",
			"logo": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/logo.png",
			"description": "Leading web development company in Nigeria with 7+ years of experience specializing in school portals, inventory software, custom web applications, and digital skills training.",
			"foundingDate": "2018",
			"founder": {
				"@type": "Person",
				"name": "David Omateq"
			},
			"address": {
				"@type": "PostalAddress",
				"streetAddress": "Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint",
				"addressLocality": "Suleja",
				"addressRegion": "Niger State",
				"addressCountry": "NG"
			},
			"contactPoint": {
				"@type": "ContactPoint",
				"telephone": "+2347069378861",
				"contactType": "customer service",
				"email": "info@omateqdigitals.com",
				"availableLanguage": "English"
			},
			"employee": [
				{
					"@type": "Person",
					"name": "David Omateq",
					"jobTitle": "Founder & CEO"
				},
				{
					"@type": "Person",
					"name": "Sarah Williams",
					"jobTitle": "Lead Developer"
				},
				{
					"@type": "Person",
					"name": "Michael Brown",
					"jobTitle": "Training Director"
				},
				{
					"@type": "Person",
					"name": "Jennifer Davis",
					"jobTitle": "Project Manager"
				}
			],
			"aggregateRating": {
				"@type": "AggregateRating",
				"ratingValue": "4.8",
				"reviewCount": "200"
			},
			"knowsAbout": [
				"Web Development",
				"School Portal Development",
				"Inventory Management Software",
				"Custom Web Applications",
				"Digital Skills Training",
				"AI Automation",
				"YouTube Automation",
				"Software Development"
			]
		}
	}
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>