<?php
require_once '../config/database.php';
require_once '../config/session_manager.php';

// Initialize session
SessionManager::initSession();

$error = '';
$success = '';

// Check if user is already logged in
if (isset($_SESSION['admin_id'])) {
    header('Location: ../index.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'Please fill in all fields';
    } else {
        try {
            $pdo = getConnection();
            $stmt = $pdo->prepare("SELECT id, username, password FROM admin_users WHERE username = ?");
            $stmt->execute([$username]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['admin_id'] = $user['id'];
                $_SESSION['admin_username'] = $user['username'];
                header('Location: ../index.php');
                exit();
            } else {
                $error = 'Invalid username or password';
            }
        } catch (Exception $e) {
            $error = 'Login failed. Please try again.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

  <base href="">

  <!-- begin::Edura Meta Basic -->
  <meta charset="utf-8">
  <meta name="theme-color" content="#0D9488">
  <meta name="robots" content="index, follow">
  <meta name="author" content="Omateq Digitals">
  <meta name="format-detection" content="telephone=no">
  <meta name="keywords" content="Admin Dashboard, Omateq Digitals, Management System, Admin Panel, Dashboard Control">
  <meta name="description" content="Omateq Digitals Admin Dashboard - Secure admin login for managing the platform.">
  <!-- end::Edura Meta Basic -->

  <!-- begin::Edura Meta Social -->
  <meta property="og:url" content="">
  <meta property="og:site_name" content="Admin Login | Omateq Digitals">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_us">
  <meta property="og:title" content="Admin Login | Omateq Digitals">
  <meta property="og:description" content="Omateq Digitals Admin Dashboard - Secure admin login for managing the platform.">
  <!-- end::Edura Meta Social -->

  <!-- begin::Edura Meta Twitter -->
  <meta name="twitter:card" content="summary">
  <meta name="twitter:url" content="">
  <meta name="twitter:creator" content="@omateqdigitals">
  <meta name="twitter:title" content="Admin Login | Omateq Digitals">
  <meta name="twitter:description" content="Omateq Digitals Admin Dashboard - Secure admin login for managing the platform.">
  <!-- end::Edura Meta Twitter -->

  <!-- begin::Edura Website Page Title -->
  <title>Admin Login | Omateq Digitals</title>
  <!-- end::Edura Website Page Title -->

  <!-- begin::Edura Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- end::Edura Mobile Specific -->

  <!-- begin::Edura Favicon Tags -->
  <link rel="icon" type="image/png" href="../assets/images/favicon.png">
  <link rel="apple-touch-icon" sizes="180x180" href="../assets/images/apple-touch-icon.png">
  <!-- end::Edura Favicon Tags -->

  <!-- begin::Edura Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
  <!-- end::Edura Google Fonts -->

  <!-- begin::Edura Required Stylesheet -->
  <link rel="stylesheet" href="../assets/libs/flaticon/css/all/all.css">
  <link rel="stylesheet" href="../assets/libs/lucide/lucide.css">
  <link rel="stylesheet" href="../assets/libs/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="../assets/libs/simplebar/simplebar.css">
  <link rel="stylesheet" href="../assets/libs/node-waves/waves.css">
  <link rel="stylesheet" href="../assets/libs/bootstrap-select/css/bootstrap-select.min.css">
  <!-- end::Edura Required Stylesheet -->

  <!-- begin::Edura CSS Stylesheet -->
  <link rel="stylesheet" href="../assets/css/styles.css">
  <!-- end::Edura CSS Stylesheet -->
  <!-- Both pages now use: -->
<link rel="icon" type="image/png" href="../../assets/img/favicon.png">
<link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
  
  <!-- begin::Custom Login Styles -->
  <style>
    .page-layout {
      background: #1a1a1a;
      min-height: 100vh;
    }
    
    .auth-frame-wrapper {
      border-radius: 15px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
      width: 100%;
      max-width: 800px;
      background: #2d2d2d !important;
      border: 1px solid #404040;
    }
    
    .auth-frame-wrapper.bg-white {
      background: #2d2d2d !important;
    }
    
    .auth-frame-wrapper .row {
      margin: 0;
    }
    
    .auth-frame-wrapper .col-12,
    .auth-frame-wrapper .col-lg-8,
    .auth-frame-wrapper .col-xl-6 {
      padding: 0;
    }
    
    .form-control {
      border-radius: 8px;
      border: 1px solid #404040;
      padding: 12px 15px;
      font-size: 14px;
      background: #1a1a1a;
      color: #ffffff;
    }
    
    .form-control:focus {
      border-color: #007bff;
      box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
      background: #1a1a1a;
      color: #ffffff;
    }
    
    .form-control::placeholder {
      color: #888;
    }
    
    .btn-primary {
      border-radius: 8px;
      padding: 12px;
      font-weight: 600;
      background: #007bff;
      border: none;
      transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
      background: #0056b3;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(0, 123, 255, 0.3);
    }
    
    .alert {
      border-radius: 8px;
      border: none;
    }
    
    .form-label {
      color: #ffffff;
      font-weight: 500;
    }
    
    .text-center h5 {
      color: #ffffff;
      font-weight: 600;
    }
    
    .text-center p {
      color: #cccccc;
    }
    
    .form-check-label {
      color: #cccccc;
    }
    
    a {
      color: #66b3ff;
      text-decoration: none;
    }
    
    a:hover {
      color: #99ccff;
      text-decoration: underline;
    }
    
    .alert {
      background: #3d3d3d;
      color: #ffffff;
      border: 1px solid #555;
    }
    
    .alert-danger {
      background: #4a1a1a;
      border-color: #6b2c2c;
    }
    
    .alert-success {
      background: #1a4a1a;
      border-color: #2c6b2c;
    }
    
    .form-check-input {
      background-color: #1a1a1a;
      border: 1px solid #404040;
    }
    
    .form-check-input:checked {
      background-color: #007bff;
      border-color: #007bff;
    }
    
    .form-check-input:focus {
      box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
    
    .logo-container img {
      filter: brightness(1.2) contrast(1.1);
      transition: all 0.3s ease;
    }
    
    .logo-container img:hover {
      filter: brightness(1.4) contrast(1.2);
      transform: scale(1.05);
    }
    
    @media (max-width: 768px) {
      .auth-frame-wrapper {
        margin: 20px;
        max-width: none;
      }
      
      .page-layout {
        padding: 20px;
      }
    }
    
    @media (min-width: 1200px) {
      .auth-frame-wrapper {
        max-width: 900px;
      }
    }
  </style>
  <!-- end::Custom Login Styles -->

  <!-- begin::Edura Googletagmanager -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-XWVQM68HHQ"></script>
  <script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());

		gtag('config', 'G-XWVQM68HHQ', {
			'cookie_flags': 'SameSite=None;Secure',
			'send_page_view': true
		});
	</script>
  <!-- end::Edura Googletagmanager -->


</head>

<body>
  <div class="page-layout d-flex align-items-center justify-content-center min-vh-100">

    <div class="auth-frame-wrapper">
      <div class="row g-0 h-100 justify-content-center">
        <div class="col-12 col-lg-8 col-xl-6">
          <div class="p-4 p-sm-5">
            <div class="mb-4 text-center logo-container">
              <a href="../index.php" aria-label="Omateq Digitals logo">
                <img src="../../assets/img/logo.png" alt="Omateq Digitals logo" style="max-height: 60px; width: auto;">
              </a>
            </div>
            <div class="text-center mb-5">
              <h5 class="mb-1">Welcome to Omateq Digitals</h5>
              <p>Sign in to access your secure admin dashboard.</p>
            </div>
            
            <?php if ($error): ?>
              <div class="alert alert-danger" role="alert">
                <i class="fi fi-rr-exclamation-circle me-2"></i><?php echo htmlspecialchars($error); ?>
              </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
              <div class="alert alert-success" role="alert">
                <i class="fi fi-rr-check-circle me-2"></i><?php echo htmlspecialchars($success); ?>
              </div>
            <?php endif; ?>
            
            <form method="POST" action="">
              <div class="mb-4">
                <label class="form-label" for="username">Username</label>
                <input type="text" class="form-control" id="username" name="username" placeholder="Enter your username" required>
              </div>
              <div class="mb-4">
                <label class="form-label" for="password">Password</label>
                <input type="password" class="form-control" id="password" name="password" placeholder="Enter your password" required>
              </div>
              <div class="mb-4">
                <div class="d-flex justify-content-between">
                  <div class="form-check mb-0">
                    <input class="form-check-input" type="checkbox" id="rememberMe">
                    <label class="form-check-label" for="rememberMe"> Remember Me </label>
                  </div>
                  <a href="forgot-password.php">Forgot Password?</a>
                </div>
              </div>
              <div class="mb-3">
                <button type="submit" value="Submit" class="btn btn-primary waves-effect waves-light w-100">Login</button>
              </div>
              
              </p>
            </form>
          </div>
        </div>
      </div>
    </div>

  </div>
  <!-- begin::Edura Page Scripts -->
  <script src="../assets/libs/global/global.min.js"></script>
  <script src="../assets/js/appSettings.js"></script>
  <script src="../assets/js/main.js"></script>
  <!-- end::Edura Page Scripts -->
</body>

</html>
