<?php
// Script to add email addresses to existing admin users
require_once 'database.php';

echo "<h2>Add Email Addresses to Admin Users</h2>";

try {
    $pdo = getConnection();
    
    // Check if email column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM admin_users LIKE 'email'");
    $emailColumnExists = $stmt->rowCount() > 0;
    
    if (!$emailColumnExists) {
        // Add email column
        $pdo->exec("ALTER TABLE admin_users ADD COLUMN email VARCHAR(255) NULL");
        echo "<p>✅ Email column added to admin_users table.</p>";
    }
    
    // Get all admin users
    $stmt = $pdo->query("SELECT id, username, email FROM admin_users");
    $users = $stmt->fetchAll();
    
    echo "<h3>Current Admin Users:</h3>";
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background-color: #f8f9fa;'>";
    echo "<th style='padding: 10px;'>ID</th>";
    echo "<th style='padding: 10px;'>Username</th>";
    echo "<th style='padding: 10px;'>Email</th>";
    echo "<th style='padding: 10px;'>Action</th>";
    echo "</tr>";
    
    foreach ($users as $user) {
        echo "<tr>";
        echo "<td style='padding: 10px;'>" . $user['id'] . "</td>";
        echo "<td style='padding: 10px;'>" . htmlspecialchars($user['username']) . "</td>";
        echo "<td style='padding: 10px;'>" . htmlspecialchars($user['email'] ?? 'Not set') . "</td>";
        echo "<td style='padding: 10px;'>";
        
        if (empty($user['email'])) {
            echo "<form method='POST' style='display: inline;'>";
            echo "<input type='hidden' name='user_id' value='" . $user['id'] . "'>";
            echo "<input type='email' name='email' placeholder='admin@omateqdigitals.com' required style='width: 200px; padding: 5px;'>";
            echo "<input type='submit' name='update_email' value='Update' style='margin-left: 5px; padding: 5px 10px; background-color: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer;'>";
            echo "</form>";
        } else {
            echo "<span style='color: green;'>✅ Set</span>";
        }
        
        echo "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Handle email updates
    if ($_POST['update_email'] ?? false) {
        $userId = $_POST['user_id'] ?? '';
        $email = trim($_POST['email'] ?? '');
        
        if (!empty($userId) && !empty($email) && filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $stmt = $pdo->prepare("UPDATE admin_users SET email = ? WHERE id = ?");
            $stmt->execute([$email, $userId]);
            
            echo "<div style='background-color: #d4edda; color: #155724; padding: 15px; border-radius: 5px; border: 1px solid #c3e6cb; margin: 20px 0;'>";
            echo "✅ Email updated successfully for user ID: " . $userId;
            echo "</div>";
            
            // Refresh the page to show updated data
            echo "<script>setTimeout(function(){ window.location.reload(); }, 2000);</script>";
        } else {
            echo "<div style='background-color: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; border: 1px solid #f5c6cb; margin: 20px 0;'>";
            echo "❌ Invalid email address. Please try again.";
            echo "</div>";
        }
    }
    
    echo "<h3>Instructions:</h3>";
    echo "<div style='background-color: #f8f9fa; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<ol>";
    echo "<li>For each admin user without an email, enter their email address</li>";
    echo "<li>Click 'Update' to save the email address</li>";
    echo "<li>The forgot password system will use these email addresses</li>";
    echo "<li>If no email is set, the system will use 'admin@omateqdigitals.com' as default</li>";
    echo "</ol>";
    echo "</div>";
    
    echo "<p><a href='../authentication/login.php' style='color: #007bff;'>← Back to Login</a></p>";
    echo "<p><a href='setup_email.php' style='color: #007bff;'>Configure Email Settings</a></p>";
    
} catch (Exception $e) {
    echo "<div style='background-color: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; border: 1px solid #f5c6cb;'>";
    echo "❌ Error: " . $e->getMessage();
    echo "</div>";
}
?>
