<?php
// Email Configuration for Omateq Digitals Admin Dashboard

// SMTP Configuration - Using existing Omateq Digitals SMTP settings
define('SMTP_HOST', 'scripthubs.com');
define('SMTP_PORT', 465);
define('SMTP_USERNAME', 'market@scripthubs.com');
define('SMTP_PASSWORD', 'Terminal2025#');
define('SMTP_ENCRYPTION', 'ssl');
define('SMTP_FROM_EMAIL', 'market@scripthubs.com');
define('SMTP_FROM_NAME', 'Omateq Digitals');

// Email Settings
define('EMAIL_TIMEOUT', 30); // Email timeout in seconds

// Function to send password reset email using existing SMTP mailer
function sendPasswordResetEmail($toEmail, $toName, $resetLink) {
    try {
        // Use the existing SMTP mailer from users config
        require_once __DIR__ . '/../../users/config/smtp_mailer.php';
        
        // SMTP Configuration (same as users config)
        $config = [
            'host' => SMTP_HOST,
            'port' => SMTP_PORT,
            'username' => SMTP_USERNAME,
            'password' => SMTP_PASSWORD,
            'encryption' => SMTP_ENCRYPTION,
            'from_email' => SMTP_FROM_EMAIL,
            'from_name' => SMTP_FROM_NAME,
            'reply_to' => SMTP_FROM_EMAIL
        ];
        
        $mailer = new SMTPMailer($config);
        
        // Email content
        $subject = 'Password Reset Request - Omateq Digitals Admin';
        $message = createPasswordResetEmailTemplate($toName, $resetLink);
        
        // Send email
        $result = $mailer->send($toEmail, $subject, $message, true);
        
        if ($result['success']) {
            return true;
        } else {
            error_log("Admin password reset email failed: " . $result['message']);
            return false;
        }
        
    } catch (Exception $e) {
        error_log("Admin password reset email error: " . $e->getMessage());
        return false;
    }
}

// Function to create HTML email template
function createPasswordResetEmailTemplate($name, $resetLink) {
    return '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Password Reset Request</title>
        <style>
            body {
                font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
                line-height: 1.6;
                color: #333;
                background-color: #f4f4f4;
                margin: 0;
                padding: 0;
            }
            .container {
                max-width: 600px;
                margin: 0 auto;
                background-color: #ffffff;
                border-radius: 10px;
                overflow: hidden;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            }
            .header {
                background: linear-gradient(135deg, #007bff, #0056b3);
                color: white;
                padding: 30px;
                text-align: center;
            }
            .header h1 {
                margin: 0;
                font-size: 24px;
                font-weight: 600;
            }
            .content {
                padding: 40px 30px;
            }
            .content h2 {
                color: #333;
                margin-top: 0;
                font-size: 20px;
            }
            .content p {
                color: #666;
                margin-bottom: 20px;
            }
            .reset-button {
                display: inline-block;
                background: linear-gradient(135deg, #007bff, #0056b3);
                color: white;
                text-decoration: none;
                padding: 15px 30px;
                border-radius: 8px;
                font-weight: 600;
                text-align: center;
                margin: 20px 0;
                transition: all 0.3s ease;
            }
            .reset-button:hover {
                background: linear-gradient(135deg, #0056b3, #004085);
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(0, 123, 255, 0.3);
            }
            .security-info {
                background-color: #f8f9fa;
                border-left: 4px solid #007bff;
                padding: 20px;
                margin: 20px 0;
                border-radius: 0 8px 8px 0;
            }
            .security-info h3 {
                color: #007bff;
                margin-top: 0;
                font-size: 16px;
            }
            .security-info ul {
                color: #666;
                margin: 10px 0;
                padding-left: 20px;
            }
            .footer {
                background-color: #f8f9fa;
                padding: 30px;
                text-align: center;
                border-top: 1px solid #e9ecef;
            }
            .footer p {
                color: #666;
                margin: 5px 0;
                font-size: 14px;
            }
            .logo {
                max-width: 200px;
                height: auto;
                margin-bottom: 20px;
            }
            @media (max-width: 600px) {
                .container {
                    margin: 10px;
                    border-radius: 5px;
                }
                .header, .content, .footer {
                    padding: 20px;
                }
                .reset-button {
                    display: block;
                    width: 100%;
                    box-sizing: border-box;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>🔐 Password Reset Request</h1>
                <p>Omateq Digitals Admin Dashboard</p>
            </div>
            
            <div class="content">
                <h2>Hello ' . htmlspecialchars($name) . ',</h2>
                
                <p>We received a request to reset your password for your Omateq Digitals Admin Dashboard account.</p>
                
                <p>If you made this request, click the button below to reset your password:</p>
                
                <div style="text-align: center;">
                    <a href="' . htmlspecialchars($resetLink) . '" class="reset-button">Reset My Password</a>
                </div>
                
                <p>Or copy and paste this link into your browser:</p>
                <p style="word-break: break-all; background-color: #f8f9fa; padding: 10px; border-radius: 5px; font-family: monospace; font-size: 12px;">
                    ' . htmlspecialchars($resetLink) . '
                </p>
                
                <div class="security-info">
                    <h3>🛡️ Security Information</h3>
                    <ul>
                        <li>This link will expire in <strong>1 hour</strong></li>
                        <li>The link can only be used <strong>once</strong></li>
                        <li>If you didn\'t request this reset, please ignore this email</li>
                        <li>Your password will remain unchanged until you click the link</li>
                    </ul>
                </div>
                
                <p>If you\'re having trouble with the button above, copy and paste the URL into your web browser.</p>
                
                <p>If you didn\'t request this password reset, please ignore this email or contact our support team if you have concerns.</p>
                
                <p>Best regards,<br>
                <strong>Omateq Digitals Team</strong></p>
            </div>
            
            <div class="footer">
                <p><strong>Omateq Digitals</strong></p>
                <p>Admin Dashboard System</p>
                <p style="font-size: 12px; color: #999;">
                    This is an automated message. Please do not reply to this email.
                </p>
            </div>
        </div>
    </body>
    </html>';
}

// Function to create plain text email
function createPasswordResetEmailText($name, $resetLink) {
    return "
Password Reset Request - Omateq Digitals Admin Dashboard

Hello " . $name . ",

We received a request to reset your password for your Omateq Digitals Admin Dashboard account.

If you made this request, click the link below to reset your password:

" . $resetLink . "

Security Information:
- This link will expire in 1 hour
- The link can only be used once
- If you didn't request this reset, please ignore this email
- Your password will remain unchanged until you click the link

If you're having trouble with the link above, copy and paste the URL into your web browser.

If you didn't request this password reset, please ignore this email or contact our support team if you have concerns.

Best regards,
Omateq Digitals Team

---
Omateq Digitals Admin Dashboard System
This is an automated message. Please do not reply to this email.
";
}
?>
