<?php
// Email Configuration Setup Script
// Run this script once to configure your email settings

require_once 'email_config.php';

echo "<h2>Email Configuration Setup</h2>";
echo "<p>This script will help you configure email settings for the forgot password functionality.</p>";

// Check current configuration
echo "<h3>Current Email Configuration:</h3>";
echo "<ul>";
echo "<li><strong>SMTP Host:</strong> " . SMTP_HOST . "</li>";
echo "<li><strong>SMTP Port:</strong> " . SMTP_PORT . "</li>";
echo "<li><strong>SMTP Username:</strong> " . SMTP_USERNAME . "</li>";
echo "<li><strong>SMTP Encryption:</strong> " . SMTP_ENCRYPTION . "</li>";
echo "<li><strong>From Email:</strong> " . SMTP_FROM_EMAIL . "</li>";
echo "<li><strong>From Name:</strong> " . SMTP_FROM_NAME . "</li>";
echo "</ul>";

echo "<h3>Configuration Instructions:</h3>";
echo "<div style='background-color: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h4>For Gmail:</h4>";
echo "<ol>";
echo "<li>Enable 2-factor authentication on your Gmail account</li>";
echo "<li>Generate an App Password: <a href='https://myaccount.google.com/apppasswords' target='_blank'>https://myaccount.google.com/apppasswords</a></li>";
echo "<li>Use your Gmail address as SMTP_USERNAME and SMTP_FROM_EMAIL</li>";
echo "<li>Use the generated App Password as SMTP_PASSWORD</li>";
echo "<li>Keep SMTP_HOST as 'smtp.gmail.com' and SMTP_PORT as 587</li>";
echo "</ol>";

echo "<h4>For Other Email Providers:</h4>";
echo "<ul>";
echo "<li><strong>Outlook/Hotmail:</strong> smtp-mail.outlook.com, port 587</li>";
echo "<li><strong>Yahoo:</strong> smtp.mail.yahoo.com, port 587</li>";
echo "<li><strong>Custom SMTP:</strong> Contact your hosting provider for SMTP settings</li>";
echo "</ul>";
echo "</div>";

echo "<h3>To Update Configuration:</h3>";
echo "<p>Edit the file: <code>admin-dashboard/config/email_config.php</code></p>";
echo "<p>Update these constants with your email provider settings:</p>";
echo "<pre style='background-color: #f8f9fa; padding: 15px; border-radius: 5px;'>";
echo "define('SMTP_HOST', 'scripthubs.com');\n";
echo "define('SMTP_PORT', 465);\n";
echo "define('SMTP_USERNAME', 'market@scripthubs.com');\n";
echo "define('SMTP_PASSWORD', 'Terminal2025#');\n";
echo "define('SMTP_ENCRYPTION', 'ssl');\n";
echo "define('SMTP_FROM_EMAIL', 'market@scripthubs.com');\n";
echo "define('SMTP_FROM_NAME', 'Omateq Digitals');";
echo "</pre>";

echo "<h3>Test Email Configuration:</h3>";
echo "<form method='POST' style='background-color: #f8f9fa; padding: 20px; border-radius: 8px;'>";
echo "<p><strong>Test Email Address:</strong></p>";
echo "<input type='email' name='test_email' placeholder='test@example.com' required style='width: 300px; padding: 8px; margin: 5px;'>";
echo "<br><br>";
echo "<input type='submit' name='test_email_config' value='Send Test Email' style='background-color: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'>";
echo "</form>";

// Handle test email
if ($_POST['test_email_config'] ?? false) {
    $testEmail = $_POST['test_email'] ?? '';
    
    if (!empty($testEmail)) {
        echo "<div style='margin-top: 20px; padding: 15px; border-radius: 5px;'>";
        
        // Create a test reset link
        $testResetLink = 'https://omateqdigitals.com/admin-dashboard/authentication/reset-password.php?token=test123';
        
        // Send test email
        $emailSent = sendPasswordResetEmail($testEmail, 'Test User', $testResetLink);
        
        if ($emailSent) {
            echo "<div style='background-color: #d4edda; color: #155724; padding: 15px; border-radius: 5px; border: 1px solid #c3e6cb;'>";
            echo "<strong>✅ Success!</strong> Test email sent to " . htmlspecialchars($testEmail) . "<br>";
            echo "Please check your inbox and spam folder.";
            echo "</div>";
        } else {
            echo "<div style='background-color: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; border: 1px solid #f5c6cb;'>";
            echo "<strong>❌ Failed!</strong> Could not send test email.<br>";
            echo "Please check your email configuration in <code>email_config.php</code><br>";
            echo "Common issues:";
            echo "<ul>";
            echo "<li>Incorrect SMTP credentials</li>";
            echo "<li>SMTP server not accessible</li>";
            echo "<li>Firewall blocking SMTP port</li>";
            echo "<li>Email provider blocking the connection</li>";
            echo "</ul>";
            echo "</div>";
        }
        
        echo "</div>";
    }
}

echo "<h3>Security Notes:</h3>";
echo "<div style='background-color: #fff3cd; padding: 15px; border-radius: 5px; border: 1px solid #ffeaa7;'>";
echo "<ul>";
echo "<li>Never commit your actual email credentials to version control</li>";
echo "<li>Use App Passwords instead of your main email password</li>";
echo "<li>Consider using environment variables for sensitive data</li>";
echo "<li>Test the configuration before deploying to production</li>";
echo "</ul>";
echo "</div>";

echo "<p><a href='../authentication/login.php' style='color: #007bff;'>← Back to Login</a></p>";
?>
