<?php
// Test script for admin email functionality
require_once 'email_config.php';

echo "<h2>Admin Email Test</h2>";

// Test email configuration
echo "<h3>Current Configuration:</h3>";
echo "<ul>";
echo "<li><strong>SMTP Host:</strong> " . SMTP_HOST . "</li>";
echo "<li><strong>SMTP Port:</strong> " . SMTP_PORT . "</li>";
echo "<li><strong>SMTP Username:</strong> " . SMTP_USERNAME . "</li>";
echo "<li><strong>SMTP Encryption:</strong> " . SMTP_ENCRYPTION . "</li>";
echo "<li><strong>From Email:</strong> " . SMTP_FROM_EMAIL . "</li>";
echo "<li><strong>From Name:</strong> " . SMTP_FROM_NAME . "</li>";
echo "</ul>";

// Test email form
echo "<h3>Send Test Email:</h3>";
echo "<form method='POST' style='background-color: #f8f9fa; padding: 20px; border-radius: 8px;'>";
echo "<p><strong>Test Email Address:</strong></p>";
echo "<input type='email' name='test_email' placeholder='test@example.com' required style='width: 300px; padding: 8px; margin: 5px;'>";
echo "<br><br>";
echo "<input type='submit' name='send_test' value='Send Test Email' style='background-color: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'>";
echo "</form>";

// Handle test email
if ($_POST['send_test'] ?? false) {
    $testEmail = $_POST['test_email'] ?? '';
    
    if (!empty($testEmail)) {
        echo "<div style='margin-top: 20px; padding: 15px; border-radius: 5px;'>";
        
        // Create a test reset link
        $testResetLink = 'http://localhost/omateqdigitals/admin-dashboard/authentication/reset-password.php?token=test123';
        
        echo "<p><strong>Attempting to send test email...</strong></p>";
        
        // Send test email
        $emailSent = sendPasswordResetEmail($testEmail, 'Test Admin User', $testResetLink);
        
        if ($emailSent) {
            echo "<div style='background-color: #d4edda; color: #155724; padding: 15px; border-radius: 5px; border: 1px solid #c3e6cb;'>";
            echo "<strong>✅ Success!</strong> Test email sent to " . htmlspecialchars($testEmail) . "<br>";
            echo "Please check your inbox and spam folder.";
            echo "</div>";
        } else {
            echo "<div style='background-color: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; border: 1px solid #f5c6cb;'>";
            echo "<strong>❌ Failed!</strong> Could not send test email.<br>";
            echo "Check the error logs for more details.";
            echo "</div>";
        }
        
        echo "</div>";
    }
}

// Check SMTP mailer class
echo "<h3>SMTP Mailer Check:</h3>";
try {
    require_once '../../users/config/smtp_mailer.php';
    echo "<div style='background-color: #d4edda; color: #155724; padding: 15px; border-radius: 5px; border: 1px solid #c3e6cb;'>";
    echo "<strong>✅ SMTP Mailer Class:</strong> Loaded successfully";
    echo "</div>";
} catch (Exception $e) {
    echo "<div style='background-color: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; border: 1px solid #f5c6cb;'>";
    echo "<strong>❌ SMTP Mailer Error:</strong> " . $e->getMessage();
    echo "</div>";
}

echo "<p><a href='../authentication/login.php' style='color: #007bff;'>← Back to Login</a></p>";
?>
