-- Omateq Digitals Admin Database
CREATE DATABASE IF NOT EXISTS omateqdigitals_admin;
USE omateqdigitals_admin;

-- Admin users table
CREATE TABLE admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    avatar VARCHAR(255) DEFAULT NULL,
    role ENUM('super_admin', 'admin', 'moderator') DEFAULT 'admin',
    status ENUM('active', 'inactive') DEFAULT 'active',
    last_login DATETIME DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Regular users table
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    phone VARCHAR(20) DEFAULT NULL,
    avatar VARCHAR(255) DEFAULT NULL,
    status ENUM('active', 'suspended', 'inactive') DEFAULT 'active',
    email_verified BOOLEAN DEFAULT FALSE,
    last_login DATETIME DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Portfolio management table
CREATE TABLE portfolio_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    category ENUM('website', 'webapplication', 'software') NOT NULL,
    image_url VARCHAR(255),
    project_url VARCHAR(255),
    technologies TEXT,
    features TEXT,
    status ENUM('active', 'inactive') DEFAULT 'active',
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Market items table
CREATE TABLE market_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    price DECIMAL(10,2),
    category VARCHAR(100),
    image_url VARCHAR(255),
    download_url VARCHAR(255),
    status ENUM('active', 'inactive') DEFAULT 'active',
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Bookings/Quote requests table
CREATE TABLE bookings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    full_name VARCHAR(100) NOT NULL,
    organization VARCHAR(255) NOT NULL,
    whatsapp VARCHAR(20) NOT NULL,
    email VARCHAR(100) NOT NULL,
    service_type VARCHAR(100) NOT NULL,
    description TEXT NOT NULL,
    sample_url VARCHAR(255),
    budget VARCHAR(50) NOT NULL,
    delivery_date VARCHAR(50) NOT NULL,
    status ENUM('pending', 'in_progress', 'completed', 'cancelled') DEFAULT 'pending',
    admin_notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tutorials table
CREATE TABLE tutorials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    video_url VARCHAR(255),
    thumbnail VARCHAR(255),
    category VARCHAR(100),
    duration VARCHAR(20),
    difficulty ENUM('beginner', 'intermediate', 'advanced') DEFAULT 'beginner',
    status ENUM('active', 'inactive') DEFAULT 'active',
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Courses table
CREATE TABLE courses (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    price DECIMAL(10,2),
    duration VARCHAR(50),
    level ENUM('beginner', 'intermediate', 'advanced') DEFAULT 'beginner',
    thumbnail VARCHAR(255),
    curriculum TEXT,
    instructor VARCHAR(100),
    status ENUM('active', 'inactive') DEFAULT 'active',
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Settings table
CREATE TABLE settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    setting_type ENUM('text', 'textarea', 'number', 'boolean', 'json') DEFAULT 'text',
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default admin user
INSERT INTO admin_users (username, email, password, full_name, role) VALUES 
('admin', 'admin@omateqdigitals.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Omateq Digitals Admin', 'super_admin');

-- Insert sample users
INSERT INTO users (username, email, password, full_name, phone, status, email_verified, last_login) VALUES
('john_doe', 'john.doe@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'John Doe', '+2348012345678', 'active', TRUE, '2024-01-15 10:30:00'),
('sarah_wilson', 'sarah.wilson@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Sarah Wilson', '+2348023456789', 'active', TRUE, '2024-01-14 15:45:00'),
('mike_johnson', 'mike.johnson@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Mike Johnson', '+2348034567890', 'suspended', TRUE, '2024-01-10 09:20:00'),
('lisa_brown', 'lisa.brown@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Lisa Brown', '+2348045678901', 'active', TRUE, '2024-01-13 14:15:00'),
('tom_davis', 'tom.davis@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Tom Davis', '+2348056789012', 'active', FALSE, '2024-01-12 11:30:00'),
('emma_taylor', 'emma.taylor@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Emma Taylor', '+2348067890123', 'inactive', TRUE, '2024-01-05 16:45:00'),
('david_miller', 'david.miller@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'David Miller', '+2348078901234', 'active', TRUE, '2024-01-14 08:20:00'),
('jessica_garcia', 'jessica.garcia@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Jessica Garcia', '+2348089012345', 'suspended', TRUE, '2024-01-08 13:10:00'),
('alex_rodriguez', 'alex.rodriguez@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Alex Rodriguez', '+2348090123456', 'active', TRUE, '2024-01-15 12:00:00'),
('maria_martinez', 'maria.martinez@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Maria Martinez', '+2348001234567', 'active', FALSE, '2024-01-11 17:30:00');

-- Insert default settings
INSERT INTO settings (setting_key, setting_value, setting_type, description) VALUES
('site_title', 'Omateq Digitals Admin', 'text', 'Admin dashboard title'),
('site_description', 'Omateq Digitals Admin Dashboard', 'text', 'Admin dashboard description'),
('contact_email', 'info@omateqdigitals.com', 'text', 'Contact email address'),
('contact_phone', '+2347069378861', 'text', 'Contact phone number'),
('company_address', 'Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja', 'text', 'Company address'),
('social_facebook', 'https://facebook.com/omateqdigitals', 'text', 'Facebook page URL'),
('social_youtube', 'https://youtube.com/@learnwithomateq', 'text', 'YouTube channel URL'),
('social_linkedin', 'https://www.linkedin.com/omateqdigitals', 'text', 'LinkedIn page URL');

-- Insert sample portfolio items
INSERT INTO portfolio_items (title, description, category, project_url, technologies, features, status) VALUES
('Softlens Media', 'Professional photography website for client showcasing portfolio and services', 'website', 'https://softlensmedia.com', 'HTML5, CSS3, JavaScript, Bootstrap, PHP, MySQL', 'Responsive design, Portfolio gallery, Contact form, SEO optimization', 'active'),
('Softshare', 'Image sharing system for photographers with client access limits', 'software', 'https://softshare.softlensmedia.com', 'PHP, MySQL, JavaScript, AJAX, Bootstrap, Image Processing', 'Secure client access, Bulk image upload, Custom gallery creation', 'active'),
('Alphainvest', 'Crypto investment platform for legitimate public investment needs', 'webapplication', 'https://alphainvest.scripthubs.com', 'React.js, Node.js, MongoDB, Express.js, WebSocket, API Integration', 'Real-time tracking, Portfolio management, Secure authentication', 'active');

-- Insert sample market items
INSERT INTO market_items (title, description, price, category, status) VALUES
('Web Development Template', 'Professional website template for businesses', 99.99, 'Templates', 'active'),
('Mobile App Template', 'Cross-platform mobile app template', 149.99, 'Templates', 'active'),
('E-commerce Solution', 'Complete e-commerce website solution', 299.99, 'Solutions', 'active');

-- Insert sample tutorials
INSERT INTO tutorials (title, description, category, duration, difficulty, status) VALUES
('Introduction to Web Development', 'Learn the basics of HTML, CSS, and JavaScript', 'Web Development', '2 hours', 'beginner', 'active'),
('PHP for Beginners', 'Complete PHP course from scratch', 'Backend Development', '4 hours', 'beginner', 'active'),
('React.js Advanced', 'Advanced React.js concepts and patterns', 'Frontend Development', '6 hours', 'advanced', 'active');

-- Insert sample courses
INSERT INTO courses (title, description, price, duration, level, instructor, status) VALUES
('Complete Web Development Course', 'Master web development from HTML to advanced frameworks', 199.99, '40 hours', 'beginner', 'Omateq Digitals Team', 'active'),
('Digital Skills Training', 'Comprehensive digital skills training program', 149.99, '30 hours', 'intermediate', 'Omateq Digitals Team', 'active'),
('AI Automation Training', 'Learn AI tools and automation techniques', 249.99, '25 hours', 'advanced', 'Omateq Digitals Team', 'active');
