<?php
require_once __DIR__ . '/../config/settings.php';

// Get admin details and notifications for header
try {
    $pdo = getConnection();
    
    // Get admin details
    $adminStmt = $pdo->prepare("SELECT * FROM admin_users WHERE id = ?");
    $adminStmt->execute([$_SESSION['admin_id']]);
    $adminData = $adminStmt->fetch();
    
    // Get recent notifications (product/course purchases and script requests)
    $recentNotifications = $pdo->query("
        (SELECT 'order' as type, o.id, CAST(o.order_number as CHAR) as title, CAST(o.customer_name as CHAR) as user_name, o.total_amount as amount, o.created_at, 'Product Purchase' as description
         FROM orders o 
         WHERE o.payment_status = 'paid' 
         ORDER BY o.created_at DESC 
         LIMIT 5)
        UNION ALL
        (SELECT 'course' as type, ce.id, CAST(c.title as CHAR) as title, CAST(u.full_name as CHAR) as user_name, c.price as amount, ce.enrollment_date as created_at, 'Course Enrollment' as description
         FROM course_enrollments ce 
         JOIN courses c ON ce.course_id = c.id 
         JOIN users u ON ce.user_id = u.id 
         ORDER BY ce.enrollment_date DESC 
         LIMIT 5)
        UNION ALL
        (SELECT 'script_request' as type, sr.id, CAST(CONCAT('Script Request #', sr.id) as CHAR) as title, CAST(sr.full_name as CHAR) as user_name, 0 as amount, sr.created_at, 'New Script Request' as description
         FROM script_requests sr 
         WHERE sr.status = 'pending' 
         ORDER BY sr.created_at DESC 
         LIMIT 5)
        ORDER BY created_at DESC 
        LIMIT 10
    ")->fetchAll();
    
    // Get recent script requests for messages
    $recentMessages = $pdo->query("
        SELECT sr.*, u.username, u.full_name as user_full_name
        FROM script_requests sr
        LEFT JOIN users u ON sr.user_id = u.id
        ORDER BY sr.created_at DESC 
        LIMIT 5
    ")->fetchAll();
    
    // Count unread notifications
    $unreadNotifications = count($recentNotifications);
    $unreadMessages = count($recentMessages);
    
} catch (Exception $e) {
    $adminData = null;
    $recentNotifications = $recentMessages = [];
    $unreadNotifications = $unreadMessages = 0;
}
?>

<style>
/* Logo sizing for better fit - Global for all admin pages */
.app-navbar-brand .navbar-brand-logo img {
  max-height: 50px;
  max-width: 180px;
  width: auto;
  height: auto;
  object-fit: contain;
}

.app-navbar-brand .navbar-brand-mini img {
  max-height: 35px;
  max-width: 35px;
  width: auto;
  height: auto;
  object-fit: contain;
}
</style>

<!-- begin::Edura Page Header -->
<header class="app-header">
  <div class="app-header-inner">
    <button class="app-toggler" type="button">
      <span></span>
      <span></span>
      <span></span>
    </button>
    <div class="app-header-start">
      <form class="d-none d-md-flex align-items-center h-100 w-lg-250px w-xxl-300px position-relative" action="index.html#">
        <button type="button" class="btn btn-sm border-0 position-absolute start-0 ms-3 p-0">
          <i class="fi fi-rr-search"></i>
        </button>
        <input type="text" class="form-control ps-5" placeholder="Search anything's">
      </form>
    </div>
    <div class="app-header-end">
      <div class="px-lg-3 px-2 ps-0 d-flex align-items-center">
        <a href="javascript:void(0);" class="theme-btn">
          <i class="fi fi-rr-brightness icon-light"></i>
          <div class="theme-toggle"></div>
          <i class="fi fi-rr-moon icon-dark"></i>
        </a>
      </div>
      <div class="vr my-3"></div>
      <div class="d-flex align-items-center gap-sm-2 gap-0 px-lg-4 px-sm-2 px-1">
        <!-- Messages (Script Requests) -->
        <a href="script_requests.php" class="btn btn-icon btn-action-gray rounded-circle waves-effect waves-light position-relative">
          <i class="fi fi-rr-envelope"></i>
          <?php if ($unreadMessages > 0): ?>
            <span class="position-absolute top-0 end-0 p-1 mt-1 me-1 bg-danger border border-3 border-light rounded-circle">
              <span class="visually-hidden">New messages</span>
              <small class="text-white"><?php echo $unreadMessages; ?></small>
            </span>
          <?php endif; ?>
        </a>
        
        <!-- Notifications (Purchases & Enrollments) -->
        <div class="dropdown text-end">
          <a href="javascript:void(0);" class="btn btn-icon btn-action-gray rounded-circle waves-effect waves-light position-relative" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
            <i class="fi fi-rr-bell"></i>
            <?php if ($unreadNotifications > 0): ?>
              <span class="position-absolute top-0 end-0 p-1 mt-1 me-1 bg-danger border border-3 border-light rounded-circle">
                <span class="visually-hidden">New notifications</span>
                <small class="text-white"><?php echo $unreadNotifications; ?></small>
              </span>
            <?php endif; ?>
          </a>
          <div class="dropdown-menu dropdown-menu-lg-end p-0 w-350px mt-2">
            <div class="px-3 py-3 border-bottom d-flex justify-content-between align-items-center">
              <h6 class="mb-0">Notifications <span class="badge badge-sm rounded-pill bg-primary ms-2"><?php echo $unreadNotifications; ?></span></h6>
              <i class="bi bi-x-lg cursor-pointer"></i>
            </div>
            <div class="p-2" style="height: 300px;" data-simplebar>
              <?php if (empty($recentNotifications)): ?>
                <div class="text-center py-4">
                  <i class="fi fi-rr-bell text-muted mb-2" style="font-size: 2rem;"></i>
                  <p class="text-muted mb-0">No notifications yet</p>
                </div>
              <?php else: ?>
                <ul class="list-group list-group-hover list-group-smooth list-group-unlined">
                  <?php foreach ($recentNotifications as $notification): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                      <div class="avatar avatar-xs bg-<?php echo $notification['type'] === 'order' ? 'success' : ($notification['type'] === 'course' ? 'info' : 'warning'); ?> rounded-circle text-white me-2">
                        <i class="fi fi-rr-<?php echo $notification['type'] === 'order' ? 'shopping-cart' : ($notification['type'] === 'course' ? 'book-alt' : 'file-code'); ?>"></i>
                      </div>
                      <div class="ms-2 me-auto">
                        <h6 class="mb-0"><?php echo htmlspecialchars($notification['user_name']); ?></h6>
                        <small class="text-body d-block"><?php echo htmlspecialchars($notification['description']); ?></small>
                        <small class="text-muted"><?php echo htmlspecialchars($notification['title']); ?></small>
                        <?php if ($notification['amount'] > 0): ?>
                          <small class="text-success d-block">$<?php echo number_format($notification['amount'], 2); ?></small>
                        <?php endif; ?>
                        <small class="text-muted position-absolute end-0 top-0 mt-2 me-3"><?php echo date('M d, H:i', strtotime($notification['created_at'])); ?></small>
                      </div>
                    </li>
                  <?php endforeach; ?>
                </ul>
              <?php endif; ?>
            </div>
            <div class="p-2">
              <a href="orders.php" class="btn w-100 btn-primary waves-effect waves-light">View all notifications</a>
            </div>
          </div>
        </div>
      </div>
      <div class="vr my-3"></div>
      <div class="dropdown text-end ms-2">
        <a href="javascript:void(0);" class="d-flex align-items-center py-2" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
          <div class="avatar avatar-sm rounded-circle avatar-status-success">
            <?php if ($adminData && !empty($adminData['profile_image'])): ?>
              <img src="../<?php echo htmlspecialchars($adminData['profile_image']); ?>" alt="Admin Avatar">
            <?php else: ?>
              <div class="bg-primary text-white d-flex align-items-center justify-content-center h-100 w-100 rounded-circle">
                <?php echo strtoupper(substr($adminData['username'] ?? 'A', 0, 1)); ?>
              </div>
            <?php endif; ?>
          </div>
        </a>
        <ul class="dropdown-menu dropdown-menu-end w-225px mt-1">
          <li class="d-flex align-items-center p-2">
            <div class="avatar avatar-sm rounded-circle">
              <?php if ($adminData && !empty($adminData['profile_image'])): ?>
                <img src="../<?php echo htmlspecialchars($adminData['profile_image']); ?>" alt="Admin Avatar">
              <?php else: ?>
                <div class="bg-primary text-white d-flex align-items-center justify-content-center h-100 w-100 rounded-circle">
                  <?php echo strtoupper(substr($adminData['username'] ?? 'A', 0, 1)); ?>
                </div>
              <?php endif; ?>
            </div>
            <div class="ms-2">
              <div class="fw-bold text-dark"><?php echo htmlspecialchars($adminData['full_name'] ?? $adminData['username'] ?? 'Admin'); ?></div>
              <small class="text-body d-block lh-sm"><?php echo htmlspecialchars($adminData['email'] ?? 'Administrator'); ?></small>
            </div>
          </li>
          <li>
            <div class="dropdown-divider my-1"></div>
          </li>
          <li>
            <a class="dropdown-item d-flex align-items-center gap-2" href="profile.php">
              <i class="fi fi-rr-user scale-1x"></i> View Profile
            </a>
          </li>
          <li>
            <a class="dropdown-item d-flex align-items-center gap-2" href="settings.php">
              <i class="fi fi-rr-settings scale-1x"></i> Settings
            </a>
          </li>
          <li>
            <a class="dropdown-item d-flex align-items-center gap-2" href="script_requests.php">
              <i class="fi fi-rr-file-code scale-1x"></i> Script Requests
            </a>
          </li>
          <li>
            <div class="dropdown-divider my-1"></div>
          </li>
          <li>
            <a class="dropdown-item d-flex align-items-center gap-2 text-danger" href="authentication/logout.php">
              <i class="fi fi-sr-exit scale-1x"></i> Log Out
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</header>
<!-- end::Edura Page Header -->

<!-- Session Monitor -->
<div data-session-monitor 
     data-timeout-duration="60" 
     data-warning-duration="30" 
     data-check-interval="5000" 
     data-user-type="admin" 
     data-login-url="authentication/login.php">
</div>
<script src="assets/js/session-monitor.js"></script>