<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- Title -->
	<title>Request Quote - Omateq Digitals</title>
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		.quote-form {
			background: #fff;
			padding: 40px;
			border-radius: 10px;
			box-shadow: 0 10px 30px rgba(0,0,0,0.1);
		}
		.form-group {
			margin-bottom: 25px;
		}
		.form-group label {
			font-weight: 600;
			color: #333;
			margin-bottom: 8px;
			display: block;
		}
		.form-control {
			height: 50px;
			border: 2px solid #e9ecef;
			border-radius: 5px;
			padding: 0 15px;
			font-size: 14px;
			transition: all 0.3s ease;
		}
		.form-control:focus {
			border-color: #007bff;
			box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
		}
		textarea.form-control {
			height: 120px;
			resize: vertical;
		}
		.btn-submit {
			background: linear-gradient(135deg, #007bff, #0056b3);
			border: none;
			padding: 15px 40px;
			font-size: 16px;
			font-weight: 600;
			border-radius: 5px;
			transition: all 0.3s ease;
		}
		.btn-submit:hover {
			transform: translateY(-2px);
			box-shadow: 0 5px 15px rgba(0,123,255,0.3);
		}
		.required {
			color: #dc3545;
		}
		.alert {
			border-radius: 5px;
			margin-bottom: 20px;
		}
		.quote-header {
			text-align: center;
			margin-bottom: 40px;
		}
		.quote-header h2 {
			color: #333;
			margin-bottom: 10px;
		}
		.quote-header p {
			color: #666;
			font-size: 16px;
		}
	</style>
</head>

<body>
<?php
// Form processing
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get form data
    $full_name = trim($_POST['full_name'] ?? '');
    $organization = trim($_POST['organization'] ?? '');
    $whatsapp = trim($_POST['whatsapp'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $service_type = $_POST['service_type'] ?? '';
    $description = trim($_POST['description'] ?? '');
    $sample_url = trim($_POST['sample_url'] ?? '');
    $budget = trim($_POST['budget'] ?? '');
    $delivery_date = $_POST['delivery_date'] ?? '';
    
    // Validation
    $errors = [];
    
    if (empty($full_name)) {
        $errors[] = 'Full Name is required';
    }
    if (empty($organization)) {
        $errors[] = 'Organization/Business Name is required';
    }
    if (empty($whatsapp)) {
        $errors[] = 'WhatsApp Number is required';
    }
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Valid Email Address is required';
    }
    if (empty($service_type)) {
        $errors[] = 'Service Type is required';
    }
    if (empty($description)) {
        $errors[] = 'Project Description is required';
    }
    if (empty($budget)) {
        $errors[] = 'Budget is required';
    }
    if (empty($delivery_date)) {
        $errors[] = 'Delivery Date is required';
    }
    
    if (empty($errors)) {
        // Prepare email content
        $to = 'info@omateqdigitals.com';
        $subject = 'New Quote Request - ' . $service_type;
        
        $message = "
        <h2>New Quote Request from Omateq Digitals Website</h2>
        <p><strong>Full Name:</strong> $full_name</p>
        <p><strong>Organization/Business:</strong> $organization</p>
        <p><strong>WhatsApp Number:</strong> $whatsapp</p>
        <p><strong>Email Address:</strong> $email</p>
        <p><strong>Service Type:</strong> $service_type</p>
        <p><strong>Project Description:</strong><br>$description</p>
        <p><strong>Sample URL:</strong> $sample_url</p>
        <p><strong>Budget:</strong> $budget</p>
        <p><strong>Delivery Date:</strong> $delivery_date</p>
        <p><strong>Submitted:</strong> " . date('Y-m-d H:i:s') . "</p>
        ";
        
        // Use SMTP mailer instead of PHP mail() function
        try {
            require_once 'users/config/smtp_mailer.php';
            
            // SMTP Configuration (same as admin config)
            $config = [
                'host' => 'omateqdigitals.com',
                'port' => 465,
                'username' => 'info@omateqdigitals.com',
                'password' => 'Terminal2025#',
                'encryption' => 'ssl',
                'from_email' => 'info@omateqdigitals.com',
                'from_name' => 'Omateq Digitals',
                'reply_to' => $email // Use the form submitter's email as reply-to
            ];
            
            $mailer = new SMTPMailer($config);
            $result = $mailer->send($to, $subject, $message, true);
            
            if ($result['success']) {
                $success_message = 'Thank you! Your quote request has been submitted successfully. We will contact you within 24 hours.';
            } else {
                $error_message = 'Sorry, there was an error sending your request. Please try again or contact us directly.';
                error_log("Booking email failed: " . $result['message']);
            }
            
        } catch (Exception $e) {
            $error_message = 'Sorry, there was an error sending your request. Please try again or contact us directly.';
            error_log("Booking email error: " . $e->getMessage());
        }
    } else {
        $error_message = implode('<br>', $errors);
    }
}
?>

	<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
							</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
							<a class="default-btn" href="booking.php">Request Quote<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2>Request a Quote</h2>
						<ul>
							<li><a href="index.php">Home</a></li>
							<li>Request Quote</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Quote Request Section -->
	<section class="quote-request-section section-padding">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-lg-8">
					<div class="quote-form">
						<div class="quote-header">
							<h2>Get Your Project Quote</h2>
							<p>Tell us about your project and we'll provide you with a detailed quote within 24 hours</p>
						</div>
						
						<?php if ($success_message): ?>
							<div class="alert alert-success">
								<i class="bi bi-check-circle"></i> <?php echo $success_message; ?>
							</div>
						<?php endif; ?>
						
						<?php if ($error_message): ?>
							<div class="alert alert-danger">
								<i class="bi bi-exclamation-triangle"></i> <?php echo $error_message; ?>
							</div>
						<?php endif; ?>
						
						<form method="POST" action="">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label for="full_name">Full Name <span class="required">*</span></label>
										<input type="text" class="form-control" id="full_name" name="full_name" 
											   value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>" required>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label for="organization">Name of Organization or Business <span class="required">*</span></label>
										<input type="text" class="form-control" id="organization" name="organization" 
											   value="<?php echo htmlspecialchars($_POST['organization'] ?? ''); ?>" required>
									</div>
								</div>
							</div>
							
							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label for="whatsapp">WhatsApp Number (with Country Code) <span class="required">*</span></label>
										<input type="tel" class="form-control" id="whatsapp" name="whatsapp" 
											   placeholder="e.g., +2347069378861" 
											   value="<?php echo htmlspecialchars($_POST['whatsapp'] ?? ''); ?>" required>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label for="email">Email Address <span class="required">*</span></label>
										<input type="email" class="form-control" id="email" name="email" 
											   value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
									</div>
								</div>
							</div>
							
							<div class="form-group">
								<label for="service_type">Type of Service <span class="required">*</span></label>
								<select class="form-control" id="service_type" name="service_type" required>
									<option value="">Select a service</option>
									<option value="School Portal Development" <?php echo (($_POST['service_type'] ?? '') == 'School Portal Development') ? 'selected' : ''; ?>>School Portal Development</option>
									<option value="Inventory Software Development" <?php echo (($_POST['service_type'] ?? '') == 'Inventory Software Development') ? 'selected' : ''; ?>>Inventory Software Development</option>
									<option value="Web Applications" <?php echo (($_POST['service_type'] ?? '') == 'Web Applications') ? 'selected' : ''; ?>>Web Applications</option>
									<option value="Professional Dynamic Websites" <?php echo (($_POST['service_type'] ?? '') == 'Professional Dynamic Websites') ? 'selected' : ''; ?>>Professional Dynamic Websites</option>
									<option value="Software Development" <?php echo (($_POST['service_type'] ?? '') == 'Software Development') ? 'selected' : ''; ?>>Software Development</option>
									<option value="Customized Softwares" <?php echo (($_POST['service_type'] ?? '') == 'Customized Softwares') ? 'selected' : ''; ?>>Customized Softwares</option>
									<option value="Digital Skills Training" <?php echo (($_POST['service_type'] ?? '') == 'Digital Skills Training') ? 'selected' : ''; ?>>Digital Skills Training</option>
									<option value="YouTube Automation Training" <?php echo (($_POST['service_type'] ?? '') == 'YouTube Automation Training') ? 'selected' : ''; ?>>YouTube Automation Training</option>
									<option value="AI Automation Training" <?php echo (($_POST['service_type'] ?? '') == 'AI Automation Training') ? 'selected' : ''; ?>>AI Automation Training</option>
								</select>
							</div>
							
							<div class="form-group">
								<label for="description">Describe What You Want <span class="required">*</span></label>
								<textarea class="form-control" id="description" name="description" rows="4" 
										  placeholder="Please provide detailed information about your project requirements, features, and any specific needs..." required><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
							</div>
							
							<div class="form-group">
								<label for="sample_url">Sample URL (if any)</label>
								<input type="url" class="form-control" id="sample_url" name="sample_url" 
									   placeholder="https://example.com" 
									   value="<?php echo htmlspecialchars($_POST['sample_url'] ?? ''); ?>">
							</div>
							
							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label for="budget">Budget for Project <span class="required">*</span></label>
										<select class="form-control" id="budget" name="budget" required>
											<option value="">Select budget range</option>
											<option value="Under $1,000" <?php echo (($_POST['budget'] ?? '') == 'Under $1,000') ? 'selected' : ''; ?>>Under $1,000</option>
											<option value="$1,000 - $5,000" <?php echo (($_POST['budget'] ?? '') == '$1,000 - $5,000') ? 'selected' : ''; ?>>$1,000 - $5,000</option>
											<option value="$5,000 - $10,000" <?php echo (($_POST['budget'] ?? '') == '$5,000 - $10,000') ? 'selected' : ''; ?>>$5,000 - $10,000</option>
											<option value="$10,000 - $25,000" <?php echo (($_POST['budget'] ?? '') == '$10,000 - $25,000') ? 'selected' : ''; ?>>$10,000 - $25,000</option>
											<option value="$25,000 - $50,000" <?php echo (($_POST['budget'] ?? '') == '$25,000 - $50,000') ? 'selected' : ''; ?>>$25,000 - $50,000</option>
											<option value="Over $50,000" <?php echo (($_POST['budget'] ?? '') == 'Over $50,000') ? 'selected' : ''; ?>>Over $50,000</option>
											<option value="To be discussed" <?php echo (($_POST['budget'] ?? '') == 'To be discussed') ? 'selected' : ''; ?>>To be discussed</option>
										</select>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label for="delivery_date">When do you need the project delivered? <span class="required">*</span></label>
										<select class="form-control" id="delivery_date" name="delivery_date" required>
											<option value="">Select timeline</option>
											<option value="ASAP (Rush job)" <?php echo (($_POST['delivery_date'] ?? '') == 'ASAP (Rush job)') ? 'selected' : ''; ?>>ASAP (Rush job)</option>
											<option value="Within 1 week" <?php echo (($_POST['delivery_date'] ?? '') == 'Within 1 week') ? 'selected' : ''; ?>>Within 1 week</option>
											<option value="Within 2 weeks" <?php echo (($_POST['delivery_date'] ?? '') == 'Within 2 weeks') ? 'selected' : ''; ?>>Within 2 weeks</option>
											<option value="Within 1 month" <?php echo (($_POST['delivery_date'] ?? '') == 'Within 1 month') ? 'selected' : ''; ?>>Within 1 month</option>
											<option value="Within 2-3 months" <?php echo (($_POST['delivery_date'] ?? '') == 'Within 2-3 months') ? 'selected' : ''; ?>>Within 2-3 months</option>
											<option value="More than 3 months" <?php echo (($_POST['delivery_date'] ?? '') == 'More than 3 months') ? 'selected' : ''; ?>>More than 3 months</option>
											<option value="Flexible timeline" <?php echo (($_POST['delivery_date'] ?? '') == 'Flexible timeline') ? 'selected' : ''; ?>>Flexible timeline</option>
										</select>
									</div>
								</div>
							</div>
							
							<div class="text-center">
								<button type="submit" class="btn btn-primary btn-submit">
									<i class="bi bi-send"></i> Submit Quote Request
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Quote Request Section -->
	
	<!-- Start Footer & Subscribe Section -->
	<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
								<li><a href="services.php">School Portal Development</a></li>
								<li><a href="services.php">Inventory Software</a></li>
								<li><a href="services.php">Web Applications</a></li>
								<li><a href="services.php">Digital Skills Training</a></li>
								<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
								<li><a href="about.php">About Us</a></li>
								<li><a href="portfolio.php">Portfolio</a></li>
								<li><a href="contact.php">Contact Us</a></li>
								<li><a href="privacy-policy.html">Privacy Policy</a></li>
								<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
								<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
								<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
								<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
					<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
</body>

</html>
<?php
// End of PHP processing
?>