<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';

// Handle contact form submission
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && (isset($_POST['submit_contact']) || isset($_POST['form_submitted']))) {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $service = trim($_POST['service'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');
    
    // Basic validation
    if (empty($name) || empty($email) || empty($service) || empty($subject) || empty($message)) {
        $error_message = 'Please fill in all required fields including the service you need.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error_message = 'Please enter a valid email address.';
    } else {
        try {
            // Use SMTP Mailer
            require_once 'users/config/smtp_mailer.php';
            
            $config = [
                'host' => 'omateqdigitals.com',
                'port' => 465,
                'username' => 'info@omateqdigitals.com',
                'password' => 'Terminal2025#',
                'encryption' => 'ssl',
                'from_email' => 'info@omateqdigitals.com',
                'from_name' => 'Omateq Digitals Contact Form',
                'reply_to' => $email
            ];
            
            $mailer = new SMTPMailer($config);
            
            // Email to admin
            $admin_subject = 'New Contact Form Submission - ' . $subject;
            $admin_message = createContactEmailTemplate($name, $email, $phone, $service, $subject, $message);
            
            $result = $mailer->send('info@omateqdigitals.com', $admin_subject, $admin_message, true);
            
            if ($result['success']) {
                $success_message = 'Thank you for your message! We will get back to you soon. Please check your email for a confirmation message.';
                
                // Send auto-reply to customer
                $customer_subject = 'Thank you for contacting Omateq Digitals';
                $customer_message = createCustomerReplyTemplate($name);
                
                $mailer->send($email, $customer_subject, $customer_message, true);
            } else {
                $error_message = 'Sorry, there was an error sending your message. Please try again later.';
            }
        } catch (Exception $e) {
            $error_message = 'Sorry, there was an error sending your message. Please try again later.';
        }
    }
}

function createContactEmailTemplate($name, $email, $phone, $service, $subject, $message) {
    // Convert service value to readable format
    $serviceNames = [
        'school-portal' => 'School Portal Development',
        'inventory-software' => 'Inventory Software Development',
        'web-applications' => 'Web Applications',
        'dynamic-websites' => 'Professional Dynamic Websites',
        'software-development' => 'Software Development',
        'customized-software' => 'Customized Software',
        'digital-training' => 'Digital Skills Training',
        'youtube-automation' => 'YouTube Automation Training',
        'ai-automation' => 'AI Automation Training',
        'other' => 'Other Services'
    ];
    
    $serviceDisplay = isset($serviceNames[$service]) ? $serviceNames[$service] : $service;
    
    return "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <style>
            body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background: #f8fafc; }
            .container { max-width: 700px; margin: 20px auto; padding: 0; }
            .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px 20px; text-align: center; border-radius: 12px 12px 0 0; }
            .content { background: #ffffff; padding: 30px; border-radius: 0 0 12px 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
            .field { margin-bottom: 20px; border-bottom: 1px solid #e5e7eb; padding-bottom: 15px; }
            .field:last-of-type { border-bottom: none; }
            .label { font-weight: 600; color: #374151; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 8px; }
            .value { font-size: 16px; color: #1f2937; padding: 12px; background: #f9fafb; border-radius: 8px; border-left: 4px solid #667eea; }
            .message-box { background: #f9fafb; padding: 20px; border-radius: 8px; border-left: 4px solid #667eea; margin-top: 10px; white-space: pre-wrap; }
            .priority-high { background: #fef2f2; border-left-color: #ef4444; }
            .priority-medium { background: #fffbeb; border-left-color: #f59e0b; }
            .priority-low { background: #f0fdf4; border-left-color: #10b981; }
            .footer { background: #f8fafc; padding: 20px; text-align: center; border-radius: 0 0 12px 12px; color: #64748b; font-size: 14px; }
            .contact-actions { background: #f0f9ff; padding: 20px; border-radius: 8px; margin: 20px 0; border: 1px solid #bae6fd; }
            .whatsapp-link { background: #25D366; color: white; padding: 12px 24px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block; margin: 10px 5px; }
            .email-link { background: #667eea; color: white; padding: 12px 24px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block; margin: 10px 5px; }
            h2 { margin: 0 0 10px 0; font-size: 28px; }
            .timestamp { font-size: 14px; color: #9ca3af; margin-top: 10px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>📧 New Contact Form Submission</h2>
                <p style='margin: 0; font-size: 16px;'>Omateq Digitals Website</p>
                <p class='timestamp'>" . date('F j, Y \a\t g:i A') . "</p>
            </div>
            <div class='content'>
                <div class='field'>
                    <div class='label'>👤 Customer Name</div>
                    <div class='value priority-high'>" . htmlspecialchars($name) . "</div>
                </div>
                <div class='field'>
                    <div class='label'>📧 Email Address</div>
                    <div class='value priority-high'>" . htmlspecialchars($email) . "</div>
                </div>
                <div class='field'>
                    <div class='label'>📱 Phone Number</div>
                    <div class='value priority-medium'>" . htmlspecialchars($phone ?: 'Not provided') . "</div>
                </div>
                <div class='field'>
                    <div class='label'>⚙️ Service Requested</div>
                    <div class='value priority-high'>" . htmlspecialchars($serviceDisplay) . "</div>
                </div>
                <div class='field'>
                    <div class='label'>🏷️ Subject</div>
                    <div class='value priority-medium'>" . htmlspecialchars($subject) . "</div>
                </div>
                <div class='field'>
                    <div class='label'>💬 Message</div>
                    <div class='message-box'>" . htmlspecialchars($message) . "</div>
                </div>
                
                <div class='contact-actions'>
                    <h3 style='margin: 0 0 15px 0; color: #1e40af;'>🎯 Quick Actions</h3>
                    <a href='mailto:" . htmlspecialchars($email) . "?subject=Re: " . urlencode($subject) . "' class='email-link'>
                        📧 Reply via Email
                    </a>
                    <a href='https://wa.me/2347069378861?text=New inquiry from " . urlencode($name) . " regarding " . urlencode($serviceDisplay) . "' class='whatsapp-link'>
                        💬 WhatsApp Response
                    </a>
                </div>
            </div>
            <div class='footer'>
                <p><strong>📊 Lead Information:</strong></p>
                <p>Service: " . htmlspecialchars($serviceDisplay) . " | Contact: " . htmlspecialchars($email) . "</p>
                <p><small>This message was sent from the contact form on omateqdigitals.com</small></p>
            </div>
        </div>
    </body>
    </html>";
}

function createCustomerReplyTemplate($name) {
    return "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px 20px; text-align: center; border-radius: 12px 12px 0 0; }
            .content { background: #ffffff; padding: 30px; border-radius: 0 0 12px 12px; border: 1px solid #e5e7eb; }
            .whatsapp-section { background: #25D366; color: white; padding: 20px; border-radius: 8px; margin: 20px 0; text-align: center; }
            .whatsapp-section a { color: white; text-decoration: none; font-weight: bold; }
            .footer { background: #f8fafc; padding: 20px; text-align: center; border-radius: 0 0 12px 12px; color: #64748b; }
            h2 { margin: 0 0 10px 0; font-size: 24px; }
            h3 { color: #1a202c; margin: 20px 0 10px 0; }
            .highlight { background: #f0f9ff; padding: 15px; border-left: 4px solid #667eea; margin: 15px 0; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>🎉 Thank You for Contacting Us!</h2>
                <p style='margin: 0; font-size: 16px;'>Omateq Digitals - Your Digital Transformation Partner</p>
            </div>
            <div class='content'>
                <p>Dear <strong>" . htmlspecialchars($name) . "</strong>,</p>
                
                <div class='highlight'>
                    <p style='margin: 0; font-weight: 600;'>✅ <strong>We have successfully received your message!</strong></p>
                    <p style='margin: 5px 0 0 0;'>Our team will review your inquiry and get back to you within 24 hours.</p>
                </div>
                
                <h3>📞 Need Immediate Assistance?</h3>
                <p>For urgent inquiries or faster response, please contact us directly:</p>
                
                <div class='whatsapp-section'>
                    <h4 style='margin: 0 0 10px 0;'>💬 WhatsApp Us Now!</h4>
                    <p style='margin: 0 0 15px 0; font-size: 18px;'>Get instant response from our team</p>
                    <a href='https://wa.me/2347069378861' style='background: white; color: #25D366; padding: 12px 24px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block;'>
                        📱 +234 706 937 8861
                    </a>
                </div>
                
                <h3>🕒 Response Time</h3>
                <ul>
                    <li><strong>Business Hours:</strong> Within 2-4 hours</li>
                    <li><strong>Evenings/Weekends:</strong> Within 24 hours</li>
                    <li><strong>WhatsApp:</strong> Usually within minutes</li>
                </ul>
                
                <h3>🚀 What Happens Next?</h3>
                <ol>
                    <li>Our team reviews your requirements</li>
                    <li>We prepare a customized proposal</li>
                    <li>We schedule a consultation call</li>
                    <li>We discuss your project in detail</li>
                </ol>
                
                <p>Thank you for considering Omateq Digitals for your digital needs. We're excited to work with you!</p>
            </div>
            <div class='footer'>
                <p><strong>Best regards,</strong><br>
                <strong>The Omateq Digitals Team</strong></p>
                <hr style='margin: 20px 0; border: none; border-top: 1px solid #e5e7eb;'>
                <p style='font-size: 12px; margin: 0;'>
                    This is an automated response. For urgent matters, please WhatsApp us at +2347069378861
                </p>
            </div>
        </div>
    </body>
    </html>";
}
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title>Contact Omateq Digitals - Web Development Company in Suleja, Nigeria | Get Quote</title>
	<meta name="description" content="Contact Omateq Digitals for web development, school portals, inventory software, and digital training. Located in Suleja, Niger State. Call +2347069378861 or email info@omateqdigitals.com">
	<meta name="keywords" content="contact omateq digitals, web development company Suleja, IT company contact Nigeria, software development quote, digital training inquiry, school portal consultation">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="Contact Omateq Digitals - Web Development Company in Nigeria">
	<meta property="og:description" content="Get in touch with our expert team for web development, software solutions, and digital training. Located in Suleja, Niger State.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/contact-og.jpg">
	<meta property="og:site_name" content="Omateq Digitals">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="Contact Omateq Digitals - Web Development Company">
	<meta name="twitter:description" content="Get in touch with our expert team for web development and digital training solutions.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/contact-og.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		.contact-info-content {
			text-align: center;
			padding: 30px 20px;
			background: #fff;
			border-radius: 10px;
			box-shadow: 0 5px 15px rgba(0,0,0,0.1);
			margin-bottom: 30px;
			transition: transform 0.3s ease;
		}
		.contact-info-content:hover {
			transform: translateY(-5px);
		}
		.contact-info-content h5 {
			color: #007bff;
			font-weight: 600;
			margin-bottom: 15px;
		}
		.contact-info-content p {
			color: #666;
			margin-bottom: 20px;
			line-height: 1.6;
		}
		.contact-info-content a {
			display: block;
			color: #333;
			text-decoration: none;
			margin-bottom: 10px;
			font-weight: 500;
			transition: color 0.3s ease;
		}
		.contact-info-content a:hover {
			color: #007bff;
		}
		.contact-form {
			background: #fff;
			padding: 40px;
			border-radius: 10px;
			box-shadow: 0 10px 30px rgba(0,0,0,0.1);
		}
		.form-group input,
		.form-group textarea {
			border: 2px solid #e9ecef;
			border-radius: 5px;
			padding: 12px 15px;
			font-size: 14px;
			transition: border-color 0.3s ease;
		}
		.form-group input:focus,
		.form-group textarea:focus {
			border-color: #007bff;
			box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
		
		/* Modern Contact Form Styles */
		.section-description {
			font-size: 1.1rem;
			color: #666;
			margin-top: 15px;
			max-width: 600px;
			margin-left: auto;
			margin-right: auto;
		}
		
		/* Modern Alert Styles */
		.modern-alert {
			display: flex;
			align-items: center;
			padding: 20px;
			border-radius: 12px;
			margin-bottom: 30px;
			border: none;
			box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
			animation: slideInDown 0.5s ease-out;
		}
		
		.alert-success {
			background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
			color: #155724;
		}
		
		.alert-danger {
			background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
			color: #721c24;
		}
		
		.alert-icon {
			font-size: 24px;
			margin-right: 15px;
		}
		
		.alert-content h5 {
			margin: 0 0 5px 0;
			font-weight: 600;
		}
		
		.alert-content p {
			margin: 0;
			font-size: 0.95rem;
		}
		
		/* Modern Contact Card */
		.modern-contact-card {
			background: #ffffff;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
			overflow: hidden;
			position: relative;
			backdrop-filter: blur(10px);
			border: 1px solid rgba(255, 255, 255, 0.2);
		}
		
		.modern-contact-card::before {
			content: '';
			position: absolute;
			top: 0;
			left: 0;
			right: 0;
			height: 4px;
			background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
		}
		
		/* Contact Card Header */
		.contact-card-header {
			text-align: center;
			padding: 40px 40px 20px;
			background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
		}
		
		.header-icon {
			width: 80px;
			height: 80px;
			margin: 0 auto 20px;
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			border-radius: 50%;
			display: flex;
			align-items: center;
			justify-content: center;
			color: white;
			font-size: 32px;
			box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
		}
		
		.contact-card-header h3 {
			font-size: 2rem;
			font-weight: 700;
			color: #1a202c;
			margin-bottom: 10px;
		}
		
		.contact-card-header p {
			color: #64748b;
			font-size: 1.1rem;
			margin: 0;
		}
		
		/* Modern Form Styles */
		.modern-contact-form {
			padding: 40px;
		}
		
		.form-grid {
			display: grid;
			grid-template-columns: 1fr 1fr;
			gap: 30px;
			margin-bottom: 40px;
		}
		
		.form-field-group {
			position: relative;
		}
		
		.form-field-group.full-width {
			grid-column: 1 / -1;
		}
		
		.field-label {
			display: flex;
			align-items: center;
			margin-bottom: 8px;
			font-weight: 600;
			color: #374151;
			font-size: 0.9rem;
			text-transform: uppercase;
			letter-spacing: 0.5px;
		}
		
		.field-label i {
			margin-right: 8px;
			color: #667eea;
			font-size: 0.8rem;
		}
		
		.required {
			color: #ef4444;
			margin-left: 4px;
		}
		
		/* Modern Input Styles */
		.modern-input,
		.modern-textarea {
			width: 100%;
			padding: 16px 20px;
			border: 2px solid #e5e7eb;
			border-radius: 12px;
			font-size: 1rem;
			color: #374151;
			background: #ffffff;
			transition: all 0.3s ease;
			outline: none;
			font-family: inherit;
		}
		
		.modern-input:focus,
		.modern-textarea:focus {
			border-color: #667eea;
			box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
			transform: translateY(-2px);
		}
		
		.modern-input::placeholder,
		.modern-textarea::placeholder {
			color: #9ca3af;
			font-style: italic;
		}
		
		.field-line {
			position: absolute;
			bottom: 0;
			left: 0;
			width: 0;
			height: 2px;
			background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
			transition: width 0.3s ease;
		}
		
		.modern-input:focus + .field-line,
		.modern-textarea:focus + .field-line {
			width: 100%;
		}
		
		/* Modern Select Styles */
		.select-wrapper {
			position: relative;
		}
		
		.modern-select {
			width: 100%;
			padding: 16px 50px 16px 20px;
			border: 2px solid #e5e7eb;
			border-radius: 12px;
			font-size: 1rem;
			color: #374151;
			background: #ffffff;
			transition: all 0.3s ease;
			outline: none;
			appearance: none;
			cursor: pointer;
		}
		
		.modern-select:focus {
			border-color: #667eea;
			box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
			transform: translateY(-2px);
		}
		
		.select-arrow {
			position: absolute;
			right: 20px;
			top: 50%;
			transform: translateY(-50%);
			color: #667eea;
			pointer-events: none;
			transition: transform 0.3s ease;
		}
		
		.modern-select:focus + .select-arrow {
			transform: translateY(-50%) rotate(180deg);
		}
		
		/* Modern Submit Button */
		.form-actions {
			text-align: center;
		}
		
		.modern-submit-btn {
			position: relative;
			display: inline-flex;
			align-items: center;
			gap: 12px;
			padding: 18px 40px;
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			color: white;
			border: none;
			border-radius: 50px;
			font-size: 1.1rem;
			font-weight: 600;
			cursor: pointer;
			transition: all 0.3s ease;
			overflow: hidden;
			box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
		}
		
		.modern-submit-btn:hover {
			transform: translateY(-3px);
			box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
		}
		
		.modern-submit-btn:active {
			transform: translateY(-1px);
		}
		
		.btn-icon {
			font-size: 1.2rem;
			transition: transform 0.3s ease;
		}
		
		.modern-submit-btn:hover .btn-icon {
			transform: translateX(5px);
		}
		
		.btn-ripple {
			position: absolute;
			top: 50%;
			left: 50%;
			width: 0;
			height: 0;
			border-radius: 50%;
			background: rgba(255, 255, 255, 0.3);
			transform: translate(-50%, -50%);
			transition: width 0.6s, height 0.6s;
		}
		
		.modern-submit-btn:active .btn-ripple {
			width: 300px;
			height: 300px;
		}
		
		.form-note {
			margin-top: 20px;
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 8px;
			color: #6b7280;
			font-size: 0.9rem;
		}
		
		.form-note i {
			color: #10b981;
		}
		
		/* Animations */
		@keyframes slideInDown {
			from {
				opacity: 0;
				transform: translateY(-30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}
		
		.modern-contact-card {
			animation: fadeInUp 0.8s ease-out;
		}
		
		@keyframes fadeInUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}
		
		/* Responsive Design */
		@media (max-width: 768px) {
			.form-grid {
				grid-template-columns: 1fr;
				gap: 20px;
			}
			
			.contact-card-header {
				padding: 30px 20px 15px;
			}
			
			.modern-contact-form {
				padding: 30px 20px;
			}
			
			.header-icon {
				width: 60px;
				height: 60px;
				font-size: 24px;
			}
			
			.contact-card-header h3 {
				font-size: 1.5rem;
			}
			
			.modern-submit-btn {
				padding: 16px 30px;
				font-size: 1rem;
			}
		}
		
		@media (max-width: 480px) {
			.modern-contact-form {
				padding: 20px 15px;
			}
			
			.contact-card-header {
				padding: 20px 15px 10px;
			}
			
			.modern-input,
			.modern-textarea,
			.modern-select {
				padding: 14px 16px;
			}
		}
	</style>
</head>

<body>

	<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
													<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
												<h2>Contact Us</h2>
												<ul>
													<li><a href="index.php">Home</a></li>
													<li>Contact</li>
												</ul>
												</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Contact Section -->
	<div class="contact-section section-padding">
		<div class="container">
			<div class="section-title text-center mb-5">
				<h6 class="sub-title">Let's Connect</h6>
				<h2>Get In Touch With Us</h2>
				<p class="section-description">Ready to transform your business? Send us a message and let's discuss your project.</p>
			</div>
			
			<!-- Success/Error Messages -->
			<?php if (!empty($success_message)): ?>
				<div class="alert alert-success modern-alert">
					<div class="alert-icon">
						<i class="fas fa-check-circle"></i>
					</div>
					<div class="alert-content">
						<h5>Success!</h5>
						<p><?php echo htmlspecialchars($success_message); ?></p>
					</div>
				</div>
			<?php endif; ?>
			
			<?php if (!empty($error_message)): ?>
				<div class="alert alert-danger modern-alert">
					<div class="alert-icon">
						<i class="fas fa-exclamation-triangle"></i>
					</div>
					<div class="alert-content">
						<h5>Error</h5>
						<p><?php echo htmlspecialchars($error_message); ?></p>
					</div>
				</div>
			<?php endif; ?>
			
			
			<div class="row justify-content-center">
				<div class="col-lg-10">
					<div class="modern-contact-card">
						<div class="contact-card-header">
							<div class="header-icon">
								<i class="fas fa-paper-plane"></i>
							</div>
							<h3>Send Us a Message</h3>
							<p>Fill out the form below and we'll get back to you within 24 hours</p>
						</div>
						
						<form id="contact-form" class="modern-contact-form" action="" method="POST">
							<div class="form-grid">
								<!-- Name Field -->
								<div class="form-field-group">
									<label for="name" class="field-label">
										<i class="fas fa-user"></i>
										<span>Full Name</span>
										<span class="required">*</span>
									</label>
									<input type="text" name="name" id="name" class="modern-input" required placeholder="Enter your full name">
									<div class="field-line"></div>
								</div>
								
								<!-- Email Field -->
								<div class="form-field-group">
									<label for="email" class="field-label">
										<i class="fas fa-envelope"></i>
										<span>Email Address</span>
										<span class="required">*</span>
									</label>
									<input type="email" name="email" id="email" class="modern-input" required placeholder="Enter your email address">
									<div class="field-line"></div>
								</div>
								
								<!-- Phone Field -->
								<div class="form-field-group">
									<label for="phone" class="field-label">
										<i class="fas fa-phone"></i>
										<span>Phone Number</span>
									</label>
									<input type="text" name="phone" id="phone" class="modern-input" placeholder="Enter your phone number">
									<div class="field-line"></div>
								</div>
								
								<!-- Service Field -->
								<div class="form-field-group">
									<label for="service" class="field-label">
										<i class="fas fa-cogs"></i>
										<span>Service Needed</span>
										<span class="required">*</span>
									</label>
									<div class="select-wrapper">
										<select name="service" id="service" class="modern-select" required>
											<option value="">Choose a service</option>
											<option value="school-portal">School Portal Development</option>
											<option value="inventory-software">Inventory Software Development</option>
											<option value="web-applications">Web Applications</option>
											<option value="dynamic-websites">Professional Dynamic Websites</option>
											<option value="software-development">Software Development</option>
											<option value="customized-software">Customized Software</option>
											<option value="digital-training">Digital Skills Training</option>
											<option value="youtube-automation">YouTube Automation Training</option>
											<option value="ai-automation">AI Automation Training</option>
											<option value="other">Other Services</option>
										</select>
										<div class="select-arrow">
											<i class="fas fa-chevron-down"></i>
										</div>
									</div>
									<div class="field-line"></div>
								</div>
								
								<!-- Subject Field -->
								<div class="form-field-group">
									<label for="subject" class="field-label">
										<i class="fas fa-tag"></i>
										<span>Subject</span>
										<span class="required">*</span>
									</label>
									<input type="text" name="subject" id="subject" class="modern-input" required placeholder="What's this about?">
									<div class="field-line"></div>
								</div>
								
								<!-- Message Field -->
								<div class="form-field-group full-width">
									<label for="message" class="field-label">
										<i class="fas fa-comment-alt"></i>
										<span>Your Message</span>
										<span class="required">*</span>
									</label>
									<textarea name="message" id="message" class="modern-textarea" rows="5" required placeholder="Tell us about your project or requirements..."></textarea>
									<div class="field-line"></div>
								</div>
							</div>
							
							<div class="form-actions">
								<!-- Hidden field to ensure form processing works -->
								<input type="hidden" name="form_submitted" value="1">
								
								<button type="submit" name="submit_contact" class="modern-submit-btn">
									<span class="btn-text">Send Message</span>
									<span class="btn-icon">
										<i class="fas fa-paper-plane"></i>
									</span>
									<div class="btn-ripple"></div>
								</button>
								<div class="form-note">
									<i class="fas fa-shield-alt"></i>
									<span>Your information is secure and will never be shared</span>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Contact Section -->
	
	<!-- Start Contact Info Section -->
	<section class="contact-info-wrapper bg-grey">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="section-title">
						<h6 class="sub-title">Find Us</h6>
						<h2>Contact Info</h2>
					</div>
				</div>
																				<div class="col-lg-6 col-md-6">
																					<div class="contact-info-content">
																						<h5>Suleja Office</h5>
																						<p>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja, Niger State, Nigeria.</p>
																						<a href="tel:+2347069378861">+234 706 937 8861</a>
																						<a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a>
																						<a href="mailto:omateqdigitals@gmail.com">omateqdigitals@gmail.com</a>
																					</div>
																				</div>
																				<div class="col-lg-6 col-md-6">
																					<div class="contact-info-content">
																						<h5>Head Office - Abuja</h5>
																						<p>Emeka Anyaokwu Street, Area 11, Garki, Abuja, FCT, Nigeria.</p>
																						<a href="tel:+2347069378861">+234 706 937 8861</a>
																						<a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a>
																						<a href="mailto:omateqdigitals@gmail.com">omateqdigitals@gmail.com</a>
																					</div>
																				</div>
			</div>
		</div>
    </section>
	<!-- End Contact Info Section -->
	
    <!-- Start Map Section -->
    <div class="map-section">
        <div class="google-map">
			<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15755.356960939265!2d7.2096018!3d9.1689706!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x104dd7ecaa48b593%3A0xfec768ed2fe4fdf9!2sOmateq%20Digitals!5e0!3m2!1sen!2sng!4v1758121288176!5m2!1sen!2sng" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </div>
    <!-- End Map Section -->
<!-- Start Footer & Subscribe Section -->
<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS - Disabled for normal form submission -->
	<!-- <script src="assets/js/ajax.mail.js"></script> -->
	
	<!-- Contact Form Enhancement Script -->
	<script>
		document.addEventListener('DOMContentLoaded', function() {
			const form = document.getElementById('contact-form');
			const submitBtn = form.querySelector('.modern-submit-btn');
			const btnText = submitBtn.querySelector('.btn-text');
			const btnIcon = submitBtn.querySelector('.btn-icon');
			
			// Add form submission feedback
			form.addEventListener('submit', function(e) {
				// Show loading state but don't disable the button yet
				btnText.textContent = 'Sending...';
				btnIcon.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
				
				// Disable the button after a short delay to allow form submission
				setTimeout(function() {
					submitBtn.disabled = true;
				}, 50);
			});
			
			// Add input validation feedback
			const inputs = form.querySelectorAll('input, select, textarea');
			inputs.forEach(input => {
				input.addEventListener('blur', function() {
					if (this.checkValidity()) {
						this.style.borderColor = '#10b981';
					} else {
						this.style.borderColor = '#ef4444';
					}
				});
				
				input.addEventListener('input', function() {
					if (this.checkValidity()) {
						this.style.borderColor = '#667eea';
					}
				});
			});
		});
	</script>
	
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<!-- Structured Data (JSON-LD) -->
	<script type="application/ld+json">
	{
		"@context": "https://schema.org",
		"@type": "ContactPage",
		"mainEntity": {
			"@type": "Organization",
			"name": "Omateq Digitals",
			"url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>",
			"logo": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/logo.png",
			"contactPoint": [
				{
					"@type": "ContactPoint",
					"telephone": "+2347069378861",
					"contactType": "customer service",
					"email": "info@omateqdigitals.com",
					"availableLanguage": "English",
					"areaServed": "NG"
				},
				{
					"@type": "ContactPoint",
					"telephone": "+2347069378861",
					"contactType": "sales",
					"email": "omateqdigitals@gmail.com",
					"availableLanguage": "English",
					"areaServed": "NG"
				}
			],
			"address": [
				{
					"@type": "PostalAddress",
					"streetAddress": "Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint",
					"addressLocality": "Suleja",
					"addressRegion": "Niger State",
					"addressCountry": "NG",
					"name": "Suleja Office"
				},
				{
					"@type": "PostalAddress",
					"streetAddress": "Emeka Anyaokwu Street, Area 11, Garki",
					"addressLocality": "Abuja",
					"addressRegion": "FCT",
					"addressCountry": "NG",
					"name": "Head Office - Abuja"
				}
			],
			"geo": {
				"@type": "GeoCoordinates",
				"latitude": "9.1689706",
				"longitude": "7.2096018"
			},
			"openingHours": "Mo-Fr 09:00-18:00",
			"sameAs": [
				"https://facebook.com/omateqdigitals",
				"https://youtube.com/@learnwithomateq",
				"https://www.linkedin.com/company/omateqdigitals"
			]
		}
	}
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>