<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
require_once 'admin-dashboard/config/database.php';

// Get all active courses from database
try {
    $pdo = getConnection();
    $stmt = $pdo->prepare("SELECT * FROM courses WHERE status = 'active' ORDER BY created_at DESC");
    $stmt->execute();
    $courses = $stmt->fetchAll();
} catch (Exception $e) {
    $courses = [];
    $error = "Database error: " . $e->getMessage();
}

// Currency conversion function
function convertToNaira($dollarAmount) {
    $exchangeRate = 1600; // 1 USD = 1600 NGN (approximate)
    return $dollarAmount * $exchangeRate;
}

// Format currency display
function formatCurrency($dollarAmount) {
    $nairaAmount = convertToNaira($dollarAmount);
    return [
        'dollar' => '$' . number_format($dollarAmount, 0),
        'naira' => '₦' . number_format($nairaAmount, 0)
    ];
}
?><!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- SEO Meta Tags -->
    <title>Digital Skills Training Courses - Web Development & AI Automation | Omateq Digitals</title>
    <meta name="description" content="Enroll in our comprehensive digital skills training courses including web development, AI automation, YouTube automation, and digital marketing. Expert-led training programs in Nigeria.">
    <meta name="keywords" content="digital skills training Nigeria, web development course, AI automation training, YouTube automation course, digital marketing training, programming course Nigeria, IT training Suleja">
    <meta name="author" content="Omateq Digitals">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="Digital Skills Training Courses - Web Development & AI Automation">
    <meta property="og:description" content="Comprehensive digital skills training courses designed to enhance your technical abilities and advance your career.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/courses-og.jpg">
    <meta property="og:site_name" content="Omateq Digitals">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Digital Skills Training Courses - Web Development & AI Automation">
    <meta name="twitter:description" content="Comprehensive digital skills training courses to advance your career.">
    <meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/courses-og.jpg">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Favicon -->
    <?php echo getFaviconHtml(); ?>
    <!-- Bootstrap Min CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!-- Animate Min CSS -->
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <!-- FlatIcon CSS -->
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <!-- Font Awesome Min CSS -->
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <!-- Bootstrap Icon CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap-icons.css">
    <!-- Mean Menu CSS -->
    <link rel="stylesheet" href="assets/css/meanmenu.css">
    <!-- Magnific Popup Min CSS -->
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <!-- Swiper Min CSS -->
    <link rel="stylesheet" href="assets/css/swiper.min.css">
    <!-- Owl Carousel Min CSS -->
    <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
    <!-- Style CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- Responsive CSS -->
    <link rel="stylesheet" href="assets/css/responsive.css">
    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8fafc;
        }
        
        /* Navbar scroll effect styles */
        .navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
        
        .navbar-section.scrolled {
            padding: 5px 0;
        background: #00022E !important; }
        
        .navbar-section.scrolled .navbar-brand img,
        .navbar-section.scrolled .logo img {
            height: 40px !important;
            width: auto !important;
            transition: all 0.3s ease-in-out;
        }
        
        .navbar-section.scrolled .navbar {
            padding: 5px 0;
        }
        
        .navbar-section.scrolled .navbar-nav .nav-link {
            padding: 8px 15px;
            font-size: 14px;
        }
        
        .navbar-section.scrolled .default-btn {
            padding: 8px 20px;
            font-size: 14px;
        }
        
        /* Initial logo size */
        .navbar-brand img,
        .logo img {
            height: 60px;
            width: auto;
            transition: all 0.3s ease-in-out;
        }
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
        
        /* Add top padding to body to account for fixed navbar */
        body {
            padding-top: 80px;
        }
        
        /* Navigation menu black color styles */
        .navbar-section .navbar-nav .nav-link {
            color: #ffffff !important;
            font-weight: 500;
        }
        
        .navbar-section .navbar-nav .nav-link:hover {
            color: #007bff !important;
        }
        
        .navbar-section .navbar-nav .nav-link.active {
            color: #007bff !important;
            font-weight: 600;
        }
        
        .navbar-section .navbar-brand {
            color: #ffffff !important;
        }
        
        .navbar-section .default-btn {
            color: #fff !important;
            background: #007bff;
            border: none;
        }
        
        .navbar-section .default-btn:hover {
            background: #0056b3;
            color: #fff !important;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .courses-header {
            text-align: center;
            padding: 60px 0 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            margin-top: 0;
        }
        
        .courses-header h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .courses-header p {
            font-size: 1.2rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .courses-section {
            padding: 80px 0;
        }
        
        .courses-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }
        
        .course-card {
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            border: 1px solid #e2e8f0;
        }
        
        .course-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }
        
        .course-image {
            position: relative;
            height: 200px;
            overflow: hidden;
        }
        
        .course-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }
        
        .course-card:hover .course-image img {
            transform: scale(1.05);
        }
        
        .course-category {
            position: absolute;
            top: 16px;
            left: 16px;
            background: #10b981;
            color: white;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .course-content {
            padding: 24px;
        }
        
        .course-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #1a202c;
            margin-bottom: 12px;
            line-height: 1.4;
        }
        
        .course-meta {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .course-duration,
        .course-price {
            display: flex;
            align-items: center;
            gap: 6px;
            color: #64748b;
            font-size: 0.9rem;
        }
        
        .course-duration i,
        .course-price i {
            font-size: 1.1rem;
            color: #667eea;
        }
        
        .course-price {
            font-weight: 600;
            color: #1a202c;
        }
        
        .course-actions {
            display: flex;
            gap: 12px;
        }
        
        .btn-primary,
        .btn-secondary {
            flex: 1;
            padding: 12px 20px;
            border: none;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            text-align: center;
            transition: all 0.2s ease;
            cursor: pointer;
            font-size: 0.9rem;
        }
        
        .btn-primary {
            background: #667eea;
            color: white;
        }
        
        .btn-primary:hover {
            background: #5a67d8;
            transform: translateY(-1px);
        }
        
        .btn-secondary {
            background: #f1f5f9;
            color: #475569;
            border: 1px solid #e2e8f0;
        }
        
        .btn-secondary:hover {
            background: #e2e8f0;
        }
        
        .no-courses {
            text-align: center;
            padding: 60px 20px;
            color: #64748b;
        }
        
        .no-courses h3 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #374151;
        }
        
        .no-courses p {
            font-size: 1.1rem;
        }
        
        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .courses-header {
                padding: 40px 0 60px;
            }
            
            .navbar-section.scrolled .navbar-brand img,
            .navbar-section.scrolled .logo img {
                height: 35px !important;
            }
            
            .navbar-brand img,
            .logo img {
                height: 50px;
            }
            
            .courses-header h1 {
                font-size: 2rem;
            }
            
            .courses-header p {
                font-size: 1rem;
            }
            
            .courses-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
            
            .course-actions {
                flex-direction: column;
            }
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
		
		/* Mobile Card Layout */
		@media (max-width: 768px) {
			.course-table-section {
				padding: 40px 0 !important;
			}
			
			.section-header h2 {
				font-size: 2rem !important;
				margin-bottom: 10px !important;
			}
			
			.section-header p {
				font-size: 1rem !important;
				padding: 0 20px;
			}
			
			.table-responsive {
				display: none !important;
			}
			
			.courses-mobile-grid {
				display: grid !important;
				grid-template-columns: 1fr 1fr;
				gap: 15px;
				padding: 0 15px;
			}
			
			.course-mobile-card {
				background: white;
				border-radius: 12px;
				padding: 15px;
				box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
				transition: all 0.3s ease;
				border: 1px solid #e2e8f0;
			}
			
			.course-mobile-card:hover {
				transform: translateY(-2px);
				box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
			}
			
			.course-mobile-image {
				width: 100%;
				height: 120px;
				object-fit: cover;
				border-radius: 8px;
				margin-bottom: 12px;
			}
			
			.course-mobile-title {
				font-size: 0.9rem;
				font-weight: 600;
				color: #1a202c;
				margin: 0 0 8px 0;
				line-height: 1.3;
				display: -webkit-box;
				-webkit-line-clamp: 2;
				-webkit-box-orient: vertical;
				overflow: hidden;
			}
			
			.course-mobile-meta {
				display: flex;
				justify-content: space-between;
				align-items: center;
				margin-bottom: 12px;
				font-size: 0.75rem;
			}
			
			.course-mobile-level {
				background: #e0e7ff;
				color: #3730a3;
				padding: 3px 8px;
				border-radius: 12px;
				font-weight: 600;
				text-transform: uppercase;
				letter-spacing: 0.5px;
			}
			
			.course-mobile-price {
				font-weight: 600;
				color: #1a202c;
			}
			
			.course-mobile-duration {
				color: #64748b;
				font-size: 0.7rem;
				margin-bottom: 12px;
			}
			
			.course-mobile-actions {
				display: flex;
				gap: 8px;
			}
			
			.course-mobile-btn {
				flex: 1;
				padding: 8px 12px;
				border-radius: 6px;
				font-size: 0.75rem;
				font-weight: 500;
				text-align: center;
				text-decoration: none;
				transition: all 0.3s ease;
				border: none;
				cursor: pointer;
			}
			
			.course-mobile-btn.enroll {
				background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
				color: white;
			}
			
			.course-mobile-btn.details {
				background: #f1f5f9;
				color: #475569;
				border: 1px solid #e2e8f0;
			}
			
			.course-mobile-btn:hover {
				transform: translateY(-1px);
			}
			
			.course-mobile-btn.enroll:hover {
				box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
			}
			
			.course-mobile-btn.details:hover {
				background: #e2e8f0;
			}
		}
		
		@media (max-width: 480px) {
			.courses-mobile-grid {
				grid-template-columns: 1fr !important;
				gap: 12px;
				padding: 0 10px;
			}
			
			.course-mobile-card {
				padding: 12px;
			}
			
			.course-mobile-image {
				height: 100px;
			}
			
			.course-mobile-title {
				font-size: 0.85rem;
			}
		}
		
		/* Course Table Styles */
		.course-table-section {
			padding: 80px 0;
			background: #f8fafc;
		}
		
		.section-header {
			text-align: center;
			margin-bottom: 50px;
		}
		
		.section-header h2 {
			font-size: 2.5rem;
			color: #1a202c;
			margin-bottom: 15px;
			font-weight: 700;
		}
		
		.section-header p {
			font-size: 1.1rem;
			color: #64748b;
			max-width: 600px;
			margin: 0 auto;
		}
		
		.course-table {
			width: 100%;
			background: white;
			border-radius: 12px;
			overflow: hidden;
			box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
			border-collapse: collapse;
		}
		
		.course-table thead {
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
		}
		
		.course-table th {
			padding: 20px 15px;
			text-align: left;
			font-weight: 600;
			color: white;
			font-size: 0.95rem;
			letter-spacing: 0.5px;
		}
		
		.course-table tbody tr {
			border-bottom: 1px solid #e2e8f0;
			transition: all 0.3s ease;
		}
		
		.course-table tbody tr:hover {
			background: #f8fafc;
			transform: translateY(-2px);
			box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
		}
		
		.course-table tbody tr:last-child {
			border-bottom: none;
		}
		
		.course-table td {
			padding: 20px 15px;
			vertical-align: middle;
		}
		
		.course-info {
			display: flex;
			align-items: center;
			gap: 15px;
		}
		
		.course-thumb {
			width: 60px;
			height: 60px;
			object-fit: cover;
			border-radius: 8px;
			box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
		}
		
		.course-details h4 {
			font-size: 1.1rem;
			font-weight: 600;
			color: #1a202c;
			margin: 0 0 5px 0;
		}
		
		.course-details p {
			font-size: 0.9rem;
			color: #64748b;
			margin: 0;
			line-height: 1.4;
		}
		
		.level-badge {
			display: inline-block;
			padding: 6px 12px;
			border-radius: 20px;
			font-size: 0.8rem;
			font-weight: 600;
			text-transform: uppercase;
			letter-spacing: 0.5px;
		}
		
		.level-beginner {
			background: #dcfce7;
			color: #166534;
		}
		
		.level-intermediate {
			background: #fef3c7;
			color: #92400e;
		}
		
		.level-advanced {
			background: #fecaca;
			color: #991b1b;
		}
		
		.level-general {
			background: #e0e7ff;
			color: #3730a3;
		}
		
		.price-info {
			display: flex;
			flex-direction: column;
			gap: 2px;
		}
		
		.price-dollar {
			font-weight: 600;
			color: #1a202c;
			font-size: 1rem;
		}
		
		.price-naira {
			font-size: 0.85rem;
			color: #64748b;
		}
		
		.status-badge {
			display: inline-block;
			padding: 6px 12px;
			border-radius: 20px;
			font-size: 0.8rem;
			font-weight: 600;
			text-transform: uppercase;
			letter-spacing: 0.5px;
		}
		
		.status-active {
			background: #dcfce7;
			color: #166534;
		}
		
		.action-buttons {
			display: flex;
			gap: 8px;
			align-items: center;
		}
		
		.btn-enroll {
			background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
			color: white;
			padding: 8px 16px;
			border-radius: 6px;
			text-decoration: none;
			font-size: 0.85rem;
			font-weight: 500;
			transition: all 0.3s ease;
			border: none;
			cursor: pointer;
		}
		
		.btn-enroll:hover {
			transform: translateY(-2px);
			box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
			color: white;
		}
		
		.btn-details {
			background: #f1f5f9;
			color: #475569;
			padding: 8px 16px;
			border-radius: 6px;
			border: 1px solid #e2e8f0;
			font-size: 0.85rem;
			font-weight: 500;
			transition: all 0.3s ease;
			cursor: pointer;
		}
		
		.btn-details:hover {
			background: #e2e8f0;
			transform: translateY(-2px);
		}
		
		.no-data {
			text-align: center;
			padding: 60px 20px !important;
		}
		
		.no-courses-table {
			display: flex;
			flex-direction: column;
			align-items: center;
			gap: 20px;
		}
		
		.no-courses-table i {
			font-size: 3rem;
			color: #94a3b8;
		}
		
		.no-courses-table h3 {
			color: #475569;
			margin: 0;
		}
		
		.no-courses-table p {
			color: #94a3b8;
			margin: 0;
		}
		
		/* Responsive Table */
		.table-responsive {
			overflow-x: auto;
			border-radius: 12px;
		}
		
		@media (max-width: 768px) {
			.course-table th,
			.course-table td {
				padding: 15px 10px;
			}
			
			.course-info {
				flex-direction: column;
				text-align: center;
				gap: 10px;
			}
			
			.course-thumb {
				width: 50px;
				height: 50px;
			}
			
			.course-details h4 {
				font-size: 1rem;
			}
			
			.course-details p {
				font-size: 0.8rem;
			}
			
			.action-buttons {
				flex-direction: column;
				gap: 5px;
			}
			
			.btn-enroll,
			.btn-details {
				width: 100%;
				text-align: center;
			}
		}
	</style>
</head>
<body>
    <!-- Start Navbar Section -->
    <div class="navbar-section">
        <div class="techvio-responsive-nav">
            <div class="container">
                <div class="techvio-responsive-menu">
                    <div class="logo">
                        <a href="index.php">
                            <?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
                            <?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="techvio-nav">
            <div class="container">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="index.php">
                        <?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
                        <?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
                    </a>
                    <div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
                        <ul class="navbar-nav">
                            <li class="nav-item"> 
                                <a href="index.php" class="nav-link">Home</a>
                            </li>
                            <li class="nav-item">
                                <a href="about.php" class="nav-link">About</a>
                            </li>
                            <li class="nav-item">
                                <a href="services.php" class="nav-link">Services</a>
                            </li>
                            <li class="nav-item">
                                <a href="portfolio.php" class="nav-link">Portfolio</a>
                            </li>
                            <li class="nav-item"> 
                                <a href="products.php" class="nav-link">Products</a>
                            </li>
                            <li class="nav-item">
                                <a href="course.php" class="nav-link active">Courses</a>
                            </li>
                            <li class="nav-item">
                                <a href="contact.php" class="nav-link">Contact</a>
                            </li>
                        </ul>
                        <div class="other-option">
                            <a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Navbar Section -->
    
    <!-- Courses Header -->
    <section class="courses-header">
        <div class="container">
            <h1>Our Courses</h1>
            <p>Discover our comprehensive range of courses designed to enhance your skills and advance your career</p>
        </div>
    </section>

    <!-- Course Table Section -->
    <section class="course-table-section" style="padding: 80px 0; background: #f8fafc;">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 50px;">
                <h2 style="font-size: 2.5rem; color: #1a202c; margin-bottom: 15px; font-weight: 700;">Course Overview</h2>
                <p style="font-size: 1.1rem; color: #64748b; max-width: 600px; margin: 0 auto;">Quick overview of all available courses in a structured table format</p>
            </div>
            
            <div class="table-responsive" style="overflow-x: auto; border-radius: 12px;">
                <table class="course-table" style="width: 100%; background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border-collapse: collapse;">
                    <thead style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                        <tr>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Course</th>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Level</th>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Duration</th>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Price</th>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Status</th>
                            <th style="padding: 20px 15px; text-align: left; font-weight: 600; color: white; font-size: 0.95rem; letter-spacing: 0.5px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($courses)): ?>
                            <?php foreach ($courses as $course): ?>
                                <tr style="border-bottom: 1px solid #e2e8f0; transition: all 0.3s ease;">
                                    <td style="padding: 20px 15px; vertical-align: middle;">
                                        <div class="course-info">
                                            <img src="<?php echo $course['thumbnail'] ?: 'assets/img/courses/default.jpg'; ?>" 
                                                 alt="<?php echo htmlspecialchars($course['title']); ?>" 
                                                 class="course-thumb">
                                            <div class="course-details">
                                                <h4><?php echo htmlspecialchars($course['title']); ?></h4>
                                                <p><?php echo htmlspecialchars(substr($course['description'] ?: 'No description available', 0, 80)) . '...'; ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td style="padding: 20px 15px; vertical-align: middle;">
                                        <span class="level-badge level-<?php echo strtolower($course['level'] ?: 'general'); ?>" style="display: inline-block; padding: 6px 12px; border-radius: 20px; font-size: 0.8rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; background: #e0e7ff; color: #3730a3;">
                                            <?php echo strtoupper($course['level'] ?: 'GENERAL'); ?>
                                        </span>
                                    </td>
                                    <td style="padding: 20px 15px; vertical-align: middle;"><?php echo htmlspecialchars($course['duration'] ?: 'Self-paced'); ?></td>
                                    <td style="padding: 20px 15px; vertical-align: middle;">
                                        <div class="price-info" style="display: flex; flex-direction: column; gap: 2px;">
                                            <span class="price-dollar" style="font-weight: 600; color: #1a202c; font-size: 1rem;"><?php echo formatCurrency($course['price'])['dollar']; ?></span>
                                            <span class="price-naira" style="font-size: 0.85rem; color: #64748b;"><?php echo formatCurrency($course['price'])['naira']; ?></span>
                                        </div>
                                    </td>
                                    <td style="padding: 20px 15px; vertical-align: middle;">
                                        <span class="status-badge status-active" style="display: inline-block; padding: 6px 12px; border-radius: 20px; font-size: 0.8rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; background: #dcfce7; color: #166534;">
                                            <?php echo ucfirst($course['status'] ?: 'Active'); ?>
                                        </span>
                                    </td>
                                    <td style="padding: 20px 15px; vertical-align: middle;">
                                        <div class="action-buttons" style="display: flex; gap: 8px; align-items: center;">
                                            <a href="users/authentication/register.php?course_id=<?php echo $course['id']; ?>" 
                                               class="btn-enroll" target="_blank" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 8px 16px; border-radius: 6px; text-decoration: none; font-size: 0.85rem; font-weight: 500; transition: all 0.3s ease; border: none; cursor: pointer;">Enroll</a>
                                            <button class="btn-details" 
                                                    onclick="openCourseModal(<?php echo htmlspecialchars(json_encode($course)); ?>)" 
                                                    style="background: #f1f5f9; color: #475569; padding: 8px 16px; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.85rem; font-weight: 500; transition: all 0.3s ease; cursor: pointer;">
                                                Details
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="no-data">
                                    <div class="no-courses-table">
                                        <i class="fas fa-book-open"></i>
                                        <h3>No Courses Available</h3>
                                        <p>We're currently updating our course catalog. Please check back soon!</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Card Layout -->
            <div class="courses-mobile-grid" style="display: none;">
                <?php if (!empty($courses)): ?>
                    <?php foreach ($courses as $course): ?>
                        <div class="course-mobile-card">
                            <img src="<?php echo $course['thumbnail'] ?: 'assets/img/courses/default.jpg'; ?>" 
                                 alt="<?php echo htmlspecialchars($course['title']); ?>" 
                                 class="course-mobile-image">
                            
                            <h3 class="course-mobile-title"><?php echo htmlspecialchars($course['title']); ?></h3>
                            
                            <div class="course-mobile-meta">
                                <span class="course-mobile-level"><?php echo strtoupper($course['level'] ?: 'GENERAL'); ?></span>
                                <span class="course-mobile-price"><?php echo formatCurrency($course['price'])['dollar']; ?></span>
                            </div>
                            
                            <div class="course-mobile-duration">
                                <i class="fas fa-clock" style="margin-right: 5px;"></i>
                                <?php echo htmlspecialchars($course['duration'] ?: 'Self-paced'); ?>
                            </div>
                            
                            <div class="course-mobile-actions">
                                <a href="users/authentication/register.php?course_id=<?php echo $course['id']; ?>" 
                                   class="course-mobile-btn enroll" target="_blank">
                                    Enroll
                                </a>
                                <button class="course-mobile-btn details" 
                                        onclick="openCourseModal(<?php echo htmlspecialchars(json_encode($course)); ?>)">
                                    Details
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="no-courses-mobile" style="grid-column: 1 / -1; text-align: center; padding: 40px 20px;">
                        <i class="fas fa-book-open" style="font-size: 3rem; color: #94a3b8; margin-bottom: 20px;"></i>
                        <h3 style="color: #475569; margin: 0 0 10px 0;">No Courses Available</h3>
                        <p style="color: #94a3b8; margin: 0;">We're currently updating our course catalog. Please check back soon!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Course Details Modal -->
    <div id="courseModal" class="modal" style="display: none;">
        <div class="modal-content" style="background: white; max-width: 600px; margin: 50px auto; padding: 30px; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2 id="modalTitle" style="color: #1a202c; font-size: 1.5rem;">Course Details</h2>
                <button onclick="closeCourseModal()" style="background: none; border: none; font-size: 24px; cursor: pointer; color: #64748b;">&times;</button>
            </div>
            <div id="modalBody">
                <!-- Course details will be populated here -->
            </div>
        </div>
    </div>

    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar-section');
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            if (scrollTop > 100) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });
        
        function openCourseModal(course) {
            const modal = document.getElementById('courseModal');
            const modalTitle = document.getElementById('modalTitle');
            const modalBody = document.getElementById('modalBody');
            
            modalTitle.textContent = course.title;
            
            const currency = {
                dollar: '$' + parseFloat(course.price).toFixed(0),
                naira: '₦' + (parseFloat(course.price) * 1600).toFixed(0)
            };
            
            modalBody.innerHTML = `
                <div style="margin-bottom: 20px;">
                    <img src="${course.thumbnail || 'assets/img/courses/default.jpg'}" 
                         alt="${course.title}" 
                         style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px;">
                </div>
                <div style="margin-bottom: 20px;">
                    <h3 style="color: #1a202c; margin-bottom: 12px;">${course.title}</h3>
                    <p style="color: #64748b; line-height: 1.6;">${course.description || 'No description available.'}</p>
                </div>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 16px; margin-bottom: 24px;">
                    <div style="padding: 12px; background: #f8fafc; border-radius: 8px; text-align: center;">
                        <div style="font-weight: 600; color: #1a202c; margin-bottom: 4px;">Duration</div>
                        <div style="color: #64748b;">${course.duration || 'Self-paced'}</div>
                    </div>
                    <div style="padding: 12px; background: #f8fafc; border-radius: 8px; text-align: center;">
                        <div style="font-weight: 600; color: #1a202c; margin-bottom: 4px;">Level</div>
                        <div style="color: #64748b;">${course.level || 'General'}</div>
                    </div>
                    <div style="padding: 12px; background: #f8fafc; border-radius: 8px; text-align: center;">
                        <div style="font-weight: 600; color: #1a202c; margin-bottom: 4px;">Price</div>
                        <div style="color: #64748b;">${currency.dollar} / ${currency.naira}</div>
                    </div>
                </div>
                <div style="text-align: center;">
                    <a href="users/authentication/register.php?course_id=${course.id}" 
                       style="display: inline-block; background: #667eea; color: white; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: 500; margin-right: 12px;">
                        Enroll Now
                    </a>
                    <button onclick="closeCourseModal()" 
                            style="background: #f1f5f9; color: #475569; border: 1px solid #e2e8f0; padding: 12px 24px; border-radius: 8px; cursor: pointer; font-weight: 500;">
                        Close
                    </button>
                </div>
            `;
            
            modal.style.display = 'block';
        }
        
        function closeCourseModal() {
            document.getElementById('courseModal').style.display = 'none';
        }
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('courseModal');
            if (event.target === modal) {
                closeCourseModal();
            }
        }
    </script>
    
    <!-- Start Footer & Subscribe Section -->
    <section class="footer-subscribe-wrapper">
        <!-- Start Subscribe Section -->
        <div class="subscribe-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6">
                        <div class="subscribe-content">
                            <h2>Stay Updated with Omateq Digitals</h2>
                            <p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <form class="newsletter-form">
                            <input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
                            <button type="submit">Subscribe Now</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Subscribe Section -->
        <!-- Start Footer Section -->
        <div class="footer-area ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="single-footer-widget">
                            <a class="footer-logo" href="index.php">
                                <?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
                            </a>
                            <p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
                            <ul class="footer-social">
                                <li>
                                    <a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li>
                                    <a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
                                </li>
                                <li>
                                    <a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6">
                        <div class="single-footer-widget">
                            <div class="footer-heading">
                                <h3>Our Services</h3>
                            </div>
                            <ul class="footer-quick-links">
                                <li><a href="services.php">School Portal Development</a></li>
                                <li><a href="services.php">Inventory Software</a></li>
                                <li><a href="services.php">Web Applications</a></li>
                                <li><a href="services.php">Digital Skills Training</a></li>
                                <li><a href="services.php">AI Automation Training</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6">
                        <div class="single-footer-widget">
                            <div class="footer-heading">
                                <h3>Useful Links</h3>
                            </div>
                            <ul class="footer-quick-links">
                                <li><a href="about.php">About Us</a></li>
                                <li><a href="portfolio.php">Portfolio</a></li>
                                <li><a href="contact.php">Contact Us</a></li>
                                <li><a href="privacy-policy.html">Privacy Policy</a></li>
                                <li><a href="terms-condition.html">Terms & Conditions</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="single-footer-widget">
                            <div class="footer-heading">
                                <h3>Contact Info</h3>
                            </div>
                            <div class="footer-info-contact">
                                <i class="flaticon-phone-call"></i>
                                <h3>Phone</h3>
                                <span><a href="tel:+2347069378861">+2347069378861</a></span>
                            </div>
                            <div class="footer-info-contact">
                                <i class="flaticon-envelope"></i>
                                <h3>Email</h3>
                                <span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
                            </div>
                            <div class="footer-info-contact">
                                <i class="flaticon-placeholder"></i>
                                <h3>Address</h3>
                                <span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Footer Section -->
    </section>
    <!-- End Footer & Subscribe Section -->
    
    <!-- Start Copy Right Section -->
    <div class="copyright-area">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
                </div>
                <div class="col-lg-6 col-md-6">
                    <ul>
                        <li><a href="terms-condition.html">Terms & Conditions</a></li>
                        <li><a href="privacy-policy.html">Privacy Policy</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- End Copy Right Section -->
    
    <!-- Start Go Top Section -->
    <div class="go-top">
        <i class="fas fa-chevron-up"></i>
        <i class="fas fa-chevron-up"></i>
    </div>
    <!-- End Go Top Section -->
    
    <!-- jQuery Min JS -->
    <script src="assets/js/jquery.min.js"></script>
    <!-- Popper Min JS -->
    <script src="assets/js/popper.min.js"></script>
    <!-- Bootstrap Min JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <!-- Mean Menu JS  -->
    <script src="assets/js/jquery.meanmenu.js"></script>
    <!-- Appear Min JS -->
    <script src="assets/js/jquery.appear.min.js"></script>
    <!-- CounterUp Min JS -->
    <script src="assets/js/jquery.waypoints.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <!-- Owl Carousel Min JS -->
    <script src="assets/js/owl.carousel.min.js"></script>
    <!-- Magnific Popup Min JS -->
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <!-- Isotope Min JS -->
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <!-- Swiper Min JS -->
    <script src="assets/js/swiper.min.js"></script>
    <!-- Vanilla Tilt Min JS -->
    <script src="assets/js/vanilla-tilt.min.js"></script>
    <!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
    <!-- WOW Min JS -->
    <script src="assets/js/wow.min.js"></script>
    <!-- Ajax Mail JS -->
    <script src="assets/js/ajax.mail.js"></script>
    <!-- Main JS -->
    <script src="assets/js/main.js"></script>
</body>
</html>
<?php
// End of PHP processing
?>