<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
?>
<!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title><?php echo getSetting('site_name', 'Omateq Digitals'); ?> - Web Development, Software Solutions & Digital Training in Nigeria</title>
	<meta name="description" content="Omateq Digitals is Nigeria's leading web development company specializing in school portals, inventory software, custom web applications, and digital skills training. Transform your business with our expert IT solutions.">
	<meta name="keywords" content="web development Nigeria, school portal development, inventory software, custom web applications, digital skills training, software development Abuja, IT solutions Nigeria, web design Suleja, AI automation training, YouTube automation">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	<meta name="revisit-after" content="7 days">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="<?php echo getSetting('site_name', 'Omateq Digitals'); ?> - Web Development & IT Solutions">
	<meta property="og:description" content="Leading web development company in Nigeria offering school portals, inventory software, custom applications, and digital training. Transform your business today.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/og-image.jpg">
	<meta property="og:image:width" content="1200">
	<meta property="og:image:height" content="630">
	<meta property="og:site_name" content="Omateq Digitals">
	<meta property="og:locale" content="en_NG">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="<?php echo getSetting('site_name', 'Omateq Digitals'); ?> - Web Development & IT Solutions">
	<meta name="twitter:description" content="Leading web development company in Nigeria offering school portals, inventory software, custom applications, and digital training.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/og-image.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	
	<!-- Geo Tags -->
	<meta name="geo.region" content="NG">
	<meta name="geo.placename" content="Suleja, Niger State, Nigeria">
	<meta name="geo.position" content="9.1689706;7.2096018">
	<meta name="ICBM" content="9.1689706, 7.2096018">
	
	<!-- Business Contact Info -->
	<meta name="contact" content="info@omateqdigitals.com">
	<meta name="phone" content="+2347069378861">
	<meta name="address" content="Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja, Niger State, Nigeria">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
			background: #00022E !important;
		}
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu white color styles for dark navy background */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #000 !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
	</style>
</head>

<body>
	<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
							<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Home Section -->
	<div class="home-4 home-section">
		<div id="particles-js"></div>
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-12">
							<div class="main-banner-content">
									<h1>Leading Web Development Company in Nigeria - Omateq Digitals</h1>
									<p>Transform your business with our expert web development solutions, custom software development, and digital skills training. From school portals to inventory management systems, we bring your digital vision to life with 7+ years of experience.</p>
								<div class="banner-btn">
									<a class="default-btn-one" href="services.php">Our Service <span></span></a>
									<a class="default-btn-two" href="users/authentication/login.php"> Account<span></span></a>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-md-12">
							<div class="banner-image">
								<img src="assets/img/home-font.png" alt="Omateq Digitals - Web Development Company" class="hero-image">
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Home Section -->
	
	<!-- Start Services Four Section -->
	<section class="services-section-four section-padding">
		<div class="container">
			<div class="row">
                <div class="col-md-12">
					<div class="section-title">
						<h6 class="sub-title">What We Provide</h6>
						<h2>Professional IT Services & Digital Solutions in Nigeria</h2>
					</div>
                </div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-1.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>School Portal Development</h3>
											<p>Comprehensive school management systems that streamline administrative tasks and enhance educational experiences.</p>
											<ul class="features-list">
												<li><span>Student Management System</span></li>
												<li><span>Grade & Attendance Tracking</span></li>
												<li><span>Parent-Teacher Communication</span></li>
												<li><span>Online Learning Platform</span></li>
												<li><span>Fee Management System</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-2.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>Inventory Software Development</h3>
											<p>Custom inventory management solutions designed to optimize your business operations and reduce costs.</p>
											<ul class="features-list">
												<li><span>Real-time Stock Tracking</span></li>
												<li><span>Automated Reorder Points</span></li>
												<li><span>Multi-location Support</span></li>
												<li><span>Barcode Integration</span></li>
												<li><span>Analytics & Reporting</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-3.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>Web Applications</h3>
											<p>Modern, responsive web applications built with cutting-edge technologies for optimal performance.</p>
											<ul class="features-list">
												<li><span>Progressive Web Apps</span></li>
												<li><span>API Development</span></li>
												<li><span>Database Integration</span></li>
												<li><span>User Authentication</span></li>
												<li><span>Mobile Responsive Design</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-4.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>Professional Dynamic Websites</h3>
											<p>Custom websites that grow with your business and provide exceptional user experiences.</p>
											<ul class="features-list">
												<li><span>Content Management System</span></li>
												<li><span>SEO Optimization</span></li>
												<li><span>E-commerce Integration</span></li>
												<li><span>Performance Optimization</span></li>
												<li><span>Security Implementation</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-5.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>Software Development</h3>
											<p>End-to-end software development services from concept to deployment and maintenance.</p>
											<ul class="features-list">
												<li><span>Custom Software Solutions</span></li>
												<li><span>Cross-platform Development</span></li>
												<li><span>Quality Assurance Testing</span></li>
												<li><span>Deployment & Maintenance</span></li>
												<li><span>Technical Documentation</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-6.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
											<h3>Customized Softwares</h3>
											<p>Tailored software solutions designed specifically for your unique business requirements.</p>
											<ul class="features-list">
												<li><span>Business Process Automation</span></li>
												<li><span>Legacy System Integration</span></li>
												<li><span>Scalable Architecture</span></li>
												<li><span>Third-party Integrations</span></li>
												<li><span>Ongoing Support & Updates</span></li>
											</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-1.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
							<h3>Digital Skills Training</h3>
							<p>Comprehensive training programs to enhance digital literacy and technical skills for individuals and organizations.</p>
							<ul class="features-list">
								<li><span>Web Development Training</span></li>
								<li><span>Digital Marketing Skills</span></li>
								<li><span>Data Analysis Training</span></li>
								<li><span>Software Proficiency</span></li>
								<li><span>Online Learning Platform</span></li>
							</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-2.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
							<h3>YouTube Automation Training</h3>
							<p>Learn how to automate and scale your YouTube channel for maximum growth and revenue generation.</p>
							<ul class="features-list">
								<li><span>Content Automation</span></li>
								<li><span>SEO Optimization</span></li>
								<li><span>Monetization Strategies</span></li>
								<li><span>Analytics & Tracking</span></li>
								<li><span>Growth Hacking Techniques</span></li>
							</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-four-item">
						<div class="services-icon">
							<img src="assets/img/icon/services-four-icon-3.svg" alt="svg icon">
						</div>
						<div class="services-four-content">
							<h3>AI Automation Training</h3>
							<p>Master artificial intelligence tools and automation techniques to streamline business processes.</p>
							<ul class="features-list">
								<li><span>AI Tool Implementation</span></li>
								<li><span>Process Automation</span></li>
								<li><span>Machine Learning Basics</span></li>
								<li><span>Chatbot Development</span></li>
								<li><span>Workflow Optimization</span></li>
							</ul>
							<div class="services-btn">
								<a href="services.php" class="read-more"><i class="bi bi-arrow-right-short"></i> Learn More</a>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-12 col-md-12">
					<div class="more-button-box">
						<a class="default-btn" href="services.php">See All Services <span></span></a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Services Four Section -->
	
	<!-- Start Hire Section -->
	<section class="hire-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 offset-lg-2 col-md-12">
					<div class="hire-content">
									<h6 class="sub-title">Ready to transform your business?</h6>
									<h2>Let's get you a professional website.</h2>
									<p>From custom software development to digital skills training, we're here to help you leverage technology for business growth. Contact us today to explore how we can bring your digital vision to life.</p>
						<div class="hire-btn">
							<a class="default-btn" href="tel:+2347069378861">Call Now<span></span></a>
							<a class="default-btn-one" href="contact.php">Contact Us<span></span></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Hire Section -->
	
	<!-- Start Feature Two Section -->
    <section class="feature-two-section pt-100 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
					<div class="section-title">
						<h6 class="sub-title">Why Choose Us?</h6>
						<h2>Why Choose Omateq Digitals for Your IT Solutions?</h2>
					</div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-1.svg" alt="icon">
                        <h3>Expert Development Team</h3>
                        <p>Our skilled developers bring years of experience in web development, software engineering, and digital solutions to deliver exceptional results for your business.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-2.svg" alt="icon">
                        <h3>Custom Solutions</h3>
                        <p>We create tailored software and web applications specifically designed for your business needs, ensuring maximum efficiency and return on investment.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-3.svg" alt="icon">
                        <h3>24/7 Support</h3>
                        <p>Our dedicated support team is always available to help you with any technical issues, ensuring your systems run smoothly at all times.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-4.svg" alt="icon">
                        <h3>Comprehensive Training</h3>
                        <p>We provide extensive digital skills training, YouTube automation, and AI automation courses to empower your team with cutting-edge skills.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-5.svg" alt="icon">
                        <h3>Modern Technology Stack</h3>
                        <p>We use the latest technologies and frameworks to build scalable, secure, and high-performance applications that grow with your business.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="feature-two-single-item">
                        <img src="assets/img/icon/feature-two-icon-6.svg" alt="icon">
                        <h3>Proven Track Record</h3>
                        <p>With successful projects across various industries, we have the expertise and experience to deliver solutions that exceed your expectations.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
	<!-- End Feature Two Section -->
	
	<!-- Start Counter Section -->
	<section class="counter-area section-padding">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
								<span class="counter-number">7</span>
								<span>+</span>
							</h2>
												<h3 class="counter-heading">Years of Excellence</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
								<span class="counter-number">5</span>
								<span>+</span>
							</h2>
												<h3 class="counter-heading">Expert Developers</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
								<span class="counter-number">150</span>
								<span>+</span>
							</h2>
												<h3 class="counter-heading">Successful Projects</h3>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 counter-item">
					<div class="single-counter">
						<div class="counter-contents">
							<h2>
								<span class="counter-number">200</span>
								<span>+</span>
							</h2>
												<h3 class="counter-heading">Satisfied Clients</h3>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Counter Section -->

	<!-- Start Technology Work Section -->
	<section class="technology-section bg-grey pt-100 pb-70">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-md-12">
					<div class="section-title">
												<h6 class="sub-title">Our Expertise</h6>
												<h2>Technologies We Use</h2>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/android.svg" alt="svg icon">
						</div>
						<h3>Android</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/codeigniter.svg" alt="svg icon">
						</div>
												<h3>PHP</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/flutter.svg" alt="svg icon">
						</div>
						<h3>Flutter</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/nodejs.svg" alt="svg icon">
						</div>
												<h3>JavaScript</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/python.svg" alt="svg icon">
						</div>
						<h3>Python</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/react-native.svg" alt="svg icon">
						</div>
												<h3>React</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/swift-icon.svg" alt="svg icon">
						</div>
												<h3>MySQL</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/angular.svg" alt="svg icon">
						</div>
												<h3>Vue.js</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/csharp.svg" alt="svg icon">
						</div>
												<h3>Laravel</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/java.svg" alt="svg icon">
						</div>
						<h3>Java</h3>
					</div>
				</div>
				<div class="col-6 col-sm-6 col-md-3 col-lg-3 col-xl-2">
					<div class="single-technology-item">
						<div class="technology-icon">
							<img src="assets/img/technology/windows.svg" alt="svg icon">
						</div>
												<h3>WordPress</h3>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Technology Work Section -->
	
	<!-- Start Testimonial Section -->
	<section class="testimonial-section pt-100 pb-50">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="section-title">
						<h6 class="sub-title">Our Testimonial</h6>
						<h2>Client Feedback</h2>
					</div>
				</div>
				<div class="col-lg-12 col-md-12">
					<div class="testimonial-grid" id="testimonial-grid">
						<!-- Loading indicator -->
						<div class="row">
							<div class="col-12">
								<div class="text-center">
									<div class="spinner-border text-primary" role="status">
										<span class="sr-only">Loading...</span>
									</div>
									<p class="mt-3">Loading reviews...</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Testimonial Section -->
	<!-- Start Footer & Subscribe Section -->
	<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<!-- Structured Data (JSON-LD) -->
	<script type="application/ld+json">
	{
		"@context": "https://schema.org",
		"@type": "Organization",
		"name": "Omateq Digitals",
		"alternateName": "Omateq Digitals Limited",
		"url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>",
		"logo": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/logo.png",
		"description": "Leading web development company in Nigeria specializing in school portals, inventory software, custom web applications, and digital skills training.",
		"foundingDate": "2018",
		"founder": {
			"@type": "Person",
			"name": "David Omateq"
		},
		"address": {
			"@type": "PostalAddress",
			"streetAddress": "Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint",
			"addressLocality": "Suleja",
			"addressRegion": "Niger State",
			"addressCountry": "NG"
		},
		"contactPoint": {
			"@type": "ContactPoint",
			"telephone": "+2347069378861",
			"contactType": "customer service",
			"email": "info@omateqdigitals.com",
			"availableLanguage": "English"
		},
		"sameAs": [
			"https://facebook.com/omateqdigitals",
			"https://youtube.com/@learnwithomateq",
			"https://www.linkedin.com/company/omateqdigitals"
		],
		"hasOfferCatalog": {
			"@type": "OfferCatalog",
			"name": "IT Services and Training",
			"itemListElement": [
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "School Portal Development",
						"description": "Comprehensive school management systems for educational institutions"
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Inventory Software Development",
						"description": "Custom inventory management solutions for businesses"
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Web Application Development",
						"description": "Modern, responsive web applications built with cutting-edge technologies"
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Digital Skills Training",
						"description": "Comprehensive training programs for digital literacy and technical skills"
					}
				}
			]
		},
		"aggregateRating": {
			"@type": "AggregateRating",
			"ratingValue": "4.8",
			"reviewCount": "200"
		}
	}
	</script>
	
	<!-- Local Business Schema -->
	<script type="application/ld+json">
	{
		"@context": "https://schema.org",
		"@type": "LocalBusiness",
		"@id": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/#business",
		"name": "Omateq Digitals",
		"image": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/logo.png",
		"telephone": "+2347069378861",
		"email": "info@omateqdigitals.com",
		"address": {
			"@type": "PostalAddress",
			"streetAddress": "Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint",
			"addressLocality": "Suleja",
			"addressRegion": "Abuja",
			"postalCode": "923101",
			"addressCountry": "NG"
		},
		"geo": {
			"@type": "GeoCoordinates",
			"latitude": "9.1689706",
			"longitude": "7.2096018"
		},
		"url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>",
		"openingHours": "Mo-Fr 09:00-18:00",
		"priceRange": "$$"
	}
	</script>
	
	<!-- WhatsApp Chat Button -->
	<div class="whatsapp-chat-button">
		<a href="https://wa.me/2347069378861?text=Hello%20Omateq%20Digitals!%20I%20would%20like%20to%20know%20more%20about%20your%20services." 
		   target="_blank" 
		   rel="noopener noreferrer"
		   class="whatsapp-link"
		   title="Chat with us on WhatsApp">
			<i class="fab fa-whatsapp"></i>
			<span class="whatsapp-text">Chat with us</span>
		</a>
	</div>
	
	<style>
	/* WhatsApp Chat Button Styles */
	.whatsapp-chat-button {
		position: fixed;
		bottom: 20px;
		right: 20px;
		z-index: 1000;
		animation: pulse 2s infinite;
	}
	
	.whatsapp-link {
		display: flex;
		align-items: center;
		background: #25D366;
		color: white;
		text-decoration: none;
		padding: 12px 16px;
		border-radius: 50px;
		box-shadow: 0 4px 12px rgba(37, 211, 102, 0.4);
		transition: all 0.3s ease;
		font-family: 'Poppins', sans-serif;
		font-weight: 500;
		font-size: 14px;
	}
	
	.whatsapp-link:hover {
		background: #128C7E;
		color: white;
		text-decoration: none;
		transform: translateY(-2px);
		box-shadow: 0 6px 20px rgba(37, 211, 102, 0.6);
	}
	
	.whatsapp-link i {
		font-size: 24px;
		margin-right: 8px;
	}
	
	.whatsapp-text {
		white-space: nowrap;
	}
	
	/* Pulse animation */
	@keyframes pulse {
		0% {
			box-shadow: 0 0 0 0 rgba(37, 211, 102, 0.7);
		}
		70% {
			box-shadow: 0 0 0 10px rgba(37, 211, 102, 0);
		}
		100% {
			box-shadow: 0 0 0 0 rgba(37, 211, 102, 0);
		}
	}
	
	/* Mobile responsiveness */
	@media (max-width: 768px) {
		.whatsapp-chat-button {
			bottom: 15px;
			right: 15px;
		}
		
		.whatsapp-link {
			padding: 10px 14px;
			font-size: 13px;
		}
		
		.whatsapp-link i {
			font-size: 22px;
			margin-right: 6px;
		}
		
		.whatsapp-text {
			display: none;
		}
	}
	
	/* Hide on very small screens */
	@media (max-width: 480px) {
		.whatsapp-text {
			display: none;
		}
		
		.whatsapp-link {
			padding: 12px;
			border-radius: 50%;
		}
	}
	
	/* Hero Section Background Animations */
	.home-section.home-4 {
		position: relative;
		overflow: hidden;
		background: 
			linear-gradient(135deg, rgba(0, 2, 46, 0.8), rgba(26, 26, 46, 0.7)),
			url('assets/img/home-4-bg.jpg') center/cover;
		background-attachment: fixed;
		animation: backgroundPulse 20s ease-in-out infinite;
	}
	
	@keyframes backgroundPulse {
		0%, 100% {
			background: 
				linear-gradient(135deg, rgba(0, 2, 46, 0.8), rgba(26, 26, 46, 0.7)),
				url('assets/img/home-4-bg.jpg') center/cover;
			transform: scale(1);
		}
		50% {
			background: 
				linear-gradient(135deg, rgba(0, 2, 46, 0.9), rgba(26, 26, 46, 0.8)),
				url('assets/img/home-4-bg.jpg') center/cover;
			transform: scale(1.02);
		}
	}
	
	/* Floating particles animation */
	#particles-js {
		position: absolute;
		width: 100%;
		height: 100%;
		top: 0;
		left: 0;
		z-index: 1;
	}
	
	/* Animated background overlay */
	.home-section.home-4::before {
		content: '';
		position: absolute;
		top: 0;
		left: 0;
		width: 100%;
		height: 100%;
		background: 
			radial-gradient(circle at 20% 50%, rgba(120, 119, 198, 0.2) 0%, transparent 50%),
			radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.15) 0%, transparent 50%),
			radial-gradient(circle at 40% 80%, rgba(120, 219, 255, 0.2) 0%, transparent 50%);
		animation: floatingShapes 25s ease-in-out infinite;
		z-index: 1;
	}
	
	@keyframes floatingShapes {
		0%, 100% {
			transform: translateY(0px) rotate(0deg);
			opacity: 0.7;
		}
		50% {
			transform: translateY(-20px) rotate(180deg);
			opacity: 1;
		}
	}
	
	/* Pulse animation for hero content */
	.main-banner-content {
		animation: fadeInUp 1s ease-out;
		position: relative;
		z-index: 2;
	}
	
	@keyframes fadeInUp {
		from {
			opacity: 0;
			transform: translateY(30px);
		}
		to {
			opacity: 1;
			transform: translateY(0);
		}
	}
	
	/* Hero Image Animations */
	.hero-image {
		animation: floatImage 6s ease-in-out infinite;
		position: relative;
		z-index: 2;
		max-width: 100%;
		height: auto;
		filter: drop-shadow(0 10px 30px rgba(0, 0, 0, 0.3));
	}
	
	@keyframes floatImage {
		0%, 100% {
			transform: translateY(0px) rotate(0deg);
		}
		50% {
			transform: translateY(-15px) rotate(2deg);
		}
	}
	
	.banner-image {
		position: relative;
		z-index: 2;
		animation: fadeInRight 1.5s ease-out;
	}
	
	@keyframes fadeInRight {
		from {
			opacity: 0;
			transform: translateX(50px);
		}
		to {
			opacity: 1;
			transform: translateX(0);
		}
	}
	
	/* Add a subtle glow effect to the image */
	.hero-image::before {
		content: '';
		position: absolute;
		top: -10px;
		left: -10px;
		right: -10px;
		bottom: -10px;
		background: linear-gradient(45deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
		border-radius: 20px;
		z-index: -1;
		animation: imageGlow 3s ease-in-out infinite alternate;
	}
	
	@keyframes imageGlow {
		from {
			opacity: 0.5;
			transform: scale(1);
		}
		to {
			opacity: 0.8;
			transform: scale(1.02);
		}
	}
	
	/* Animated buttons */
	.banner-btn .default-btn-one,
	.banner-btn .default-btn-two {
		animation: buttonPulse 2s ease-in-out infinite;
		position: relative;
		overflow: hidden;
	}
	
	.banner-btn .default-btn-one::before,
	.banner-btn .default-btn-two::before {
		content: '';
		position: absolute;
		top: 0;
		left: -100%;
		width: 100%;
		height: 100%;
		background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
		transition: left 0.5s;
	}
	
	.banner-btn .default-btn-one:hover::before,
	.banner-btn .default-btn-two:hover::before {
		left: 100%;
	}
	
	@keyframes buttonPulse {
		0%, 100% {
			transform: scale(1);
			box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
		}
		50% {
			transform: scale(1.05);
			box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
		}
	}
	
	/* Testimonial Grid Styling */
	.testimonial-grid .single-testimonial {
		transition: all 0.3s ease;
		border: 1px solid #e9ecef;
		border-radius: 10px;
		padding: 30px;
		background: #fff;
		box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
	}
	
	.testimonial-grid .single-testimonial:hover {
		transform: translateY(-5px);
		box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
		border-color: #007bff;
	}
	
	.testimonial-grid .rating-box {
		margin-bottom: 20px;
	}
	
	.testimonial-grid .rating-box ul {
		display: flex;
		list-style: none;
		padding: 0;
		margin: 0;
	}
	
	.testimonial-grid .rating-box ul li {
		margin-right: 5px;
	}
	
	.testimonial-grid .rating-box ul li i {
		color: #ffc107;
		font-size: 16px;
	}
	
	.testimonial-grid .testimonial-content {
		margin-bottom: 25px;
	}
	
	.testimonial-grid .testimonial-content p {
		font-style: italic;
		line-height: 1.6;
		margin: 0;
		color: #666;
	}
	
	.testimonial-grid .avatar {
		text-align: center;
		margin-bottom: 15px;
	}
	
	.testimonial-grid .avatar img {
		width: 60px;
		height: 60px;
		border-radius: 50%;
		object-fit: cover;
		border: 3px solid #007bff;
	}
	
	.testimonial-grid .testimonial-bio {
		text-align: center;
	}
	
	.testimonial-grid .testimonial-bio h3 {
		font-size: 18px;
		font-weight: 600;
		margin-bottom: 5px;
		color: #333;
	}
	
	.testimonial-grid .testimonial-bio span {
		color: #666;
		font-size: 14px;
	}
	
	/* Responsive adjustments */
	@media (max-width: 768px) {
		.testimonial-grid .single-testimonial {
			padding: 20px;
		}
		
		.testimonial-grid .avatar img {
			width: 50px;
			height: 50px;
		}
		
		.testimonial-grid .testimonial-bio h3 {
			font-size: 16px;
		}
	}
	
	/* Mobile Menu Text Color - Black Only */
	@media (max-width: 991px) {
		.mean-container .navbar-nav .nav-link,
		.mean-container .navbar-nav .nav-item a,
		.mean-container .other-option .default-btn {
			color: #000000 !important;
		}
	}
	
	</style>
	
	<!-- Google Reviews Integration Script -->
	<script>
	document.addEventListener('DOMContentLoaded', function() {
		loadGoogleReviews();
	});
	
	function loadGoogleReviews() {
		fetch('get_google_reviews.php')
			.then(response => response.json())
			.then(data => {
				if (data.success) {
					displayReviews(data.reviews);
				} else {
					console.error('Failed to load reviews:', data.message);
					showFallbackReviews();
				}
			})
			.catch(error => {
				console.error('Error loading reviews:', error);
				showFallbackReviews();
			});
	}
	
	function displayReviews(reviews) {
		const grid = document.getElementById('testimonial-grid');
		grid.innerHTML = '';
		
		// Display only first 3 testimonials
		const displayReviews = reviews.slice(0, 3);
		
		let gridHTML = '<div class="row justify-content-center">';
		
		displayReviews.forEach(review => {
			const testimonialHTML = `
				<div class="col-lg-4 col-md-6 mb-4">
					<div class="single-testimonial h-100">
						<div class="rating-box">
							<ul>
								${review.star_rating_html}
							</ul>
						</div>
						<div class="testimonial-content">
							<p>${review.text}</p>
						</div>
						<div class="avatar">
							<img src="${review.profile_photo_url}" alt="${review.author_name} testimonial" onerror="this.src='assets/img/client/default-avatar.svg'">
						</div>
						<div class="testimonial-bio">
							<div class="bio-info">
								<h3>${review.author_name}</h3>
								<span>Google Review • ${review.relative_time}</span>
							</div>
						</div>
					</div>
				</div>
			`;
			gridHTML += testimonialHTML;
		});
		
		gridHTML += '</div>';
		
		grid.innerHTML = gridHTML;
	}
	
	function showFallbackReviews() {
		const grid = document.getElementById('testimonial-grid');
		grid.innerHTML = `
			<div class="row justify-content-center">
				<div class="col-lg-4 col-md-6 mb-4">
					<div class="single-testimonial h-100">
						<div class="rating-box">
							<ul>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
							</ul>
						</div>
						<div class="testimonial-content">
							<p>Omateq Digitals transformed our school management system completely. The portal they developed has streamlined our administrative processes and improved communication between teachers, students, and parents significantly.</p>
						</div>
						<div class="avatar">
							<img src="assets/img/client/testimonial-1.jpg" alt="testimonial images">
						</div>
						<div class="testimonial-bio">
							<div class="bio-info">
								<h3>Dr. Sarah Johnson</h3>
								<span>School Principal</span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6 mb-4">
					<div class="single-testimonial h-100">
						<div class="rating-box">
							<ul>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
							</ul>
						</div>
						<div class="testimonial-content">
							<p>The inventory management software developed by Omateq Digitals has revolutionized our business operations. Real-time tracking and automated reports have saved us countless hours and reduced errors dramatically.</p>
						</div>
						<div class="avatar">
							<img src="assets/img/client/testimonial-2.jpg" alt="testimonial images">
						</div>
						<div class="testimonial-bio">
							<div class="bio-info">
								<h3>Michael Chen</h3>
								<span>Business Owner</span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6 mb-4">
					<div class="single-testimonial h-100">
						<div class="rating-box">
							<ul>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
								<li><i class="fa fa-star"></i></li>
							</ul>
						</div>
						<div class="testimonial-content">
							<p>Their digital skills training program was exceptional. I learned web development from scratch and now I'm building my own applications. The instructors are knowledgeable and the curriculum is well-structured.</p>
						</div>
						<div class="avatar">
							<img src="assets/img/client/testimonial-3.jpg" alt="testimonial images">
						</div>
						<div class="testimonial-bio">
							<div class="bio-info">
								<h3>Alexandra Rodriguez</h3>
								<span>Training Graduate</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		`;
	}
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>