<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
// Include portfolio data functions
require_once 'admin-dashboard/config/portfolio_data.php';

// Get portfolio items from database
$portfolioItems = getPortfolioItems();
$portfolioStats = getPortfolioStats();
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title>Portfolio - Web Development Projects & Success Stories | Omateq Digitals</title>
	<meta name="description" content="Explore our portfolio of successful web development projects including school portals, inventory systems, web applications, and software solutions delivered to clients across Nigeria.">
	<meta name="keywords" content="web development portfolio Nigeria, school portal projects, inventory software projects, web application portfolio, software development showcase, IT projects Nigeria, digital solutions portfolio">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="Portfolio - Web Development Projects & Success Stories">
	<meta property="og:description" content="View our successful web development projects and client success stories across Nigeria.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/portfolio-og.jpg">
	<meta property="og:site_name" content="Omateq Digitals">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="Portfolio - Web Development Projects & Success Stories">
	<meta name="twitter:description" content="View our successful web development projects and client success stories.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/portfolio-og.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		.portfolio-content-overlay .project-description {
			font-size: 14px;
			margin: 10px 0;
			color: #fff;
			opacity: 0.9;
		}
		.portfolio-buttons {
			margin-top: 15px;
		}
		.portfolio-buttons .btn {
			font-size: 12px;
			padding: 8px 12px;
			border-radius: 4px;
			text-decoration: none;
			display: inline-block;
			transition: all 0.3s ease;
		}
		.portfolio-buttons .btn-primary {
			background-color: #007bff;
			border-color: #007bff;
		}
		.portfolio-buttons .btn-primary:hover {
			background-color: #0056b3;
			border-color: #0056b3;
			transform: translateY(-2px);
		}
		.portfolio-buttons .btn-outline-light {
			color: #fff;
			border-color: #fff;
		}
		.portfolio-buttons .btn-outline-light:hover {
			background-color: #fff;
			color: #333;
		}
		.portfolio-content-overlay h3 {
			margin-bottom: 10px;
		}
		.portfolio-info {
			padding: 20px 0;
			text-align: center;
		}
		.portfolio-info h4 {
			color: #333;
			margin-bottom: 10px;
			font-weight: 600;
		}
		.portfolio-info .project-description {
			color: #666;
			font-size: 14px;
			margin-bottom: 15px;
			line-height: 1.5;
		}
		.portfolio-buttons .btn {
			font-size: 12px;
			padding: 8px 16px;
			border-radius: 4px;
			text-decoration: none;
			display: inline-block;
			transition: all 0.3s ease;
			margin: 2px;
		}
		.portfolio-buttons .btn-primary {
			background-color: #007bff;
			border-color: #007bff;
		}
		.portfolio-buttons .btn-primary:hover {
			background-color: #0056b3;
			border-color: #0056b3;
			transform: translateY(-2px);
		}
		.portfolio-buttons .btn-outline-primary {
			color: #007bff;
			border-color: #007bff;
		}
		.portfolio-buttons .btn-outline-primary:hover {
			background-color: #007bff;
			color: #fff;
			transform: translateY(-2px);
		}
		.modal-body .project-image {
			width: 100%;
			height: 200px;
			object-fit: cover;
			border-radius: 8px;
			margin-bottom: 20px;
		}
		.modal-body .project-details {
			margin-bottom: 20px;
		}
		.modal-body .project-details h6 {
			color: #007bff;
			font-weight: 600;
			margin-bottom: 5px;
		}
		.modal-body .project-details p {
			margin-bottom: 15px;
			color: #666;
		}
		.modal-body .project-features {
			background: #f8f9fa;
			padding: 15px;
			border-radius: 8px;
			margin-bottom: 20px;
		}
		.modal-body .project-features h6 {
			color: #333;
			margin-bottom: 10px;
		}
		.modal-body .project-features ul {
			margin: 0;
			padding-left: 20px;
		}
		.modal-body .project-features li {
			margin-bottom: 5px;
			color: #666;
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
	</style>
</head>

<body>

	<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
													<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2>Portfolio</h2>
						<ul>
											<li><a href="index.php">Home</a></li>
							<li>Portfolio</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Portfolio Section -->
    <section class="portfolio-area section-padding">
        <div class="container">
            <div class="row">
				<div class="col-md-12">
					<div class="section-title">
												<h6 class="sub-title">Our Projects</h6>
												<h2>Portfolio of Work</h2>
					</div>
				</div>
                <div class="col-md-12">
                    <div class="portfolio-list">
                        <ul class="nav" id="portfolio-flters">
                            <li class="filter filter-active" data-filter=".all">All</li>
                            <li class="filter" data-filter=".website">Website</li>
                            <li class="filter" data-filter=".webapplication">Web Applications</li>
                            <li class="filter" data-filter=".software">Softwares</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="portfolio-container">
				<div class="row">
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (empty($portfolioItems)): ?>
                        <!-- No portfolio items message -->
                        <div class="col-12">
                            <div class="text-center py-5">
                                <h4>No Portfolio Items Available</h4>
                                <p class="text-muted">Check back soon for our latest projects!</p>
                            </div>
                        </div>
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; else: ?>
                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; foreach ($portfolioItems as $item): ?>
                            <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
                            // Determine category display name and class
                            $categoryClass = $item['category'];
                            $categoryDisplay = ucfirst($item['category']);
                            if ($item['category'] === 'webapplication') {
                                $categoryDisplay = 'Web Application';
                            }
                            
                            // Get image path - ensure correct path format
                            $imagePath = 'assets/img/portfolio/portfolio-default.jpg'; // Default fallback
                            if (!empty($item['image_url'])) {
                                // Use the stored image URL directly since it should be correct
                                $imagePath = $item['image_url'];
                            }
                            
                            // Debug output (remove in production)
                            if (isset($_GET['debug'])) {
                                echo "<!-- Debug: Item ID {$item['id']}, Image URL: {$item['image_url']}, Final Path: {$imagePath} -->";
                            }
                            
                            // Truncate description for display
                            $shortDescription = strlen($item['description']) > 100 ? substr($item['description'], 0, 100) . '...' : $item['description'];
                            ?>
                            <div class="col-lg-4 col-md-6 portfolio-grid-item all <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($categoryClass); ?>">
                                <div class="portfolio-item">
                                    <img src="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($imagePath); ?>" alt="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($item['title']); ?>">
                                    <div class="portfolio-content-overlay">
                                        <p><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($categoryDisplay); ?></p>
                                        <h3><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($item['title']); ?></h3>
                                    </div>
                                </div>
                                <div class="portfolio-info">
                                    <h4><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($item['title']); ?></h4>
                                    <p class="project-description"><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($shortDescription); ?></p>
                                    <div class="portfolio-buttons">
                                        <button type="button" class="btn btn-primary btn-sm me-2" data-bs-toggle="modal" data-bs-target="#projectModal" data-project-id="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo $item['id']; ?>">
                                            <i class="bi bi-eye"></i> View Details
                                        </button>
                                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (!empty($item['project_url'])): ?>
                                            <a href="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($item['project_url']); ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-box-arrow-up-right"></i> Visit Project
                                            </a>
                                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endforeach; ?>
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End Portfolio Section -->
    
    <!-- Project Details Modal -->
    <div class="modal fade" id="projectModal" tabindex="-1" aria-labelledby="projectModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="projectModalLabel">Project Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <img id="modalProjectImage" src="" alt="Project Image" class="project-image">
                    <div class="project-details">
                        <h6>Project Name:</h6>
                        <p id="modalProjectName"></p>
                        
                        <h6>Category:</h6>
                        <p id="modalProjectCategory"></p>
                        
                        <h6>Description:</h6>
                        <p id="modalProjectDescription"></p>
                        
                        <h6>Technologies Used:</h6>
                        <p id="modalProjectTechnologies"></p>
                        
                        <h6>Project URL:</h6>
                        <p><a id="modalProjectUrl" href="#" target="_blank" class="text-primary">Visit Project</a></p>
                    </div>
                    
                    <div class="project-features">
                        <h6>Key Features:</h6>
                        <ul id="modalProjectFeatures"></ul>
                    </div>
                    
                    <div class="text-center">
                        <a id="modalVisitButton" href="#" target="_blank" class="btn btn-primary">
                            <i class="bi bi-box-arrow-up-right"></i> Visit Project
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
	
<!-- Start Footer & Subscribe Section -->
<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<script>
		// Portfolio data from database
		const portfolioData = <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo json_encode($portfolioItems); ?>;
		
		// Convert database data to the format expected by the modal
		const projects = {};
		portfolioData.forEach(item => {
			projects[item.id] = {
				name: item.title,
				category: item.category === 'webapplication' ? 'Web Application' : item.category.charAt(0).toUpperCase() + item.category.slice(1),
				description: item.description,
				technologies: item.technologies,
				url: item.project_url,
				image: item.image_url || 'assets/img/portfolio/portfolio-default.jpg',
				features: item.features ? item.features.split('\n').filter(feature => feature.trim() !== '') : []
			};
		});

		// Handle modal display
		document.addEventListener('DOMContentLoaded', function() {
			const modal = document.getElementById('projectModal');
			const modalTitle = document.getElementById('projectModalLabel');
			const modalImage = document.getElementById('modalProjectImage');
			const modalName = document.getElementById('modalProjectName');
			const modalCategory = document.getElementById('modalProjectCategory');
			const modalDescription = document.getElementById('modalProjectDescription');
			const modalTechnologies = document.getElementById('modalProjectTechnologies');
			const modalUrl = document.getElementById('modalProjectUrl');
			const modalFeatures = document.getElementById('modalProjectFeatures');
			const modalVisitButton = document.getElementById('modalVisitButton');

			// Add event listeners to all "View Details" buttons
			document.querySelectorAll('[data-project-id]').forEach(button => {
				button.addEventListener('click', function() {
					const projectId = this.getAttribute('data-project-id');
					const project = projects[projectId];
					
					if (project) {
						// Update modal content
						modalTitle.textContent = project.name + ' - Project Details';
						modalImage.src = project.image;
						modalImage.alt = project.name;
						modalName.textContent = project.name;
						modalCategory.textContent = project.category;
						modalDescription.textContent = project.description;
						modalTechnologies.textContent = project.technologies || 'Not specified';
						modalUrl.href = project.url || '#';
						modalUrl.textContent = project.url || 'No URL available';
						modalVisitButton.href = project.url || '#';
						
						// Update features list
						modalFeatures.innerHTML = '';
						if (project.features && project.features.length > 0) {
							project.features.forEach(feature => {
								const li = document.createElement('li');
								li.textContent = feature.trim();
								modalFeatures.appendChild(li);
							});
						} else {
							const li = document.createElement('li');
							li.textContent = 'No features specified';
							modalFeatures.appendChild(li);
						}
					}
				});
			});
		});
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>