<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
require_once 'admin-dashboard/config/database.php';

// Fetch active products from database
try {
    $pdo = getConnection();
    $stmt = $pdo->query("
        SELECT id, product_name, product_description, thumbnail_url, category, product_features, 
               demo_link, demo_login_details, product_specifications, product_amount, 
               status, created_at, updated_at
        FROM products 
        WHERE status = 'active' 
        ORDER BY sort_order ASC, created_at DESC
    ");
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $products = [];
    $error = "Unable to load products at this time.";
}

// Get unique categories for filtering
$categories = [];
if (!empty($products)) {
    $categoryCounts = [];
    foreach ($products as $product) {
        $cat = $product['category'];
        if (!isset($categoryCounts[$cat])) {
            $categoryCounts[$cat] = 0;
        }
        $categoryCounts[$cat]++;
    }
    $categories = array_keys($categoryCounts);
}
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title>Digital Products & Software Solutions - Premium IT Products | Omateq Digitals</title>
	<meta name="description" content="Discover our premium digital products including school management systems, inventory software, web applications, and digital training courses. Ready-to-use solutions for Nigerian businesses.">
	<meta name="keywords" content="digital products Nigeria, school management software, inventory management system, web application products, digital training courses, software solutions Nigeria, ready-made software">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="Digital Products & Software Solutions - Premium IT Products">
	<meta property="og:description" content="Browse our collection of premium digital products and software solutions designed for Nigerian businesses and educational institutions.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/products-og.jpg">
	<meta property="og:site_name" content="Omateq Digitals">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="Digital Products & Software Solutions">
	<meta name="twitter:description" content="Premium digital products and software solutions for Nigerian businesses.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/products-og.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	
	<!-- Custom Products CSS -->
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		.portfolio-item {
			position: relative;
			overflow: hidden;
			border-radius: 8px;
			box-shadow: 0 4px 15px rgba(0,0,0,0.1);
			transition: transform 0.3s ease, box-shadow 0.3s ease;
		}
		
		.portfolio-item:hover {
			transform: translateY(-5px);
			box-shadow: 0 8px 25px rgba(0,0,0,0.15);
		}
		
		.portfolio-item img {
			width: 100%;
			height: 250px;
			object-fit: cover;
			transition: transform 0.3s ease;
		}
		
		.portfolio-item:hover img {
			transform: scale(1.05);
		}
		
		.portfolio-content-overlay {
			position: absolute;
			bottom: 0;
			left: 0;
			right: 0;
			background: linear-gradient(transparent, rgba(0,0,0,0.8));
			color: white;
			padding: 20px;
			transform: translateY(100%);
			transition: transform 0.3s ease;
		}
		
		.portfolio-item:hover .portfolio-content-overlay {
			transform: translateY(0);
		}
		
		.portfolio-content-overlay h3 a {
			color: white;
			text-decoration: none;
			font-weight: 600;
		}
		
		.portfolio-content-overlay p {
			margin-bottom: 10px;
			font-size: 14px;
			opacity: 0.9;
		}
		
		.portfolio-link-icon {
			position: absolute;
			top: 15px;
			right: 15px;
			width: 40px;
			height: 40px;
			background: rgba(255,255,255,0.2);
			border-radius: 50%;
			display: flex;
			align-items: center;
			justify-content: center;
			color: white;
			text-decoration: none;
			transition: background 0.3s ease;
		}
		
		.portfolio-link-icon:hover {
			background: rgba(255,255,255,0.3);
			color: white;
		}
		
		.no-products-message {
			text-align: center;
			padding: 4rem 2rem;
			background: #f8f9fa;
			border-radius: 8px;
		}
		
		.no-products-message h3 {
			color: #6c757d;
			margin-bottom: 1rem;
		}
		
		.no-products-message p {
			color: #6c757d;
			font-size: 1.1rem;
		}
		
		/* Debug styles */
		.debug-info {
			background: #e9ecef;
			padding: 1rem;
			border-radius: 4px;
			margin: 1rem 0;
			font-family: monospace;
			font-size: 12px;
		}
		
		/* Modal fixes */
		.modal {
			z-index: 1050;
		}
		
		.modal-backdrop {
			z-index: 1040;
		}
		
		.modal .close {
			position: absolute;
			top: 15px;
			right: 15px;
			z-index: 1060;
			background: none;
			border: none;
			font-size: 1.5rem;
			font-weight: bold;
			line-height: 1;
			color: #000;
			text-shadow: 0 1px 0 #fff;
			opacity: 0.5;
			cursor: pointer;
		}
		
		.modal .close:hover {
			opacity: 0.75;
		}
		
		.modal .close:focus {
			outline: none;
		}
		
		.modal-header {
			position: relative;
			padding: 1rem 1rem 0 1rem;
			border-bottom: 1px solid #dee2e6;
		}
		
		.modal-body {
			padding: 1rem;
		}
		
		.modal-footer {
			padding: 0.75rem 1rem 1rem 1rem;
			border-top: 1px solid #dee2e6;
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
	</style>
</head>

<body>
	<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
							<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2>Digital Products</h2>
						<p>Discover and purchase premium digital products and solutions</p>
						</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (isset($_GET['debug']) && $_GET['debug'] == '1'): ?>
	<!-- Debug Information -->
	<div class="container" style="margin-top: 2rem;">
		<div class="debug-info">
			<h4>Debug Information</h4>
			<p><strong>Products Count:</strong> <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo count($products); ?></p>
			<p><strong>Categories:</strong> <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo implode(', ', $categories); ?></p>
			<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (!empty($products)): ?>
				<p><strong>Sample Product:</strong></p>
				<pre><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; print_r($products[0]); ?></pre>
			<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
		</div>
	</div>
	<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
	
	<!-- Start Products Section -->
    <section class="portfolio-area section-padding">
        <div class="container">
            <div class="row">
				<div class="col-md-12">
					<div class="section-title text-center">
						<h2>Our Digital Products</h2>
						<p>Choose from our collection of premium digital products and solutions</p>
					</div>
				</div>
                <div class="col-md-12">
                    <div class="portfolio-list">
                        <ul class="nav" id="portfolio-flters">
                            <li class="filter filter-active" data-filter=".all">All Products</li>
                            <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; foreach ($categories as $category): ?>
                            <li class="filter" data-filter=".<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo strtolower($category); ?>"><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo ucfirst($category); ?></li>
                            <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="portfolio-container">
				<div class="row">
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (!empty($products)): ?>
                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; foreach ($products as $product): ?>
                        <!-- product-item -->
                        <div class="col-lg-4 col-md-6 portfolio-grid-item all <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo strtolower($product['category']); ?>" data-product-id="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo $product['id']; ?>">
                            <div class="portfolio-item">
                                <img src="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo $product['thumbnail_url'] ?: 'assets/img/portfolio/portfolio-default.jpg'; ?>" 
                                     alt="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($product['product_name']); ?>"
                                     onerror="this.src='assets/img/portfolio/portfolio-default.jpg'">
                                <div class="portfolio-content-overlay">
                                    <p><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo ucfirst($product['category']); ?> | $<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo number_format($product['product_amount'], 2); ?></p>
                                    <h3><a href="#" class="product-view-btn" data-product-id="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo $product['id']; ?>"><?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($product['product_name']); ?></a></h3>
                                    <a class="portfolio-link-icon product-view-btn" href="#" data-product-id="<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo $product['id']; ?>"><i class="bi bi-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endforeach; ?>
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; else: ?>
                        <div class="col-12 text-center">
                            <div class="no-products-message" style="padding: 3rem 0;">
                                <h3>No Products Available</h3>
                                <p>We're working on adding new products. Please check back soon!</p>
                                <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; if (isset($error)): ?>
                                    <p class="text-danger">Error: <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo htmlspecialchars($error); ?></p>
                                <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
                            </div>
                        </div>
                    <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End Portfolio Section -->
<!-- Start Footer & Subscribe Section -->
<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->

	<!-- Product Details Modal -->
	<div id="productModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="productModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="productModalLabel">Product Details</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="closeProductModal()">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div id="productDetails">
						<!-- Product details will be loaded here -->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="closeProductModal()">Close</button>
					<button type="button" class="btn btn-primary" id="purchaseBtn">Purchase Now</button>
				</div>
			</div>
		</div>
	</div>
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<!-- Product Modal JavaScript -->
	<script>
		// Product data from PHP
		const products = <?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php'; echo json_encode($products); ?>;
		
		$(document).ready(function() {
			console.log('Products page loaded');
			console.log('Products available:', products);
			
			// Handle product view button clicks
			$('.product-view-btn').on('click', function(e) {
				e.preventDefault();
				const productId = $(this).data('product-id');
				console.log('Product clicked:', productId);
				const product = products.find(p => p.id == productId);
				
				if (product) {
					console.log('Product found:', product);
					showProductModal(product);
				} else {
					console.log('Product not found for ID:', productId);
				}
			});
			
			// Handle purchase button click
			$('#purchaseBtn').on('click', function() {
				console.log('Purchase button clicked');
				// Redirect to registration page
				window.location.href = 'users/register.php';
			});
			
			// Handle modal close button clicks
			$('#productModal .close, #productModal .btn-secondary').on('click', function() {
				console.log('Modal close button clicked');
				$('#productModal').modal('hide');
			});
			
			// Handle modal backdrop clicks
			$('#productModal').on('click', function(e) {
				if (e.target === this) {
					console.log('Modal backdrop clicked');
					$('#productModal').modal('hide');
				}
			});
			
			// Handle escape key
			$(document).on('keydown', function(e) {
				if (e.keyCode === 27) { // ESC key
					if ($('#productModal').hasClass('show')) {
						console.log('Escape key pressed');
						$('#productModal').modal('hide');
					}
				}
			});
		});
		
		function showProductModal(product) {
			console.log('Showing modal for product:', product.product_name);
			
			// Update modal title
			$('#productModalLabel').text(product.product_name);
			
			// Create product details HTML
			var productHtml = '<div class="row">' +
				'<div class="col-md-4">' +
					'<img src="' + (product.thumbnail_url || 'assets/img/portfolio/portfolio-default.jpg') + '" ' +
						 'alt="' + product.product_name + '" ' +
						 'class="img-fluid rounded" ' +
						 'style="width: 100%; height: 250px; object-fit: cover;">' +
				'</div>' +
				'<div class="col-md-8">' +
					'<div class="product-info">' +
						'<h4 class="mb-3">' + product.product_name + '</h4>' +
						'<div class="mb-3">' +
							'<span class="badge badge-primary mr-2">' + product.category.toUpperCase() + '</span>' +
							'<span class="badge badge-success">$' + parseFloat(product.product_amount).toFixed(2) + '</span>' +
						'</div>' +
						'<p class="text-muted mb-3">' + product.product_description + '</p>';
			
			if (product.product_features) {
				productHtml += '<h6><strong>Features:</strong></h6>' +
							   '<p class="mb-3">' + product.product_features + '</p>';
			}
			
			if (product.demo_link) {
				productHtml += '<h6><strong>Demo:</strong></h6>' +
							   '<p class="mb-2">' +
								   '<a href="' + product.demo_link + '" target="_blank" class="btn btn-outline-info btn-sm">' +
									   '<i class="fas fa-external-link-alt"></i> View Demo' +
								   '</a>' +
							   '</p>';
			}
			
			if (product.demo_login_details) {
				productHtml += '<h6><strong>Demo Login:</strong></h6>' +
							   '<div class="alert alert-info">' +
								   '<small><code>' + product.demo_login_details + '</code></small>' +
							   '</div>';
			}
			
			if (product.product_specifications) {
				productHtml += '<h6><strong>Specifications:</strong></h6>' +
							   '<p class="mb-3">' + product.product_specifications + '</p>';
			}
			
			productHtml += '</div>' +
						   '</div>' +
						   '</div>';
			
			// Update modal content
			$('#productDetails').html(productHtml);
			
			// Ensure modal is properly initialized before showing
			$('#productModal').modal({
				backdrop: true,
				keyboard: true,
				show: false
			});
			
			// Show modal
			$('#productModal').modal('show');
			
			// Add additional close button handlers after modal is shown
			setTimeout(function() {
				$('#productModal .close').off('click').on('click', function() {
					console.log('Close button clicked (timeout handler)');
					$('#productModal').modal('hide');
				});
				
				$('#productModal .btn-secondary').off('click').on('click', function() {
					console.log('Close button clicked (timeout handler)');
					$('#productModal').modal('hide');
				});
			}, 100);
		}
		
		// Global function to close modal (can be called from anywhere)
		function closeProductModal() {
			console.log('Closing product modal');
			$('#productModal').modal('hide');
		}
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>