<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	
	<!-- SEO Meta Tags -->
	<title>IT Services & Solutions - Web Development, School Portals & Digital Training | Omateq Digitals</title>
	<meta name="description" content="Comprehensive IT services including school portal development, inventory software, web applications, digital skills training, and AI automation. Expert solutions for Nigerian businesses.">
	<meta name="keywords" content="IT services Nigeria, school portal development, inventory management software, web application development, digital skills training, AI automation training, software development services, custom web solutions">
	<meta name="author" content="Omateq Digitals">
	<meta name="robots" content="index, follow">
	<meta name="language" content="English">
	
	<!-- Open Graph Meta Tags -->
	<meta property="og:title" content="IT Services & Solutions - Web Development & Digital Training">
	<meta property="og:description" content="Professional IT services including school portals, inventory software, web applications, and comprehensive digital training programs.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/services-og.jpg">
	<meta property="og:site_name" content="Omateq Digitals">
	
	<!-- Twitter Card Meta Tags -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="IT Services & Solutions - Web Development & Digital Training">
	<meta name="twitter:description" content="Professional IT services including school portals, inventory software, web applications, and digital training.">
	<meta name="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/assets/img/services-og.jpg">
	
	<!-- Canonical URL -->
	<link rel="canonical" href="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
	</style>
</head>

<body>
<!-- Start Navbar Section -->
	<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="course.php" class="nav-link">Courses</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
													<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area item-bg1">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2>Services</h2>
						</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Services Two Section -->
	<section class="services-section-two section-padding">
		<div class="container">
			<div class="row">
                <div class="col-md-12">
					<div class="section-title">
						<h6 class="sub-title">What We Provide</h6>
						<h2>Our Services</h2>
					</div>
                </div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-1.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-1.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>School Portal Development</h3>
												<p>Comprehensive school management systems that streamline administrative tasks, student records, and communication between teachers, students, and parents.</p>
												<div class="services-btn">
													<a href="single-services.php?service=school-portal" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-2.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-2.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Inventory Software Development</h3>
												<p>Custom inventory management solutions designed to optimize your business operations, track stock levels, and reduce costs effectively.</p>
												<div class="services-btn">
													<a href="single-services.php?service=inventory-software" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-3.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-3.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Web Applications</h3>
												<p>Modern, responsive web applications built with cutting-edge technologies for optimal performance and exceptional user experience.</p>
												<div class="services-btn">
													<a href="single-services.php?service=web-applications" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-4.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-4.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Professional Dynamic Websites</h3>
												<p>Custom websites that grow with your business, featuring content management systems, SEO optimization, and mobile responsiveness.</p>
												<div class="services-btn">
													<a href="single-services.php?service=dynamic-websites" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-5.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-5.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Software Development</h3>
												<p>End-to-end software development services from concept to deployment, including custom solutions and cross-platform applications.</p>
												<div class="services-btn">
													<a href="single-services.php?service=software-development" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-6.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-6.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Customized Softwares</h3>
												<p>Tailored software solutions designed specifically for your unique business requirements and processes.</p>
												<div class="services-btn">
													<a href="single-services.php?service=customized-software" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-1.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-1.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>Digital Skills Training</h3>
												<p>Comprehensive training programs to enhance digital literacy and technical skills for individuals and organizations.</p>
												<div class="services-btn">
													<a href="single-services.php?service=digital-training" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-2.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-2.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>YouTube Automation Training</h3>
												<p>Learn how to automate and scale your YouTube channel for maximum growth and revenue generation.</p>
												<div class="services-btn">
													<a href="single-services.php?service=youtube-automation" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-6">
					<div class="single-services-two-item">
						<div class="services-two-icon-box">
							<div class="default-icon">
								<img src="assets/img/icon/services-two-icon-3.svg" alt="svg icon">
							</div>
							<div class="hover-icon">
								<img src="assets/img/icon/services-two-icon-hover-3.svg" alt="svg icon">
							</div>
						</div>
						<div class="services-two-content">
												<h3>AI Automation Training</h3>
												<p>Master artificial intelligence tools and automation techniques to streamline business processes.</p>
												<div class="services-btn">
													<a href="single-services.php?service=ai-automation" class="read-more"><i class="bi bi-arrow-right-short"></i> Read More</a>
												</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Services Two Section -->
	
	<!-- Start Hire Section -->
	<section class="hire-section">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 offset-lg-2 col-md-12">
					<div class="hire-content">
									<h6 class="sub-title">Ready to transform your business?</h6>
									<h2>Let's Build Your Digital Future Together</h2>
									<p>From custom web applications to comprehensive digital training programs, we're here to help you leverage technology for business growth. Contact us today to discuss your project and discover how we can bring your digital vision to life.</p>
						<div class="hire-btn">
											<a class="default-btn" href="tel:+2347069378861">Call Now<span></span></a>
											<a class="default-btn-one" href="contact.php">Contact Us<span></span></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Hire Section -->
	
	<!-- Start Overview Section -->
	<section class="overview-section section-padding">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<div class="overview-image">
						<img src="assets/img/choose-1.png" alt="image">
					</div>
				</div>
				<div class="col-lg-6">
					<div class="overview-content">
									<h6 class="sub-title">Why Choose Us?</h6>
									<h2>Transform Your Business with Expert Web Development Solutions</h2>
									<p>We specialize in creating comprehensive web solutions that drive business growth. Our expert team delivers custom applications, professional websites, and digital training programs tailored to your specific needs.</p>
						<ul class="features-list">
											<li> <span>Custom Web Applications</span></li>
											<li> <span>School Portal Development</span></li>
											<li> <span>Inventory Management Systems</span></li>
											<li> <span>Professional Website Design</span></li>
											<li> <span>Digital Skills Training</span></li>
											<li> <span>AI Automation Solutions</span></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Overview Section -->
	
	<!-- Start Overview Section -->
	<section class="overview-section pt-50 pb-100">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<div class="overview-content">
									<h6 class="sub-title">WHY TRUST US?</h6>
									<h2>Empower Your Business with Cutting-Edge Web Development & Training</h2>
									<p>With years of experience in web development and digital training, we deliver solutions that not only meet your current needs but also scale with your business growth. Our comprehensive approach ensures long-term success.</p>
						<ul class="features-list">
											<li> <span>Modern Technology Stack</span></li>
											<li> <span>Responsive Design</span></li>
											<li> <span>SEO Optimization</span></li>
											<li> <span>Performance Optimization</span></li>
											<li> <span>24/7 Support</span></li>
											<li> <span>Ongoing Maintenance</span></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="overview-image-2">
						<img src="assets/img/choose-2.png" alt="image">
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Overview Section -->
	
<!-- Start Footer & Subscribe Section -->
<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
	<!-- Structured Data (JSON-LD) -->
	<script type="application/ld+json">
	{
		"@context": "https://schema.org",
		"@type": "Service",
		"serviceType": "IT Services and Digital Training",
		"provider": {
			"@type": "Organization",
			"name": "Omateq Digitals",
			"url": "<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>"
		},
		"areaServed": {
			"@type": "Country",
			"name": "Nigeria"
		},
		"hasOfferCatalog": {
			"@type": "OfferCatalog",
			"name": "IT Services and Digital Training",
			"itemListElement": [
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "School Portal Development",
						"description": "Comprehensive school management systems for educational institutions including student management, grade tracking, and parent-teacher communication."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Inventory Software Development",
						"description": "Custom inventory management solutions designed to optimize business operations, track stock levels, and reduce costs effectively."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Web Application Development",
						"description": "Modern, responsive web applications built with cutting-edge technologies for optimal performance and exceptional user experience."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Professional Dynamic Websites",
						"description": "Custom websites that grow with your business, featuring content management systems, SEO optimization, and mobile responsiveness."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Software Development",
						"description": "End-to-end software development services from concept to deployment, including custom solutions and cross-platform applications."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "Digital Skills Training",
						"description": "Comprehensive training programs to enhance digital literacy and technical skills for individuals and organizations."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "YouTube Automation Training",
						"description": "Learn how to automate and scale your YouTube channel for maximum growth and revenue generation."
					}
				},
				{
					"@type": "Offer",
					"itemOffered": {
						"@type": "Service",
						"name": "AI Automation Training",
						"description": "Master artificial intelligence tools and automation techniques to streamline business processes."
					}
				}
			]
		}
	}
	</script>
	
</body>

</html>
<?php
// End of PHP processing
?>