<?php
require_once 'admin-dashboard/config/settings.php';
require_once 'admin-dashboard/config/branding.php';
?><!doctype html>
<html lang="zxx">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- Title -->
	<title>Service Details - Omateq Digitals</title>
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@400;500;600;700;800&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Catamaran:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<!-- Favicon -->
	<?php echo getFaviconHtml(); ?>
	<!-- Bootstrap Min CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<!-- Animate Min CSS -->
	<link rel="stylesheet" href="assets/css/animate.min.css">
	<!-- FlatIcon CSS -->
	<link rel="stylesheet" href="assets/css/flaticon.css">
	<!-- Font Awesome Min CSS -->
	<link rel="stylesheet" href="assets/css/fontawesome.min.css">
	<!-- Bootstrap Icon CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-icons.css">
	<!-- Mean Menu CSS -->
	<link rel="stylesheet" href="assets/css/meanmenu.css">
	<!-- Magnific Popup Min CSS -->
	<link rel="stylesheet" href="assets/css/magnific-popup.min.css">
	<!-- Swiper Min CSS -->
	<link rel="stylesheet" href="assets/css/swiper.min.css">
	<!-- Owl Carousel Min CSS -->
	<link rel="stylesheet" href="assets/css/owl.carousel.min.css">
	<!-- Style CSS -->
	<link rel="stylesheet" href="assets/css/style.css">
	<!-- Responsive CSS -->
	<link rel="stylesheet" href="assets/css/responsive.css">
	
	<style>
		/* Navbar scroll effect styles */
		.navbar-section {
			transition: all 0.3s ease-in-out;
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: #00022E;
			backdrop-filter: blur(10px);
			box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
		}
		
		.navbar-section.scrolled {
			padding: 5px 0;
		background: #00022E !important; }
		
		.navbar-section.scrolled .navbar-brand img,
		.navbar-section.scrolled .logo img {
			height: 40px !important;
			width: auto !important;
			transition: all 0.3s ease-in-out;
		}
		
		.navbar-section.scrolled .navbar {
			padding: 5px 0;
		}
		
		.navbar-section.scrolled .navbar-nav .nav-link {
			padding: 8px 15px;
			font-size: 14px;
		}
		
		.navbar-section.scrolled .default-btn {
			padding: 8px 20px;
			font-size: 14px;
		}
		
		/* Initial logo size */
		.navbar-brand img,
		.logo img {
			height: 60px;
			width: auto;
			transition: all 0.3s ease-in-out;
		}
		/* Ensure black logo is visible */
		.black-logo {
			display: block !important;
		}
		
		/* Ensure white logo is hidden */
		.white-logo {
			display: none !important;
		}
		
		/* Add top padding to body to account for fixed navbar */
		body {
			padding-top: 80px;
		}
		
		/* Navigation menu black color styles */
		.navbar-section .navbar-nav .nav-link {
			color: #ffffff !important;
			font-weight: 500;
		}
		
		.navbar-section .navbar-nav .nav-link:hover {
			color: #007bff !important;
		}
		
		.navbar-section .navbar-nav .nav-link.active {
			color: #007bff !important;
			font-weight: 600;
		}
		
		.navbar-section .navbar-brand {
			color: #ffffff !important;
		}
		
		.navbar-section .default-btn {
			color: #fff !important;
			background: #007bff;
			border: none;
		}
		
		.navbar-section .default-btn:hover {
			background: #0056b3;
			color: #fff !important;
		}
		
		/* Mobile responsive */
		@media (max-width: 768px) {
			.navbar-section.scrolled .navbar-brand img,
			.navbar-section.scrolled .logo img {
				height: 35px !important;
			}
			
			.navbar-brand img,
			.logo img {
				height: 50px;
			}
		}
		
		/* Mobile Menu Text Color - Black Only */
		@media (max-width: 991px) {
			.mean-container .navbar-nav .nav-link,
			.mean-container .navbar-nav .nav-item a,
			.mean-container .other-option .default-btn {
				color: #000000 !important;
			}
		}
	</style>
</head>

<body>
<?php
// Get service parameter from URL
$service = isset($_GET['service']) ? $_GET['service'] : 'school-portal';

// Define service content
$services = [
    'school-portal' => [
        'title' => 'School Portal Development',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Comprehensive school management systems that streamline administrative tasks, student records, and communication between teachers, students, and parents.',
        'content' => 'Our school portal development service creates comprehensive digital solutions that transform educational institutions. We build robust, user-friendly platforms that handle everything from student enrollment to grade management, attendance tracking, and parent-teacher communication.',
        'features' => [
            'Student Management System',
            'Grade & Attendance Tracking',
            'Parent-Teacher Communication',
            'Online Learning Platform',
            'Fee Management System',
            'Report Card Generation',
            'Library Management',
            'Transport Management'
        ]
    ],
    'inventory-software' => [
        'title' => 'Inventory Software Development',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Custom inventory management solutions designed to optimize your business operations, track stock levels, and reduce costs effectively.',
        'content' => 'Our inventory software development service helps businesses maintain optimal stock levels, reduce waste, and improve operational efficiency. We create custom solutions that integrate seamlessly with your existing business processes.',
        'features' => [
            'Real-time Stock Tracking',
            'Automated Reorder Points',
            'Multi-location Support',
            'Barcode Integration',
            'Analytics & Reporting',
            'Supplier Management',
            'Purchase Order Management',
            'Inventory Valuation'
        ]
    ],
    'web-applications' => [
        'title' => 'Web Applications',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Modern, responsive web applications built with cutting-edge technologies for optimal performance and exceptional user experience.',
        'content' => 'We develop custom web applications that are scalable, secure, and designed to meet your specific business requirements. Our applications work seamlessly across all devices and browsers.',
        'features' => [
            'Progressive Web Apps',
            'API Development',
            'Database Integration',
            'User Authentication',
            'Mobile Responsive Design',
            'Real-time Features',
            'Cloud Integration',
            'Performance Optimization'
        ]
    ],
    'dynamic-websites' => [
        'title' => 'Professional Dynamic Websites',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Custom websites that grow with your business, featuring content management systems, SEO optimization, and mobile responsiveness.',
        'content' => 'Our professional dynamic websites are built to scale with your business growth. We create stunning, functional websites that not only look great but also perform exceptionally well in search engines.',
        'features' => [
            'Content Management System',
            'SEO Optimization',
            'E-commerce Integration',
            'Performance Optimization',
            'Security Implementation',
            'Mobile Responsive Design',
            'Analytics Integration',
            'Social Media Integration'
        ]
    ],
    'software-development' => [
        'title' => 'Software Development',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'End-to-end software development services from concept to deployment, including custom solutions and cross-platform applications.',
        'content' => 'Our software development service covers the entire development lifecycle, from initial concept and planning to deployment and ongoing maintenance. We build robust, scalable applications that meet your business needs.',
        'features' => [
            'Custom Software Solutions',
            'Cross-platform Development',
            'Quality Assurance Testing',
            'Deployment & Maintenance',
            'Technical Documentation',
            'API Development',
            'Database Design',
            'Cloud Integration'
        ]
    ],
    'customized-software' => [
        'title' => 'Customized Softwares',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Tailored software solutions designed specifically for your unique business requirements and processes.',
        'content' => 'We create completely customized software solutions that are designed around your specific business processes and requirements. Our solutions integrate seamlessly with your existing systems and workflows.',
        'features' => [
            'Business Process Automation',
            'Legacy System Integration',
            'Scalable Architecture',
            'Third-party Integrations',
            'Ongoing Support & Updates',
            'Custom Reporting',
            'Workflow Management',
            'Data Migration'
        ]
    ],
    'digital-training' => [
        'title' => 'Digital Skills Training',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Comprehensive training programs to enhance digital literacy and technical skills for individuals and organizations.',
        'content' => 'Our digital skills training programs are designed to equip individuals and organizations with the technical skills needed to thrive in the digital age. We offer both individual and corporate training programs.',
        'features' => [
            'Web Development Training',
            'Digital Marketing Skills',
            'Data Analysis Training',
            'Software Proficiency',
            'Online Learning Platform',
            'Certification Programs',
            'Corporate Training',
            'One-on-One Mentoring'
        ]
    ],
    'youtube-automation' => [
        'title' => 'YouTube Automation Training',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Learn how to automate and scale your YouTube channel for maximum growth and revenue generation.',
        'content' => 'Our YouTube automation training teaches you how to build, automate, and scale a successful YouTube channel. Learn the strategies and tools used by top creators to generate consistent revenue.',
        'features' => [
            'Content Automation',
            'SEO Optimization',
            'Monetization Strategies',
            'Analytics & Tracking',
            'Growth Hacking Techniques',
            'Video Production',
            'Channel Management',
            'Revenue Optimization'
        ]
    ],
    'ai-automation' => [
        'title' => 'AI Automation Training',
        'image' => 'assets/img/services-details-1.jpg',
        'description' => 'Master artificial intelligence tools and automation techniques to streamline business processes.',
        'content' => 'Our AI automation training program teaches you how to leverage artificial intelligence tools to automate business processes, improve efficiency, and reduce manual work.',
        'features' => [
            'AI Tool Implementation',
            'Process Automation',
            'Machine Learning Basics',
            'Chatbot Development',
            'Workflow Optimization',
            'Data Analysis with AI',
            'Business Intelligence',
            'Predictive Analytics'
        ]
    ]
];

// Get current service data
$currentService = $services[$service] ?? $services['school-portal'];
?>
<!-- Start Navbar Section -->
<div class="navbar-section">
		<div class="techvio-responsive-nav">
			<div class="container">
				<div class="techvio-responsive-menu">
					<div class="logo">
						<a href="index.php">
							<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="techvio-nav">
			<div class="container">
				<nav class="navbar navbar-expand-md navbar-light">
					<a class="navbar-brand" href="index.php">
						<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
						<?php echo getLogoHtml('black', 'black-logo', 'logo'); ?>
					</a>
					<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
						<ul class="navbar-nav">
							<li class="nav-item"> 
								<a href="index.php" class="nav-link">Home </i></a>
														</li>
							<li class="nav-item">
								<a href="about.php" class="nav-link">About</a>
							</li>
							<li class="nav-item">
								<a href="services.php" class="nav-link">Services</i></a>
							</li>
							<li class="nav-item">
								<a href="portfolio.php" class="nav-link">Portfolio</i></a>
							</li>
							<li class="nav-item"> 
								<a href="products.php" class="nav-link">Products</i></a>
							</li>
							<li class="nav-item">
								<a href="contact.php" class="nav-link">Contact</a>
							</li>
						</ul>
						<div class="other-option">
							<a class="default-btn" href="users/authentication/login.php"> Account<span></span></a>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</div>
	<!-- End Navbar Section -->
	
	<!-- Start Page Title Section -->
	<div class="page-title-area item-bg1">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="page-title-content">
						<h2><?php echo $currentService['title']; ?></h2>
						<ul>
							<li><a href="index.php">Home</a></li>
							<li><a href="services.php">Services</a></li>
							<li><?php echo $currentService['title']; ?></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- End Page Title Section -->
	
	<!-- Start Services Details Section -->
	<section class="services-details-area section-padding">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 col-md-12">
					<div class="services-details-content">
						<div class="services-details-image">
							<img src="<?php echo $currentService['image']; ?>" alt="<?php echo $currentService['title']; ?>">
						</div>
						
						<h3><?php echo $currentService['title']; ?> - Complete Solution</h3>
						<p><?php echo $currentService['description']; ?></p>
						
						<div class="features-text">
							<h4>What We Provide in <?php echo $currentService['title']; ?></h4>
							<p><?php echo $currentService['content']; ?></p>
							<p>Our team of experienced developers and trainers work closely with you to understand your specific requirements and deliver solutions that exceed your expectations. We use the latest technologies and best practices to ensure your project is successful.</p>
							<p>With years of experience in the industry, we have successfully delivered numerous projects across various sectors. Our commitment to quality and customer satisfaction makes us the preferred choice for businesses looking to leverage technology for growth.</p>
							
							<div class="row">
								<div class="col-md-6">
									<h5>Key Features:</h5>
									<ul class="feature-list">
										<?php foreach(array_slice($currentService['features'], 0, 4) as $feature): ?>
										<li><i class="bi bi-check-circle"></i> <?php echo $feature; ?></li>
										<?php endforeach; ?>
									</ul>
								</div>
								<div class="col-md-6">
									<h5>Additional Benefits:</h5>
									<ul class="feature-list">
										<?php foreach(array_slice($currentService['features'], 4, 4) as $feature): ?>
										<li><i class="bi bi-check-circle"></i> <?php echo $feature; ?></li>
										<?php endforeach; ?>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-12">
					<aside class="services-widget">
						<section class="widget widget_categories">
							<h3 class="widget-title">Our Services</h3>
							<ul>
								<li> <a href="single-services.php?service=school-portal">School Portal Development</a></li>
								<li> <a href="single-services.php?service=inventory-software">Inventory Software</a></li>
								<li> <a href="single-services.php?service=web-applications">Web Applications</a></li>
								<li> <a href="single-services.php?service=dynamic-websites">Dynamic Websites</a></li>
								<li> <a href="single-services.php?service=software-development">Software Development</a></li>
								<li> <a href="single-services.php?service=customized-software">Customized Software</a></li>
								<li> <a href="single-services.php?service=digital-training">Digital Training</a></li>
								<li> <a href="single-services.php?service=youtube-automation">YouTube Automation</a></li>
								<li> <a href="single-services.php?service=ai-automation">AI Automation</a></li>
							</ul>
						</section>
						<section class="widget widget_download_btn">
							<h3 class="widget-title">Get Started</h3>
							<div class="download-btn-box">
								<a href="booking.php" class="default-btn">Request Quote <span></span></a>
								<a href="tel:+2347069378861" class="default-btn">Call Now <span></span></a>
							</div>
						</section>
					</aside>
				</div>
			</div>
		</div>
	</section>
	<!-- End Services Details Section -->
	
	<!-- Start Footer & Subscribe Section -->
<section class="footer-subscribe-wrapper">
		<!-- Start Subscribe Section -->
		<div class="subscribe-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6 col-md-6">
						<div class="subscribe-content">
							<h2>Stay Updated with Omateq Digitals</h2>
							<p>Get the latest insights on web development, software solutions, and digital skills training delivered to your inbox.</p>
						</div>
					</div>
					<div class="col-lg-6 col-md-6">
						<form class="newsletter-form">
							<input type="email" class="input-newsletter" name="email" placeholder="Enter Your Email" required autocomplete="off">
							<button type="submit">Subscribe Now</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- End Subscribe Section -->
		<!-- Start Footer Section -->
		<div class="footer-area ptb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<a class="footer-logo" href="index.php">
								<?php echo getLogoHtml('white', 'white-logo', 'logo'); ?>
							</a>
							<p>Omateq Digitals is your trusted partner for comprehensive web development, custom software solutions, and digital skills training. We transform businesses through innovative technology solutions and empower individuals with cutting-edge digital skills.</p>
							<ul class="footer-social">
								<li>
									<a href="https://facebook.com/omateqdigitals"> <i class="fab fa-facebook-f"></i></a>
								</li>
								<li>
									<a href="https://youtube.com/@learnwithomateq"> <i class="fab fa-youtube"></i></a>
								</li>
								<li>
									<a href="https://www.linkedin.com/omateqdigitals"> <i class="fab fa-linkedin"></i></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Our Services</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="services.php">School Portal Development</a></li>
												<li><a href="services.php">Inventory Software</a></li>
												<li><a href="services.php">Web Applications</a></li>
												<li><a href="services.php">Digital Skills Training</a></li>
												<li><a href="services.php">AI Automation Training</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-2 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Useful Links</h3>
							</div>
							<ul class="footer-quick-links">
												<li><a href="about.php">About Us</a></li>
												<li><a href="portfolio.php">Portfolio</a></li>
												<li><a href="contact.php">Contact Us</a></li>
												<li><a href="privacy-policy.html">Privacy Policy</a></li>
												<li><a href="terms-condition.html">Terms & Conditions</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="single-footer-widget">
							<div class="footer-heading">
								<h3>Contact Info</h3>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-phone-call"></i>
								<h3>Phone</h3>
												<span><a href="tel:+2347069378861">+2347069378861</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-envelope"></i>
								<h3>Email</h3>
												<span><a href="mailto:info@omateqdigitals.com">info@omateqdigitals.com</a></span>
							</div>
							<div class="footer-info-contact">
								<i class="flaticon-placeholder"></i>
								<h3>Address</h3>
												<span>Suite 8, Jehovah Bueze Plaza, Opp. Berger Paint, Suleja</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Footer Section -->
	</section>
	<!-- End Footer & Subscribe Section -->
	
	<!-- Start Copy Right Section -->
	<div class="copyright-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-md-6">
										<p><i class="far fa-copyright"></i> 2025 Omateq Digitals - All Rights Reserved.</p>
				</div>
				<div class="col-lg-6 col-md-6">
					<ul>
						<li><a href="terms-condition.html">Terms & Conditions</a></li>
						<li><a href="privacy-policy.html">Privacy Policy</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<!-- End Copy Right Section -->
	
	<!-- Start Go Top Section -->
	<div class="go-top">
		<i class="fas fa-chevron-up"></i>
		<i class="fas fa-chevron-up"></i>
	</div>
	<!-- End Go Top Section -->
	
	<!-- jQuery Min JS -->
	<script src="assets/js/jquery.min.js"></script>
	
	<!-- Navbar scroll effect -->
	<script>
		window.addEventListener('scroll', function() {
			const navbar = document.querySelector('.navbar-section');
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
			
			if (scrollTop > 100) {
				navbar.classList.add('scrolled');
			} else {
				navbar.classList.remove('scrolled');
			}
		});
	</script>
	<!-- Popper Min JS -->
	<script src="assets/js/popper.min.js"></script>
	<!-- Bootstrap Min JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Mean Menu JS  -->
	<script src="assets/js/jquery.meanmenu.js"></script>
	<!-- Appear Min JS -->
	<script src="assets/js/jquery.appear.min.js"></script>
	<!-- CounterUp Min JS -->
	<script src="assets/js/jquery.waypoints.min.js"></script>
	<script src="assets/js/jquery.counterup.min.js"></script>
	<!-- Owl Carousel Min JS -->
	<script src="assets/js/owl.carousel.min.js"></script>
	<!-- Magnific Popup Min JS -->
	<script src="assets/js/jquery.magnific-popup.min.js"></script>
	<!-- Isotope Min JS -->
	<script src="assets/js/isotope.pkgd.min.js"></script>
	<!-- Swiper Min JS -->
	<script src="assets/js/swiper.min.js"></script>
	<!-- Vanilla Tilt Min JS -->
	<script src="assets/js/vanilla-tilt.min.js"></script>
	<!-- Particles JS -->
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-app-2.js"></script>
	<!-- WOW Min JS -->
	<script src="assets/js/wow.min.js"></script>
	<!-- Ajax Mail JS -->
	<script src="assets/js/ajax.mail.js"></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>
	
</body>

</html>
<?php
// End of PHP processing
?>