<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../../admin-dashboard/config/settings.php';
require_once __DIR__ . '/../config/password_reset.php';
require_once __DIR__ . '/../config/email_verification.php';
require_once __DIR__ . '/../config/session_manager.php';

// Initialize session
UserSessionManager::initSession();

function generateVerificationCode() {
    return str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
}

$error = '';
$success = '';
$course_id = isset($_GET['course_id']) ? intval($_GET['course_id']) : null;

// Initialize handlers
$pdo = getConnection();
$passwordReset = new PasswordResetHandler($pdo);
$emailVerification = new EmailVerificationHandler($pdo);

// Check if user is already logged in
if (isset($_SESSION['user_id'])) {
    if ($course_id) {
        header('Location: ../course.php?enroll=' . $course_id);
    } else {
        header('Location: ../index.php');
    }
    exit();
}

// Check for registration success message
if (isset($_SESSION['registration_success'])) {
    $success = $_SESSION['registration_success'];
    unset($_SESSION['registration_success']);
}

// Check for payment callback messages
if (isset($_GET['payment_success'])) {
    $success = "Payment successful! Please log in to access your purchased product.";
    if (isset($_GET['product_id'])) {
        $success .= " Product ID: " . htmlspecialchars($_GET['product_id']);
    }
}

if (isset($_GET['payment_error'])) {
    $error_codes = [
        1 => "Payment verification failed. Please contact support.",
        2 => "Order not found. Please contact support.",
        3 => "Payment processing error. Please contact support.",
        4 => "Invalid payment reference. Please contact support."
    ];
    $error = $error_codes[$_GET['payment_error']] ?? "Payment error occurred. Please contact support.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'forgot_password') {
        // Handle forgotten password request
        $email = trim($_POST['forgot_email'] ?? '');
        
        if (empty($email)) {
            $error = "Please enter your email address.";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = "Please enter a valid email address.";
        } else {
            $result = $passwordReset->createResetToken($email);
            
            if ($result['success']) {
                // Send reset email
                $emailResult = $passwordReset->sendResetEmail($email, $result['token']);
                
                if ($emailResult['success']) {
                    $success = "Password reset instructions have been sent to your email address.";
                } else {
                    $error = $emailResult['message'];
                }
            } else {
                $error = $result['message'];
            }
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'verify_otp') {
        // Handle OTP verification for login
        $verification_code = trim($_POST['verification_code']);
        $email = $_SESSION['user_email'] ?? '';
        $user_id = $_SESSION['pending_login_user_id'] ?? null;
        $course_id = $_SESSION['pending_login_course_id'] ?? null;
        
        if (empty($verification_code)) {
            $error = "Please enter the OTP code.";
        } elseif (empty($email) || !$user_id) {
            $error = "Invalid session. Please login again.";
        } else {
            try {
                // Use the email verification system for OTP validation
                $validationResult = $emailVerification->validateCode($email, $verification_code, true); // true indicates this is a login OTP
                
                if ($validationResult['success'] && $validationResult['user_id'] == $user_id) {
                    // Get user details for session
                    $stmt = $pdo->prepare("SELECT id, email, full_name FROM users WHERE id = ?");
                    $stmt->execute([$user_id]);
                    $user = $stmt->fetch();
                    
                    if ($user) {
                        // Set session
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['user_email'] = $user['email'];
                        $_SESSION['user_name'] = $user['full_name'];
                        
                        // Clear pending login data
                        unset($_SESSION['pending_login_user_id']);
                        unset($_SESSION['pending_login_course_id']);
                        
                        // Redirect to dashboard with success message
                        $_SESSION['login_success'] = "Welcome back to Omateq Digitals! You have successfully logged in.";
                        
                        // Redirect based on course_id if available
                        if ($course_id) {
                            header('Location: ../course.php?enroll=' . $course_id);
                        } else {
                            header('Location: ../index.php');
                        }
                        exit();
                    } else {
                        $error = "User not found. Please try again.";
                    }
                } else {
                    $error = "Invalid or expired OTP code. Please try again.";
                }
            } catch (Exception $e) {
                $error = "OTP verification failed. Please try again.";
            }
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'resend_otp') {
        // Handle resend OTP code
        $email = $_SESSION['user_email'] ?? '';
        $user_id = $_SESSION['pending_login_user_id'] ?? null;
        
        if (empty($email) || !$user_id) {
            $error = "No pending login found. Please try logging in again.";
        } else {
            try {
                // Get user details
                $stmt = $pdo->prepare("SELECT id, full_name FROM users WHERE email = ? AND id = ?");
                $stmt->execute([$email, $user_id]);
                $user = $stmt->fetch();
                
                if ($user) {
                    // Create new OTP code
                    $codeResult = $emailVerification->createVerificationCode($user['id'], $email);
                    
                    if ($codeResult['success']) {
                        // Send OTP code email
                        $emailResult = $emailVerification->sendVerificationCodeEmail($email, $codeResult['code'], $user['full_name'], true); // true indicates this is a login OTP
                        
                        if ($emailResult['success']) {
                            $success = "OTP code resent! Please check your email for the new 6-digit code.";
                        } else {
                            $error = "Failed to resend OTP email. Please try again later.";
                        }
                    } else {
                        $error = "Failed to create new OTP code. Please try again.";
                    }
                } else {
                    $error = "User not found. Please try logging in again.";
                }
            } catch (Exception $e) {
                $error = "Failed to resend OTP code. Please try again.";
            }
        }
    } else {
        // Handle login
        $email = trim($_POST['email']);
        $password = $_POST['password'];
        $course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : null;
        
        if (empty($email) || empty($password)) {
            $error = "Please enter both email and password.";
        } else {
            try {
                $pdo = getConnection();
                $stmt = $pdo->prepare("SELECT id, email, password, full_name, status, email_verified FROM users WHERE email = ?");
                $stmt->execute([$email]);
                $user = $stmt->fetch();
                
                if ($user && password_verify($password, $user['password'])) {
                    // Always require OTP verification for login security
                    $codeResult = $emailVerification->createVerificationCode($user['id'], $email);
                    
                    if ($codeResult['success']) {
                        // Send OTP code email
                        $emailResult = $emailVerification->sendVerificationCodeEmail($email, $codeResult['code'], $user['full_name'], true); // true indicates this is a login OTP
                        
                        if ($emailResult['success']) {
                            $success = "Please check your email for a 6-digit OTP code to complete your login. The code will expire in 15 minutes.";
                            $_SESSION['user_email'] = $email; // Store email for OTP verification
                            $_SESSION['pending_login_user_id'] = $user['id']; // Store user ID for after OTP verification
                            $_SESSION['pending_login_course_id'] = $course_id; // Store course_id for redirect after OTP
                        } else {
                            $error = "Failed to send OTP email. Please try again later.";
                        }
                    } else {
                        $error = "Failed to create OTP code. Please try again.";
                    }
                } else {
                    $error = "Invalid email or password.";
                }
            } catch (Exception $e) {
                $error = "Login failed. Please try again.";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

  <base href="">

  <!-- begin::Edura Meta Basic -->
  <meta charset="utf-8">
  <meta name="theme-color" content="#0D9488">
  <meta name="robots" content="index, follow">
  <meta name="author" content="LayoutDrop">
  <meta name="format-detection" content="telephone=no">
  <meta name="keywords" content="login, user login, secure login, OTP verification, Omateq Digitals, digital courses, online learning, technology courses, programming, web development, mobile app development, digital marketing, user dashboard, course enrollment">
  <meta name="description" content="Secure login to your Omateq Digitals account. Access your courses, track progress, and manage your digital learning journey. Enhanced security with OTP verification for all user logins.">
  <!-- end::Edura Meta Basic -->

  <!-- begin::Edura Meta Social -->
  <meta property="og:url" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
  <meta property="og:site_name" content="Omateq Digitals">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_us">
  <meta property="og:title" content="Login | Omateq Digitals">
  <meta property="og:description" content="Secure login to your Omateq Digitals account. Access your courses, track progress, and manage your digital learning journey. Enhanced security with OTP verification for all user logins.">
  <meta property="og:image" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . '/omateqdigitals/assets/img/logo.png'; ?>">
  <!-- end::Edura Meta Social -->

  <!-- begin::Edura Meta Twitter -->
  <meta name="twitter:card" content="summary">
  <meta name="twitter:url" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
  <meta name="twitter:creator" content="@omateqdigitals">
  <meta name="twitter:title" content="Login | Omateq Digitals">
  <meta name="twitter:description" content="Secure login to your Omateq Digitals account. Access your courses, track progress, and manage your digital learning journey. Enhanced security with OTP verification for all user logins.">
  <!-- end::Edura Meta Twitter -->

  <!-- begin::Edura Website Page Title -->
  <title>Login | Omateq Digitals - Secure User Access</title>
  <!-- end::Edura Website Page Title -->

  <!-- begin::Edura Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- end::Edura Mobile Specific -->

  <!-- begin::Edura Favicon Tags -->
  <link rel="icon" type="image/png" href="../../assets/img/favicon.png">
  <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
  <!-- end::Edura Favicon Tags -->

  <!-- begin::Edura Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
  <!-- end::Edura Google Fonts -->

  <!-- begin::Edura Required Stylesheet -->
  <link rel="stylesheet" href="../assets/libs/flaticon/css/all/all.css">
  <link rel="stylesheet" href="../assets/libs/lucide/lucide.css">
  <link rel="stylesheet" href="../assets/libs/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="../assets/libs/simplebar/simplebar.css">
  <link rel="stylesheet" href="../assets/libs/node-waves/waves.css">
  <link rel="stylesheet" href="../assets/libs/bootstrap-select/css/bootstrap-select.min.css">
  <!-- end::Edura Required Stylesheet -->

  <!-- begin::Edura CSS Stylesheet -->
  <link rel="stylesheet" href="../assets/css/styles.css">
  <!-- end::Edura CSS Stylesheet -->
  
  <style>
    /* Logo sizing for login page */
    .mb-4.text-center img {
      max-height: 60px;
      max-width: 200px;
      width: auto;
      height: auto;
      object-fit: contain;
    }
  </style>

  <!-- begin::Edura Googletagmanager -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-XWVQM68HHQ"></script>
  <script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());

		gtag('config', 'G-XWVQM68HHQ', {
			'cookie_flags': 'SameSite=None;Secure',
			'send_page_view': true
		});
	</script>
  <!-- end::Edura Googletagmanager -->


</head>

<body>
  <div class="page-layout">

    <div class="auth-frame-wrapper" style="background-color: #1a1c31;">
      <div class="row g-0 h-100">
        <div class="col-12 align-self-center">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-6 col-md-8 col-sm-10">
                <div class="card shadow-lg border-0">
                  <div class="card-body p-4 p-sm-5">
                    <div class="mb-4 text-center">
                      <a href="https://omateqdigitals.com" aria-label="Omateq Digitals logo">
                        <?php echo '<img class="visible-light" src="../../' . getSetting('main_logo', 'assets/images/logo-full.svg') . '" alt="Omateq Digitals">'; ?>
                        <?php echo '<img class="visible-dark" src="../../' . getSetting('main_logo', 'assets/images/logo-full-white.svg') . '" alt="Omateq Digitals">'; ?>
                      </a>
                    </div>
                    <div class="text-center mb-5">
                      <h5 class="mb-1">Welcome to Omateq Digitals</h5>
                      <p>Sign in to access your secure user dashboard.</p>
                    </div>
             
             <?php if (!empty($error)): ?>
               <div class="alert alert-danger" role="alert">
                 <i class="fi fi-rr-exclamation-triangle me-2"></i>
                 <?php echo htmlspecialchars($error); ?>
               </div>
             <?php endif; ?>
             
             <?php if (!empty($success)): ?>
               <div class="alert alert-success" role="alert">
                 <i class="fi fi-rr-check-circle me-2"></i>
                 <?php echo htmlspecialchars($success); ?>
               </div>
             <?php endif; ?>
             
             <form method="POST" action="">
              <?php if ($course_id): ?>
                <input type="hidden" name="course_id" value="<?php echo $course_id; ?>">
              <?php endif; ?>
              <div class="mb-4">
                <label class="form-label" for="loginEmail">Email Address</label>
                <input type="email" class="form-control" id="loginEmail" name="email" placeholder="info@example.com" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
              </div>
              <div class="mb-4">
                <label class="form-label" for="loginPassword">Password</label>
                <input type="password" class="form-control" id="loginPassword" name="password" placeholder="********" required>
              </div>
              <div class="mb-4">
                <div class="d-flex justify-content-between">
                  <div class="form-check mb-0">
                    <input class="form-check-input" type="checkbox" id="rememberMe">
                    <label class="form-check-label" for="rememberMe"> Remember Me </label>
                  </div>
                  <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#forgotPasswordModal">Forgot Password?</a>
                </div>
              </div>
              <div class="mb-3">
                <button type="submit" value="Submit" class="btn btn-primary waves-effect waves-light w-100">Login</button>
              </div>
               <p class="mb-5 text-center">Don't have an account? <a href="register.php">Sign Up here</a>
               </p>
                          </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
   <!-- OTP Verification Modal -->
   <div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
     <div class="modal-dialog modal-dialog-centered">
       <div class="modal-content">
         <div class="modal-header">
           <h5 class="modal-title" id="otpModalLabel">OTP Verification Required</h5>
         </div>
         <form method="POST" action="">
           <input type="hidden" name="action" value="verify_otp">
           <div class="modal-body">
             <div class="text-center mb-4">
               <i class="fi fi-rr-shield-check text-primary" style="font-size: 3rem;"></i>
               <h6 class="mt-3">We've sent an OTP code to your email</h6>
               <p class="text-muted">Please check your inbox and enter the 6-digit code below to complete your login.</p>
             </div>
             <div class="mb-3">
               <label class="form-label">OTP Code</label>
               <input type="text" class="form-control text-center" name="verification_code" placeholder="000000" maxlength="6" pattern="[0-9]{6}" required>
               <div class="form-text">Enter the 6-digit code sent to your email address.</div>
             </div>
             <div class="text-center">
               <small class="text-muted">Didn't receive the code? <a href="javascript:void(0);" onclick="resendOTP()">Resend OTP</a></small>
             </div>
           </div>
           <div class="modal-footer">
             <button type="submit" class="btn btn-primary w-100">Verify & Login</button>
           </div>
         </form>
       </div>
     </div>
   </div>

   <!-- Forgot Password Modal -->
   <div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
     <div class="modal-dialog modal-dialog-centered">
       <div class="modal-content">
         <div class="modal-header">
           <h5 class="modal-title" id="forgotPasswordModalLabel">Forgot Password?</h5>
           <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
         </div>
         <form method="POST" action="">
           <input type="hidden" name="action" value="forgot_password">
           <div class="modal-body">
             <div class="text-center mb-4">
               <i class="fi fi-rr-lock text-primary" style="font-size: 3rem;"></i>
               <h6 class="mt-3">Reset Your Password</h6>
               <p class="text-muted">Enter your email address and we'll send you a link to reset your password.</p>
             </div>
             <div class="mb-3">
               <label class="form-label">Email Address</label>
               <input type="email" class="form-control" name="forgot_email" placeholder="Enter your email address" required>
             </div>
           </div>
           <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
             <button type="submit" class="btn btn-primary">Send Reset Link</button>
           </div>
         </form>
       </div>
     </div>
   </div>

   <!-- begin::Edura Page Scripts -->
   <script src="../assets/libs/global/global.min.js"></script>
   <script src="../assets/js/appSettings.js"></script>
   <script src="../assets/js/main.js"></script>
   
   <script>
     // Show OTP modal if user needs to verify OTP
     <?php if (isset($_SESSION['user_email']) && !empty($success) && strpos($success, 'OTP code') !== false): ?>
       document.addEventListener('DOMContentLoaded', function() {
         var otpModal = new bootstrap.Modal(document.getElementById('otpModal'));
         otpModal.show();
       });
     <?php endif; ?>
     
     function resendOTP() {
       // Resend OTP code
       fetch('', {
         method: 'POST',
         headers: {
           'Content-Type': 'application/x-www-form-urlencoded',
         },
         body: 'action=resend_otp'
       })
       .then(response => response.text())
       .then(data => {
         alert('OTP code resent! Please check your email.');
         // Reload the page to show the success message
         location.reload();
       })
       .catch(error => {
         alert('Failed to resend OTP code. Please try again.');
       });
     }
     
     // Auto-focus OTP input when modal is shown
     document.getElementById('otpModal').addEventListener('shown.bs.modal', function () {
       document.querySelector('input[name="verification_code"]').focus();
     });
     
     // Format OTP input (only allow numbers)
     document.querySelector('input[name="verification_code"]').addEventListener('input', function(e) {
       e.target.value = e.target.value.replace(/[^0-9]/g, '');
     });
   </script>
   <!-- end::Edura Page Scripts -->
 </body>

</html>
<?php
// End of PHP processing
?>