<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/email_config.php';
require_once __DIR__ . '/../../admin-dashboard/config/settings.php';
require_once __DIR__ . '/../config/welcome_email.php';

// Generate verification code function
function generateVerificationCode() {
    return str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
}

$error = '';
$success = '';
$course_id = isset($_GET['course_id']) ? intval($_GET['course_id']) : null;

// Check if user is already logged in
if (isset($_SESSION['user_id'])) {
    if ($course_id) {
        header('Location: ../course.php?enroll=' . $course_id);
    } else {
        header('Location: ../index.php');
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $whatsapp = trim($_POST['whatsapp']);
    $email = trim($_POST['email']);
    $country = trim($_POST['country']);
    $gender = $_POST['gender'];
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $terms = isset($_POST['terms']) ? true : false;
    $course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : null;
    
    // Validation
    if (empty($full_name) || empty($whatsapp) || empty($email) || empty($country) || 
        empty($gender) || empty($username) || empty($password) || empty($confirm_password)) {
        $error = "All fields are required.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "Please enter a valid email address.";
    } elseif (strlen($password) < 6) {
        $error = "Password must be at least 6 characters long.";
    } elseif ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } elseif (!$terms) {
        $error = "You must agree to the terms and conditions.";
    } else {
        try {
            $pdo = getConnection();
            
            // Check if email already exists
            $emailCheck = $pdo->prepare("SELECT id FROM users WHERE email = ?");
            $emailCheck->execute([$email]);
            if ($emailCheck->fetch()) {
                $error = "Email address already registered.";
            } else {
                // Check if username already exists
                $usernameCheck = $pdo->prepare("SELECT id FROM users WHERE username = ?");
                $usernameCheck->execute([$username]);
                if ($usernameCheck->fetch()) {
                    $error = "Username already taken.";
                } else {
                    // Generate verification code
                    $verification_code = generateVerificationCode();
                    
                    // Insert user
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("INSERT INTO users (username, email, password, full_name, phone, country, gender, verification_code, status, email_verified, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'active', FALSE, NOW())");
                    
                    if ($stmt->execute([$username, $email, $hashed_password, $full_name, $whatsapp, $country, $gender, $verification_code])) {
                        // Send welcome email using new system
                        $welcomeEmail = new WelcomeEmailHandler($pdo);
                        $emailResult = $welcomeEmail->sendWelcomeEmail($email, $full_name, $username);
                        
                        if ($emailResult['success']) {
                            $_SESSION['registration_success'] = "Registration successful! Welcome to Omateq Digitals. Please check your email for a welcome message.";
                        } else {
                            $_SESSION['registration_success'] = "Registration successful! Welcome to Omateq Digitals. (Email sending failed - please contact support if needed)";
                        }
                                
                                // Redirect to login with course_id if provided
                                if ($course_id) {
                                    header('Location: login.php?course_id=' . $course_id);
                                } else {
                                    header('Location: login.php');
                                }
                                exit();
                    } else {
                        $error = "Registration failed. Please try again.";
                    }
                }
            }
        } catch (Exception $e) {
            $error = "Database error: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

  <base href="">

  <!-- begin::Edura Meta Basic -->
  <meta charset="utf-8">
  <meta name="theme-color" content="#0D9488">
  <meta name="robots" content="index, follow">
  <meta name="author" content="LayoutDrop">
  <meta name="format-detection" content="telephone=no">
  <meta name="keywords" content="register, sign up, create account, Omateq Digitals, digital courses, online learning, technology courses, programming, web development, mobile app development, digital marketing, course enrollment, user registration, free account">
  <meta name="description" content="Join Omateq Digitals and start your digital learning journey. Create your free account to access premium technology courses, track your progress, and connect with industry experts. Get started today!">
  <!-- end::Edura Meta Basic -->

  <!-- begin::Edura Meta Social -->
  <meta property="og:url" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
  <meta property="og:site_name" content="Omateq Digitals">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_us">
  <meta property="og:title" content="Register | Omateq Digitals">
  <meta property="og:description" content="Join Omateq Digitals and start your digital learning journey. Create your free account to access premium technology courses, track your progress, and connect with industry experts. Get started today!">
  <meta property="og:image" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . '/omateqdigitals/assets/img/logo.png'; ?>">
  <!-- end::Edura Meta Social -->

  <!-- begin::Edura Meta Twitter -->
  <meta name="twitter:card" content="summary">
  <meta name="twitter:url" content="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
  <meta name="twitter:creator" content="@omateqdigitals">
  <meta name="twitter:title" content="Register | Omateq Digitals">
  <meta name="twitter:description" content="Join Omateq Digitals and start your digital learning journey. Create your free account to access premium technology courses, track your progress, and connect with industry experts. Get started today!">
  <!-- end::Edura Meta Twitter -->

  <!-- begin::Edura Website Page Title -->
  <title>Register | Omateq Digitals - Create Your Account</title>
  <!-- end::Edura Website Page Title -->

  <!-- begin::Edura Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- end::Edura Mobile Specific -->

  <!-- begin::Edura Favicon Tags -->
  <link rel="icon" type="image/png" href="../../assets/img/favicon.png">
  <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
  <!-- end::Edura Favicon Tags -->

  <!-- begin::Edura Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
  <!-- end::Edura Google Fonts -->

  <!-- begin::Edura Required Stylesheet -->
  <link rel="stylesheet" href="../assets/libs/flaticon/css/all/all.css">
  <link rel="stylesheet" href="../assets/libs/lucide/lucide.css">
  <link rel="stylesheet" href="../assets/libs/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="../assets/libs/simplebar/simplebar.css">
  <link rel="stylesheet" href="../assets/libs/node-waves/waves.css">
  <link rel="stylesheet" href="../assets/libs/bootstrap-select/css/bootstrap-select.min.css">
  <!-- end::Edura Required Stylesheet -->

  <!-- begin::Edura CSS Stylesheet -->
  <link rel="stylesheet" href="../assets/css/styles.css">
  <!-- end::Edura CSS Stylesheet -->
  
  <style>
    /* Logo sizing for register page */
    .mb-4.text-center img {
      max-height: 60px;
      max-width: 200px;
      width: auto;
      height: auto;
      object-fit: contain;
    }
  </style>

  <!-- begin::Edura Googletagmanager -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-XWVQM68HHQ"></script>
  <script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());

		gtag('config', 'G-XWVQM68HHQ', {
			'cookie_flags': 'SameSite=None;Secure',
			'send_page_view': true
		});
	</script>
  <!-- end::Edura Googletagmanager -->

</head>

<body>
  <div class="page-layout">

    <div class="auth-frame-wrapper" style="background-color: #1a1c31;">
      <div class="row g-0 h-100">
        <div class="col-12 align-self-center">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-6 col-md-8 col-sm-10">
                <div class="card shadow-lg border-0">
                  <div class="card-body p-4 p-sm-5">
                    <div class="mb-4 text-center">
                      <a href="https://omateqdigitals.com" aria-label="Omateq Digitals logo">
                        <?php echo '<img class="visible-light" src="../../' . getSetting('main_logo', 'assets/images/logo-full.svg') . '" alt="Omateq Digitals logo">'; ?>
                        <?php echo '<img class="visible-dark" src="../../' . getSetting('main_logo', 'assets/images/logo-full-white.svg') . '" alt="Omateq Digitals logo">'; ?>
                      </a>
                    </div>
                    <div class="text-center mb-5">
                      <h5 class="mb-1">Welcome to Omateq Digitals</h5>
                      <p>Sign up to create your secure User Account.</p>
                    </div>
            
            <?php if (!empty($error)): ?>
              <div class="alert alert-danger" role="alert">
                <i class="fi fi-rr-exclamation-triangle me-2"></i>
                <?php echo htmlspecialchars($error); ?>
              </div>
            <?php endif; ?>
            
            <?php if (!empty($success)): ?>
              <div class="alert alert-success" role="alert">
                <i class="fi fi-rr-check-circle me-2"></i>
                <?php echo htmlspecialchars($success); ?>
              </div>
            <?php endif; ?>
            
            <form method="POST" action="">
              <?php if ($course_id): ?>
                <input type="hidden" name="course_id" value="<?php echo $course_id; ?>">
              <?php endif; ?>
              <div class="mb-4">
                <label class="form-label" for="registerName">Full Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="registerName" name="full_name" placeholder="Full Name" value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>" required>
              </div>
              <div class="mb-4">
                <label class="form-label" for="whatsapp">WhatsApp Number <span class="text-danger">*</span></label>
                <input type="tel" class="form-control" id="whatsapp" name="whatsapp" placeholder="+234 801 234 5678" value="<?php echo htmlspecialchars($_POST['whatsapp'] ?? ''); ?>" required>
              </div>
              <div class="mb-4">
                <label class="form-label" for="registerEmail">Email Address <span class="text-danger">*</span></label>
                <input type="email" class="form-control" id="registerEmail" name="email" placeholder="info@example.com" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
              </div>
              <div class="row">
                <div class="col-md-6 mb-4">
                  <label class="form-label" for="country">Country <span class="text-danger">*</span></label>
                  <select class="form-select" id="country" name="country" required>
                    <option value="">Select Country</option>
                    <option value="Afghanistan" <?php echo (($_POST['country'] ?? '') === 'Afghanistan') ? 'selected' : ''; ?>>Afghanistan</option>
                    <option value="Albania" <?php echo (($_POST['country'] ?? '') === 'Albania') ? 'selected' : ''; ?>>Albania</option>
                    <option value="Algeria" <?php echo (($_POST['country'] ?? '') === 'Algeria') ? 'selected' : ''; ?>>Algeria</option>
                    <option value="Argentina" <?php echo (($_POST['country'] ?? '') === 'Argentina') ? 'selected' : ''; ?>>Argentina</option>
                    <option value="Australia" <?php echo (($_POST['country'] ?? '') === 'Australia') ? 'selected' : ''; ?>>Australia</option>
                    <option value="Austria" <?php echo (($_POST['country'] ?? '') === 'Austria') ? 'selected' : ''; ?>>Austria</option>
                    <option value="Bangladesh" <?php echo (($_POST['country'] ?? '') === 'Bangladesh') ? 'selected' : ''; ?>>Bangladesh</option>
                    <option value="Belgium" <?php echo (($_POST['country'] ?? '') === 'Belgium') ? 'selected' : ''; ?>>Belgium</option>
                    <option value="Brazil" <?php echo (($_POST['country'] ?? '') === 'Brazil') ? 'selected' : ''; ?>>Brazil</option>
                    <option value="Canada" <?php echo (($_POST['country'] ?? '') === 'Canada') ? 'selected' : ''; ?>>Canada</option>
                    <option value="Chile" <?php echo (($_POST['country'] ?? '') === 'Chile') ? 'selected' : ''; ?>>Chile</option>
                    <option value="China" <?php echo (($_POST['country'] ?? '') === 'China') ? 'selected' : ''; ?>>China</option>
                    <option value="Colombia" <?php echo (($_POST['country'] ?? '') === 'Colombia') ? 'selected' : ''; ?>>Colombia</option>
                    <option value="Denmark" <?php echo (($_POST['country'] ?? '') === 'Denmark') ? 'selected' : ''; ?>>Denmark</option>
                    <option value="Egypt" <?php echo (($_POST['country'] ?? '') === 'Egypt') ? 'selected' : ''; ?>>Egypt</option>
                    <option value="Finland" <?php echo (($_POST['country'] ?? '') === 'Finland') ? 'selected' : ''; ?>>Finland</option>
                    <option value="France" <?php echo (($_POST['country'] ?? '') === 'France') ? 'selected' : ''; ?>>France</option>
                    <option value="Germany" <?php echo (($_POST['country'] ?? '') === 'Germany') ? 'selected' : ''; ?>>Germany</option>
                    <option value="Ghana" <?php echo (($_POST['country'] ?? '') === 'Ghana') ? 'selected' : ''; ?>>Ghana</option>
                    <option value="Greece" <?php echo (($_POST['country'] ?? '') === 'Greece') ? 'selected' : ''; ?>>Greece</option>
                    <option value="India" <?php echo (($_POST['country'] ?? '') === 'India') ? 'selected' : ''; ?>>India</option>
                    <option value="Indonesia" <?php echo (($_POST['country'] ?? '') === 'Indonesia') ? 'selected' : ''; ?>>Indonesia</option>
                    <option value="Ireland" <?php echo (($_POST['country'] ?? '') === 'Ireland') ? 'selected' : ''; ?>>Ireland</option>
                    <option value="Israel" <?php echo (($_POST['country'] ?? '') === 'Israel') ? 'selected' : ''; ?>>Israel</option>
                    <option value="Italy" <?php echo (($_POST['country'] ?? '') === 'Italy') ? 'selected' : ''; ?>>Italy</option>
                    <option value="Japan" <?php echo (($_POST['country'] ?? '') === 'Japan') ? 'selected' : ''; ?>>Japan</option>
                    <option value="Kenya" <?php echo (($_POST['country'] ?? '') === 'Kenya') ? 'selected' : ''; ?>>Kenya</option>
                    <option value="Malaysia" <?php echo (($_POST['country'] ?? '') === 'Malaysia') ? 'selected' : ''; ?>>Malaysia</option>
                    <option value="Mexico" <?php echo (($_POST['country'] ?? '') === 'Mexico') ? 'selected' : ''; ?>>Mexico</option>
                    <option value="Netherlands" <?php echo (($_POST['country'] ?? '') === 'Netherlands') ? 'selected' : ''; ?>>Netherlands</option>
                    <option value="New Zealand" <?php echo (($_POST['country'] ?? '') === 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                    <option value="Nigeria" <?php echo (($_POST['country'] ?? '') === 'Nigeria') ? 'selected' : ''; ?>>Nigeria</option>
                    <option value="Norway" <?php echo (($_POST['country'] ?? '') === 'Norway') ? 'selected' : ''; ?>>Norway</option>
                    <option value="Pakistan" <?php echo (($_POST['country'] ?? '') === 'Pakistan') ? 'selected' : ''; ?>>Pakistan</option>
                    <option value="Peru" <?php echo (($_POST['country'] ?? '') === 'Peru') ? 'selected' : ''; ?>>Peru</option>
                    <option value="Philippines" <?php echo (($_POST['country'] ?? '') === 'Philippines') ? 'selected' : ''; ?>>Philippines</option>
                    <option value="Poland" <?php echo (($_POST['country'] ?? '') === 'Poland') ? 'selected' : ''; ?>>Poland</option>
                    <option value="Portugal" <?php echo (($_POST['country'] ?? '') === 'Portugal') ? 'selected' : ''; ?>>Portugal</option>
                    <option value="Russia" <?php echo (($_POST['country'] ?? '') === 'Russia') ? 'selected' : ''; ?>>Russia</option>
                    <option value="Saudi Arabia" <?php echo (($_POST['country'] ?? '') === 'Saudi Arabia') ? 'selected' : ''; ?>>Saudi Arabia</option>
                    <option value="Singapore" <?php echo (($_POST['country'] ?? '') === 'Singapore') ? 'selected' : ''; ?>>Singapore</option>
                    <option value="South Africa" <?php echo (($_POST['country'] ?? '') === 'South Africa') ? 'selected' : ''; ?>>South Africa</option>
                    <option value="South Korea" <?php echo (($_POST['country'] ?? '') === 'South Korea') ? 'selected' : ''; ?>>South Korea</option>
                    <option value="Spain" <?php echo (($_POST['country'] ?? '') === 'Spain') ? 'selected' : ''; ?>>Spain</option>
                    <option value="Sweden" <?php echo (($_POST['country'] ?? '') === 'Sweden') ? 'selected' : ''; ?>>Sweden</option>
                    <option value="Switzerland" <?php echo (($_POST['country'] ?? '') === 'Switzerland') ? 'selected' : ''; ?>>Switzerland</option>
                    <option value="Thailand" <?php echo (($_POST['country'] ?? '') === 'Thailand') ? 'selected' : ''; ?>>Thailand</option>
                    <option value="Turkey" <?php echo (($_POST['country'] ?? '') === 'Turkey') ? 'selected' : ''; ?>>Turkey</option>
                    <option value="Ukraine" <?php echo (($_POST['country'] ?? '') === 'Ukraine') ? 'selected' : ''; ?>>Ukraine</option>
                    <option value="United Arab Emirates" <?php echo (($_POST['country'] ?? '') === 'United Arab Emirates') ? 'selected' : ''; ?>>United Arab Emirates</option>
                    <option value="United Kingdom" <?php echo (($_POST['country'] ?? '') === 'United Kingdom') ? 'selected' : ''; ?>>United Kingdom</option>
                    <option value="United States" <?php echo (($_POST['country'] ?? '') === 'United States') ? 'selected' : ''; ?>>United States</option>
                    <option value="Venezuela" <?php echo (($_POST['country'] ?? '') === 'Venezuela') ? 'selected' : ''; ?>>Venezuela</option>
                    <option value="Vietnam" <?php echo (($_POST['country'] ?? '') === 'Vietnam') ? 'selected' : ''; ?>>Vietnam</option>
                    <option value="Other" <?php echo (($_POST['country'] ?? '') === 'Other') ? 'selected' : ''; ?>>Other</option>
                  </select>
                </div>
                <div class="col-md-6 mb-4">
                  <label class="form-label" for="gender">Gender <span class="text-danger">*</span></label>
                  <select class="form-select" id="gender" name="gender" required>
                    <option value="">Select Gender</option>
                    <option value="Male" <?php echo (($_POST['gender'] ?? '') === 'Male') ? 'selected' : ''; ?>>Male</option>
                    <option value="Female" <?php echo (($_POST['gender'] ?? '') === 'Female') ? 'selected' : ''; ?>>Female</option>
                    
                  </select>
                </div>
              </div>
              <div class="mb-4">
                <label class="form-label" for="username">Username <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="username" name="username" placeholder="Choose a username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required>
              </div>
              <div class="row">
                <div class="col-md-6 mb-4">
                  <label class="form-label" for="registerPassword">Password <span class="text-danger">*</span></label>
                  <input type="password" class="form-control" id="registerPassword" name="password" placeholder="********" required>
                </div>
                <div class="col-md-6 mb-4">
                  <label class="form-label" for="confirmPassword">Confirm Password <span class="text-danger">*</span></label>
                  <input type="password" class="form-control" id="confirmPassword" name="confirm_password" placeholder="********" required>
                </div>
              </div>
              <div class="mb-4">
                <div class="form-check mb-0">
                  <input class="form-check-input" type="checkbox" id="termsConditions" name="terms" required>
                  <label class="form-check-label" for="termsConditions">
                    I agree to <a href="javascript:void(0);">privacy policy & terms</a> <span class="text-danger">*</span>
                  </label>
                </div>
              </div>
              <div class="mb-3">
                <button type="submit" value="Submit" class="btn btn-primary waves-effect waves-light w-100">Sign up</button>
              </div>
              <p class="mb-5 text-center">Have any account? <a href="login.php">Sign In here</a>
              </p>
                          </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
  <!-- begin::Edura Page Scripts -->
  <script src="../assets/libs/global/global.min.js"></script>
  <script src="../assets/js/appSettings.js"></script>
  <script src="../assets/js/main.js"></script>
  <!-- end::Edura Page Scripts -->
</body>

</html>
<?php
// End of PHP processing
?>