<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../../admin-dashboard/config/settings.php';
require_once __DIR__ . '/../config/password_reset.php';

$error = '';
$success = '';
$token = $_GET['token'] ?? '';
$validToken = false;
$userData = null;

// Initialize password reset handler
$pdo = getConnection();
$passwordReset = new PasswordResetHandler($pdo);

// Validate token if provided
if (!empty($token)) {
    $tokenValidation = $passwordReset->validateToken($token);
    if ($tokenValidation['success']) {
        $validToken = true;
        $userData = $tokenValidation['data'];
    } else {
        $error = $tokenValidation['message'];
    }
} else {
    $error = "Invalid reset link.";
}

// Handle password reset form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'reset_password') {
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    if (empty($newPassword)) {
        $error = "Please enter a new password.";
    } elseif (strlen($newPassword) < 8) {
        $error = "Password must be at least 8 characters long.";
    } elseif ($newPassword !== $confirmPassword) {
        $error = "Passwords do not match.";
    } else {
        $result = $passwordReset->resetPassword($token, $newPassword);
        
        if ($result['success']) {
            $success = "Password reset successfully! You can now log in with your new password.";
            $validToken = false; // Hide the form after successful reset
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <base href="">
  <meta charset="utf-8">
  <meta name="theme-color" content="#0D9488">
  <meta name="robots" content="index, follow">
  <meta name="author" content="LayoutDrop">
  <meta name="format-detection" content="telephone=no">
  <title>Reset Password | Omateq Digitals</title>
  
  <!-- begin::Edura Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
  <meta name="mobile-web-app-capable" content="yes">
  <meta name="mobile-web-app-status-bar-style" content="black">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black">
  <meta name="apple-mobile-web-app-title" content="Edura">
  <meta name="application-name" content="Edura">
  <meta name="msapplication-TileColor" content="#0D9488">
  <meta name="msapplication-config" content="assets/images/browserconfig.xml">
  <!-- end::Edura Mobile Specific -->

  <!-- begin::Edura Favicon Tags -->
  <link rel="icon" type="image/png" href="../../assets/img/favicon.png">
  <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
  <!-- end::Edura Favicon Tags -->

  <!-- begin::Edura Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
  <!-- end::Edura Google Fonts -->

  <!-- begin::Edura Required Stylesheet -->
  <link rel="stylesheet" href="../assets/libs/flaticon/css/all/all.css">
  <link rel="stylesheet" href="../assets/libs/lucide/lucide.css">
  <link rel="stylesheet" href="../assets/libs/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="../assets/libs/simplebar/simplebar.css">
  <link rel="stylesheet" href="../assets/libs/node-waves/waves.css">
  <link rel="stylesheet" href="../assets/libs/bootstrap-select/css/bootstrap-select.min.css">
  <!-- end::Edura Required Stylesheet -->

  <!-- begin::Edura CSS Stylesheet -->
  <link rel="stylesheet" href="../assets/css/styles.css">
  <!-- end::Edura CSS Stylesheet -->

  <style>
    /* Logo sizing for reset password page */
    .mb-4.text-center img {
      max-height: 60px;
      max-width: 200px;
      width: auto;
      height: auto;
      object-fit: contain;
    }
    
    .password-strength {
      height: 4px;
      background-color: #e9ecef;
      border-radius: 2px;
      margin-top: 5px;
      overflow: hidden;
    }
    
    .password-strength-bar {
      height: 100%;
      transition: all 0.3s ease;
      border-radius: 2px;
    }
    
    .strength-weak { background-color: #dc3545; width: 25%; }
    .strength-fair { background-color: #ffc107; width: 50%; }
    .strength-good { background-color: #17a2b8; width: 75%; }
    .strength-strong { background-color: #28a745; width: 100%; }
  </style>
</head>

<body>
  <div class="page-layout">
    <div class="auth-frame-wrapper" style="background-color: #1a1c31;">
      <div class="row g-0 h-100">
        <div class="col-12 align-self-center">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-6 col-md-8 col-sm-10">
                <div class="card shadow-lg border-0">
                  <div class="card-body p-4 p-sm-5">
                    <div class="mb-4 text-center">
                      <a href="../index.php" aria-label="Omateq Digitals logo">
                        <?php echo '<img class="visible-light" src="../../' . getSetting('main_logo', 'assets/images/logo-full.svg') . '" alt="Omateq Digitals logo">'; ?>
                        <?php echo '<img class="visible-dark" src="../../' . getSetting('main_logo', 'assets/images/logo-full-white.svg') . '" alt="Omateq Digitals logo">'; ?>
                      </a>
                    </div>
                    
                    <?php if ($validToken && !$success): ?>
                      <div class="text-center mb-5">
                        <h5 class="mb-1">Reset Your Password</h5>
                        <p>Hello <?php echo htmlspecialchars($userData['full_name']); ?>, please enter your new password below.</p>
                      </div>
                    <?php elseif ($success): ?>
                      <div class="text-center mb-5">
                        <h5 class="mb-1">Password Reset Successful!</h5>
                        <p>Your password has been reset successfully.</p>
                      </div>
                    <?php else: ?>
                      <div class="text-center mb-5">
                        <h5 class="mb-1">Invalid Reset Link</h5>
                        <p>The password reset link is invalid or has expired.</p>
                      </div>
                    <?php endif; ?>
             
                    <?php if (!empty($error)): ?>
                      <div class="alert alert-danger" role="alert">
                        <i class="fi fi-rr-exclamation-triangle me-2"></i>
                        <?php echo htmlspecialchars($error); ?>
                      </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($success)): ?>
                      <div class="alert alert-success" role="alert">
                        <i class="fi fi-rr-check-circle me-2"></i>
                        <?php echo htmlspecialchars($success); ?>
                      </div>
                    <?php endif; ?>
                    
                    <?php if ($validToken && !$success): ?>
                      <form method="POST" action="">
                        <input type="hidden" name="action" value="reset_password">
                        <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                        
                        <div class="mb-4">
                          <label class="form-label" for="newPassword">New Password</label>
                          <input type="password" class="form-control" id="newPassword" name="new_password" placeholder="Enter new password" required>
                          <div class="password-strength">
                            <div class="password-strength-bar" id="strengthBar"></div>
                          </div>
                          <small class="text-muted">Password must be at least 8 characters long.</small>
                        </div>
                        
                        <div class="mb-4">
                          <label class="form-label" for="confirmPassword">Confirm New Password</label>
                          <input type="password" class="form-control" id="confirmPassword" name="confirm_password" placeholder="Confirm new password" required>
                        </div>
                        
                        <div class="mb-3">
                          <button type="submit" class="btn btn-primary waves-effect waves-light w-100">Reset Password</button>
                        </div>
                      </form>
                    <?php endif; ?>
                    
                    <div class="text-center">
                      <p class="mb-0">
                        <a href="login.php">Back to Login</a>
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- begin::Edura Page Scripts -->
  <script src="../assets/libs/global/global.min.js"></script>
  <script src="../assets/js/appSettings.js"></script>
  <script src="../assets/js/main.js"></script>
  
  <script>
    // Password strength indicator
    document.getElementById('newPassword').addEventListener('input', function() {
      const password = this.value;
      const strengthBar = document.getElementById('strengthBar');
      
      let strength = 0;
      if (password.length >= 8) strength++;
      if (password.match(/[a-z]/)) strength++;
      if (password.match(/[A-Z]/)) strength++;
      if (password.match(/[0-9]/)) strength++;
      if (password.match(/[^a-zA-Z0-9]/)) strength++;
      
      strengthBar.className = 'password-strength-bar';
      if (strength <= 1) {
        strengthBar.classList.add('strength-weak');
      } else if (strength <= 2) {
        strengthBar.classList.add('strength-fair');
      } else if (strength <= 3) {
        strengthBar.classList.add('strength-good');
      } else {
        strengthBar.classList.add('strength-strong');
      }
    });
    
    // Confirm password validation
    document.getElementById('confirmPassword').addEventListener('input', function() {
      const password = document.getElementById('newPassword').value;
      const confirmPassword = this.value;
      
      if (confirmPassword && password !== confirmPassword) {
        this.setCustomValidity('Passwords do not match');
      } else {
        this.setCustomValidity('');
      }
    });
  </script>
</body>
</html>
