<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../../admin-dashboard/config/settings.php';
require_once __DIR__ . '/../config/email_verification.php';

$error = '';
$success = '';
$token = $_GET['token'] ?? '';
$validToken = false;
$userData = null;

// Initialize email verification handler
$pdo = getConnection();
$emailVerification = new EmailVerificationHandler($pdo);

// Validate token if provided
if (!empty($token)) {
    $tokenValidation = $emailVerification->validateToken($token);
    if ($tokenValidation['success']) {
        $validToken = true;
        $userData = [
            'id' => $tokenValidation['user_id'], 
            'email' => $tokenValidation['email'],
            'token_id' => $tokenValidation['token_id']
        ];
    } else {
        $error = $tokenValidation['message'];
    }
} else {
    $error = "Verification token is missing.";
}

// Handle email verification
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $validToken) {
    $token_id = $_POST['token_id'] ?? '';
    $user_id = $_POST['user_id'] ?? '';

    if (empty($token_id) || empty($user_id)) {
        $error = "Invalid verification request.";
    } else {
        $verifyResult = $emailVerification->markEmailVerified($token_id, $user_id);
        if ($verifyResult['success']) {
            $success = $verifyResult['message'] . " You can now <a href='login.php'>log in</a>.";
            $validToken = false; // Invalidate form after successful verification
        } else {
            $error = $verifyResult['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Verify Email | <?php echo getSetting('site_name', 'Omateq Digitals'); ?></title>
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="../../assets/img/favicon.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="../../assets/css/bootstrap.min.css">
    <!-- Animate CSS -->
    <link rel="stylesheet" href="../../assets/css/animate.min.css">
    <!-- Meanmenu CSS -->
    <link rel="stylesheet" href="../../assets/css/meanmenu.css">
    <!-- Boxicons CSS -->
    <link rel="stylesheet" href="../../assets/css/boxicons.min.css">
    <!-- Flaticon CSS -->
    <link rel="stylesheet" href="../../assets/css/flaticon.css">
    <!-- Owl Carousel CSS -->
    <link rel="stylesheet" href="../../assets/css/owl.carousel.min.css">
    <!-- Owl Carousel Theme CSS -->
    <link rel="stylesheet" href="../../assets/css/owl.theme.default.min.css">
    <!-- Magnific Popup CSS -->
    <link rel="stylesheet" href="../../assets/css/magnific-popup.min.css">
    <!-- Odometer CSS -->
    <link rel="stylesheet" href="../../assets/css/odometer.min.css">
    <!-- Nice Select CSS -->
    <link rel="stylesheet" href="../../assets/css/nice-select.min.css">
    <!-- Style CSS -->
    <link rel="stylesheet" href="../../assets/css/style.css">
    <!-- Responsive CSS -->
    <link rel="stylesheet" href="../../assets/css/responsive.css">

    <style>
        body {
            background-color: #f4f4f4;
        }
        .auth-card {
            max-width: 500px;
            margin: 50px auto;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            background-color: #fff;
        }
        .logo-container {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo-container img {
            max-height: 60px;
            width: auto;
        }
        .verification-icon {
            font-size: 4rem;
            color: #00022E;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="auth-card">
        <div class="logo-container">
            <a href="../../index.php">
                <?php echo '<img src="../../' . getSetting('main_logo', 'assets/images/logo-full.svg') . '" alt="' . getSetting('site_name', 'Omateq Digitals') . ' Logo">'; ?>
            </a>
        </div>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger" role="alert">
                <div class="text-center">
                    <i class="fi fi-rr-cross-circle verification-icon"></i>
                    <h5>Verification Failed</h5>
                    <p><?php echo htmlspecialchars($error); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <div class="alert alert-success" role="alert">
                <div class="text-center">
                    <i class="fi fi-rr-check-circle verification-icon"></i>
                    <h5>Email Verified Successfully!</h5>
                    <p><?php echo $success; ?></p>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($validToken): ?>
            <div class="text-center mb-4">
                <i class="fi fi-rr-envelope verification-icon"></i>
                <h4>Verify Your Email Address</h4>
                <p>Please click the button below to verify your email address and complete your registration.</p>
            </div>
            
            <form method="POST" action="">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                <input type="hidden" name="token_id" value="<?php echo htmlspecialchars($userData['token_id']); ?>">
                <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($userData['id']); ?>">
                
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fi fi-rr-check"></i> Verify Email Address
                    </button>
                </div>
            </form>
            
            <div class="text-center mt-4">
                <p class="text-muted">
                    <small>This verification link will expire in 24 hours.</small>
                </p>
            </div>
        <?php elseif (empty($error)): ?>
            <div class="text-center">
                <p>Please check your email for the verification link.</p>
                <a href="login.php" class="btn btn-outline-primary">Back to Login</a>
            </div>
        <?php endif; ?>
    </div>

    <script src="../../assets/js/jquery.min.js"></script>
    <script src="../../assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
