<?php
// Email configuration for users
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/../../vendor/autoload.php';

function sendEmail($to, $subject, $body, $isHTML = true) {
    // Check if PHPMailer is available
    if (class_exists('PHPMailer\PHPMailer\PHPMailer')) {
        return sendEmailWithPHPMailer($to, $subject, $body, $isHTML);
    } else {
        // Fallback to PHP's built-in mail function
        return sendEmailWithPHPMail($to, $subject, $body, $isHTML);
    }
}

function sendEmailWithPHPMailer($to, $subject, $body, $isHTML = true) {
    $mail = new PHPMailer(true);
    
    try {
        // Server settings - Update these with your actual SMTP credentials
        $mail->isSMTP();
        $mail->Host       = 'scripthubs.com'; // Use mail subdomain for SMTP
        $mail->SMTPAuth   = true;
        $mail->Username   = 'market@scripthubs.com'; // Change to your email
        $mail->Password   = 'Terminal2025#'; // Change to your app password
        $mail->SMTPSecure = 'ssl'; // Use SSL for port 465
        $mail->Port       = 465;
        
        // Enable debug mode for troubleshooting (set to 0 for production)
        $mail->SMTPDebug = 0;
        
        // Additional SMTP options for better compatibility
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );
        
        // Recipients
        $mail->setFrom('market@scripthubs.com', 'Omateq Digitals');
        $mail->addAddress($to);
        
        // Content
        $mail->isHTML($isHTML);
        $mail->Subject = $subject;
        $mail->Body    = $body;
        
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("PHPMailer email sending failed: " . $e->getMessage());
        return false;
    }
}

function sendEmailWithPHPMail($to, $subject, $body, $isHTML = true) {
    // Use PHP's built-in mail function as fallback
    $headers = "From: Omateq Digitals <market@scripthubs.com>\r\n";
    $headers .= "Reply-To: noreply@omateqdigitals.com\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    
    if ($isHTML) {
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    } else {
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
    }
    
    // Try to send email
    $result = mail($to, $subject, $body, $headers);
    
    if ($result) {
        error_log("Email sent successfully using PHP mail() function");
        return true;
    } else {
        error_log("Email sending failed using PHP mail() function");
        return false;
    }
}

?>
