<?php
// Email Setup Guide and Configuration

echo "<h2>Email Configuration Setup Guide</h2>";

echo "<h3>Current Email Configuration Status:</h3>";

// Check if SMTP configuration exists
if (file_exists(__DIR__ . '/smtp_config.php')) {
    echo "<p style='color: green;'>✓ SMTP configuration file exists</p>";
} else {
    echo "<p style='color: red;'>✗ SMTP configuration file not found</p>";
}

// Check if SMTP mailer exists
if (file_exists(__DIR__ . '/smtp_mailer.php')) {
    echo "<p style='color: green;'>✓ SMTP mailer class exists</p>";
} else {
    echo "<p style='color: red;'>✗ SMTP mailer class not found</p>";
}

echo "<h3>Email Setup Options:</h3>";

echo "<div style='background: #f5f5f5; padding: 20px; margin: 10px 0; border-radius: 5px;'>";
echo "<h4>Option 1: Gmail SMTP (Recommended)</h4>";
echo "<ol>";
echo "<li>Go to your Google Account settings</li>";
echo "<li>Enable 2-Factor Authentication</li>";
echo "<li>Generate an App Password for this application</li>";
echo "<li>Update the SMTP configuration in <code>smtp_config.php</code>:</li>";
echo "</ol>";
echo "<pre style='background: #e9ecef; padding: 10px; border-radius: 3px;'>";
echo "'username' => 'your-email@gmail.com',\n";
echo "'password' => 'your-16-character-app-password',";
echo "</pre>";
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 20px; margin: 10px 0; border-radius: 5px;'>";
echo "<h4>Option 2: Outlook/Hotmail SMTP</h4>";
echo "<ol>";
echo "<li>Use your Outlook/Hotmail credentials</li>";
echo "<li>Update the SMTP configuration:</li>";
echo "</ol>";
echo "<pre style='background: #e9ecef; padding: 10px; border-radius: 3px;'>";
echo "'host' => 'smtp-mail.outlook.com',\n";
echo "'username' => 'your-email@outlook.com',\n";
echo "'password' => 'your-password',";
echo "</pre>";
echo "</div>";

echo "<div style='background: #f5f5f5; padding: 20px; margin: 10px 0; border-radius: 5px;'>";
echo "<h4>Option 3: Custom SMTP Server</h4>";
echo "<p>If you have your own SMTP server, update the configuration accordingly.</p>";
echo "</div>";

echo "<h3>Testing Email Functionality:</h3>";
echo "<p>After configuring your SMTP settings, you can test the email functionality by:</p>";
echo "<ol>";
echo "<li>Going to the <a href='../authentication/login.php' target='_blank'>Login Page</a></li>";
echo "<li>Clicking 'Forgot Password?'</li>";
echo "<li>Entering a valid email address</li>";
echo "<li>Checking if the email is received</li>";
echo "</ol>";

echo "<h3>Current SMTP Configuration:</h3>";
if (file_exists(__DIR__ . '/smtp_config.php')) {
    require_once __DIR__ . '/smtp_config.php';
    $config = SMTPConfig::getConfig();
    echo "<pre style='background: #e9ecef; padding: 10px; border-radius: 3px;'>";
    echo "Host: " . $config['host'] . "\n";
    echo "Port: " . $config['port'] . "\n";
    echo "Username: " . $config['username'] . "\n";
    echo "Password: " . (empty($config['password']) ? 'NOT SET' : 'SET (hidden)') . "\n";
    echo "Encryption: " . $config['encryption'] . "\n";
    echo "From Email: " . $config['from_email'] . "\n";
    echo "From Name: " . $config['from_name'];
    echo "</pre>";
} else {
    echo "<p style='color: red;'>SMTP configuration file not found</p>";
}

echo "<h3>Important Notes:</h3>";
echo "<ul>";
echo "<li><strong>Gmail:</strong> You must use an App Password, not your regular password</li>";
echo "<li><strong>Security:</strong> Never commit real credentials to version control</li>";
echo "<li><strong>Testing:</strong> Test with a real email address to verify delivery</li>";
echo "<li><strong>Fallback:</strong> The system will try SMTP first, then fall back to basic mail() function</li>";
echo "</ul>";

echo "<p style='color: blue; font-weight: bold;'>To fix the mail() error, configure your SMTP settings in the smtp_config.php file.</p>";
?>
