<?php
// Payment Configuration
// This file loads admin-configured payment details from database

// Prevent multiple inclusions but always load fresh data
if (!defined('PAYMENT_CONFIG_LOADED')) {
    define('PAYMENT_CONFIG_LOADED', true);
} else {
    // Return cached version if it exists and has data
    if (isset($GLOBALS['payment_config_cache']) && 
        isset($GLOBALS['payment_config_cache']['paystack']) && 
        !empty($GLOBALS['payment_config_cache']['paystack']['secret_key'])) {
        return $GLOBALS['payment_config_cache'];
    }
}

require_once __DIR__ . '/database.php';

// Function to get setting value from database
if (!function_exists('getPaymentSetting')) {
    function getPaymentSetting($key, $default = '') {
        try {
            $pdo = getConnection();
            $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
            $stmt->execute([$key]);
            $result = $stmt->fetch();
            return $result ? $result['setting_value'] : $default;
        } catch (Exception $e) {
            error_log("Error getting payment setting $key: " . $e->getMessage());
            return $default;
        }
    }
}

// Get current domain for callback URL
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$callback_url = $protocol . '://' . $host . '/omateqdigitals/users/payment_handler.php';

return [
    // Bank Transfer Details
    'bank_transfer' => [
        'bank_name' => getPaymentSetting('bank_name', 'First Bank of Nigeria'),
        'account_name' => getPaymentSetting('bank_account_name', 'Omateq Digitals Limited'),
        'account_number' => getPaymentSetting('bank_account_number', '1234567890'),
        'sort_code' => getPaymentSetting('bank_sort_code', '011'),
        'swift_code' => getPaymentSetting('bank_swift_code', 'FBNINGLA'),
        'currency' => getPaymentSetting('bank_currency', 'NGN'),
        'exchange_rate' => (float) getPaymentSetting('bank_exchange_rate', '1500') // USD to NGN
    ],
    
    // Crypto Wallet Addresses
    'crypto_wallets' => [
        'bitcoin' => [
            'address' => getPaymentSetting('crypto_bitcoin_address', '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa'),
            'network' => getPaymentSetting('crypto_bitcoin_network', 'Bitcoin Network'),
            'symbol' => 'BTC',
            'name' => 'Bitcoin'
        ],
        'ethereum' => [
            'address' => getPaymentSetting('crypto_ethereum_address', '0x742d35Cc6634C0532925a3b8D0C4C4C4C4C4C4C4'),
            'network' => getPaymentSetting('crypto_ethereum_network', 'ERC20'),
            'symbol' => 'ETH',
            'name' => 'Ethereum'
        ],
        'usdt' => [
            'address' => getPaymentSetting('crypto_usdt_address', 'TQn9Y2khEsLJW1ChVWFMSMeRDow5KcbLSE'),
            'network' => getPaymentSetting('crypto_usdt_network', 'TRC20'),
            'symbol' => 'USDT',
            'name' => 'Tether USDT'
        ]
    ],
    
    // Paystack Configuration - Load from database
    'paystack' => [
        'public_key' => getPaymentSetting('paystack_public_key', 'pk_live_899e1eaefbc652e8cd6edcb7f0b93a88076b6e40'),
        'secret_key' => getPaymentSetting('paystack_secret_key', 'sk_live_608f039297d2402cbc490acdb644023241edc5ac'),
        'webhook_secret' => getPaymentSetting('paystack_webhook_secret', ''),
        'callback_url' => $callback_url,
        'currency' => getPaymentSetting('paystack_currency', 'NGN'),
        'instructions' => getPaymentSetting('paystack_instructions', '')
    ]
];
?>
