<?php
// SMTP Configuration for email sending

class SMTPConfig {
    // SMTP Settings - Update these with your email provider settings
    public static function getConfig() {
        // Detect environment and use appropriate configuration
        $isProduction = !self::isLocalEnvironment();
        
        if ($isProduction) {
            // Production configuration - Use Gmail SMTP for reliability
            return [
                'host' => 'scripthubs.com', // Gmail SMTP server
                'port' => 465, // TLS port (more compatible with hosting providers)
                'username' => 'market@scripthubs.com', // Your Gmail address
                'password' => 'Terminal2025#', // Gmail App Password (not regular password)
                'encryption' => 'tls', // TLS encryption (better for production)
                'from_email' => 'market@scripthubs.com',
                'from_name' => 'Omateq Digitals',
                'reply_to' => 'market@scripthubs.com'
            ];
        } else {
            // Local development configuration
            return [
                'host' => 'omateqdigitals.com', // Local SMTP server
                'port' => 465, // SSL port
                'username' => 'info@omateqdigitals.com',
                'password' => 'Terminal2025#',
                'encryption' => 'ssl',
                'from_email' => 'info@omateqdigitals.com',
                'from_name' => 'Omateq Digitals',
                'reply_to' => 'info@omateqdigitals.com'
            ];
        }
    }
    
    /**
     * Check if running on local environment
     */
    private static function isLocalEnvironment() {
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $localHosts = ['localhost', '127.0.0.1', '::1'];
        
        foreach ($localHosts as $localHost) {
            if (strpos($host, $localHost) !== false) {
                return true;
            }
        }
        
        // Check for common local development patterns
        if (strpos($host, 'localhost') !== false || 
            strpos($host, '127.0.0.1') !== false ||
            strpos($host, '.local') !== false ||
            strpos($host, 'xampp') !== false) {
            return true;
        }
        
        return false;
    }
    
    // Alternative SMTP providers configuration
    public static function getAlternativeConfigs() {
        return [
            'outlook' => [
                'host' => 'smtp-mail.outlook.com',
                'port' => 587,
                'username' => 'your-email@outlook.com',
                'password' => 'your-password',
                'encryption' => 'tls',
                'from_email' => 'your-email@outlook.com',
                'from_name' => 'Omateq Digitals',
                'reply_to' => 'support@omateqdigitals.com'
            ],
            'yahoo' => [
                'host' => 'smtp.mail.yahoo.com',
                'port' => 587,
                'username' => 'your-email@yahoo.com',
                'password' => 'your-app-password',
                'encryption' => 'tls',
                'from_email' => 'your-email@yahoo.com',
                'from_name' => 'Omateq Digitals',
                'reply_to' => 'support@omateqdigitals.com'
            ]
        ];
    }
}
?>
