<?php
// Welcome Email Handler

class WelcomeEmailHandler {
    private $pdo;
    
    public function __construct(PDO $pdo) {
        $this->pdo = $pdo;
    }
    
    /**
     * Send welcome email to new user
     */
    public function sendWelcomeEmail($email, $userName = '', $username = '') {
        try {
            require_once __DIR__ . '/smtp_config.php';
            require_once __DIR__ . '/smtp_mailer.php';
            
            $config = SMTPConfig::getConfig();
            $mailer = new SMTPMailer($config);
            
            $subject = "Welcome to Omateq Digitals!";
            $message = $this->buildWelcomeEmailMessage($userName, $username);
            
            $result = $mailer->send($email, $subject, $message, true);
            
            return $result;
            
        } catch (Exception $e) {
            error_log("Welcome email send failed: " . $e->getMessage());
            return ['success' => false, 'message' => 'Failed to send welcome email.'];
        }
    }
    
    /**
     * Build HTML welcome email message
     */
    private function buildWelcomeEmailMessage($userName = '', $username = '') {
        $greeting = $userName ? "Hello " . htmlspecialchars($userName) . "," : "Hello,";
        $loginInfo = $username ? "<p><strong>Username:</strong> " . htmlspecialchars($username) . "</p>" : "";
        
        return "
        <html>
        <head>
            <title>Welcome to Omateq Digitals</title>
        </head>
        <body>
            <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;'>
                <div style='text-align: center; margin-bottom: 30px;'>
                    <h1 style='color: #00022E; margin: 0;'>Welcome to Omateq Digitals!</h1>
                </div>
                
                <h2 style='color: #00022E;'>Thank You for Joining Us!</h2>
                <p>{$greeting}</p>
                <p>We're excited to have you as part of the Omateq Digitals community! Your account has been successfully created and you can now access all our features and services.</p>
                
                <div style='background-color: #f8f9fa; padding: 20px; border-radius: 5px; margin: 20px 0;'>
                    <h3 style='color: #00022E; margin-top: 0;'>What's Next?</h3>
                    <ul style='color: #333; line-height: 1.6;'>
                        <li>Complete your profile setup</li>
                        <li>Explore our courses and services</li>
                        <li>Join our community discussions</li>
                        <li>Stay updated with our latest offerings</li>
                    </ul>
                </div>
                
                {$loginInfo}
                
                <div style='text-align: center; margin: 30px 0;'>
                    <a href='http://" . (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost') . "/users/index.php' style='background-color: #00022E; color: white; padding: 15px 30px; text-decoration: none; border-radius: 5px; display: inline-block; font-weight: bold;'>Get Started</a>
                </div>
                
                <div style='background-color: #e9f7ef; padding: 15px; border-radius: 5px; margin: 20px 0;'>
                    <h4 style='color: #00022E; margin-top: 0;'>Important Security Note:</h4>
                    <p style='margin: 0; color: #333; font-size: 14px;'>Please verify your email address to ensure account security and receive important updates. Check your inbox for a verification email.</p>
                </div>
                
                <p style='color: #666; font-size: 14px;'>If you have any questions or need assistance, feel free to contact our support team.</p>
                
                <hr style='margin: 30px 0; border: none; border-top: 1px solid #eee;'>
                
                <div style='text-align: center; color: #666; font-size: 12px;'>
                    <p>Welcome to the Omateq Digitals family!</p>
                    <p>Best regards,<br>The Omateq Digitals Team</p>
                </div>
            </div>
        </body>
        </html>
        ";
    }
}
?>
