<?php
session_start();
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/../admin-dashboard/config/settings.php';
require_once __DIR__ . '/../admin-dashboard/config/branding.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: authentication/login.php');
    exit();
}

// Get product ID from URL
$product_id = $_GET['product_id'] ?? '';

if (empty($product_id)) {
    header('Location: products.php');
    exit();
}

// Get user data
try {
    $pdo = getConnection();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
    
    if (!$user) {
        session_destroy();
        header('Location: authentication/login.php');
        exit();
    }
} catch (Exception $e) {
    session_destroy();
    header('Location: authentication/login.php');
    exit();
}

// Get product and purchase information
$product = null;
$order = null;
$download_info = null;

try {
    // Get product details
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ? AND status = 'active'");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch();
    
    if (!$product) {
        header('Location: products.php');
        exit();
    }
    
    // Get user's purchase for this product
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = ? AND product_id = ? AND status = 'delivered' ORDER BY created_at DESC LIMIT 1");
    $stmt->execute([$_SESSION['user_id'], $product_id]);
    $order = $stmt->fetch();
    
    if ($order) {
        // Calculate download info
        $max_downloads = $product['download_limit'] ?? 3;
        $download_count = $order['download_count'] ?? 0;
        $downloads_left = $max_downloads - $download_count;
        
        $download_info = [
            'max_downloads' => $max_downloads,
            'download_count' => $download_count,
            'downloads_left' => $downloads_left,
            'can_download' => $downloads_left > 0 && $product['download_file_url'],
            'file_name' => $product['download_file_name'],
            'file_size' => $product['download_file_size'],
            'file_type' => $product['download_file_type'],
            'instructions' => $product['download_instructions'],
            'access_duration' => $product['download_access_duration'] ?? 365,
            'purchase_date' => $order['created_at']
        ];
    }
} catch (Exception $e) {
    error_log("Download page error: " . $e->getMessage());
    header('Location: products.php');
    exit();
}

// Function to format file size
function formatFileSize($bytes) {
    if ($bytes == 0) return '0 Bytes';
    $k = 1024;
    $sizes = ['Bytes', 'KB', 'MB', 'GB'];
    $i = floor(log($bytes) / log($k));
    return round($bytes / pow($k, $i), 2) . ' ' . $sizes[$i];
}

// Function to format time ago
function time_ago($datetime) {
    $time = time() - strtotime($datetime);
    if ($time < 60) return 'just now';
    if ($time < 3600) return floor($time/60) . ' min ago';
    if ($time < 86400) return floor($time/3600) . ' hr ago';
    if ($time < 2592000) return floor($time/86400) . ' days ago';
    return date('M j', strtotime($datetime));
}

// Check for success/error messages
$payment_success = '';
if (isset($_SESSION['payment_success'])) {
    $payment_success = $_SESSION['payment_success'];
    unset($_SESSION['payment_success']);
}

$download_error = '';
if (isset($_SESSION['download_error'])) {
    $download_error = $_SESSION['download_error'];
    unset($_SESSION['download_error']);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- begin::Edura Meta Basic -->
  <meta charset="utf-8">
  <meta name="theme-color" content="#0D9488">
  <meta name="robots" content="index, follow">
  <meta name="author" content="LayoutDrop">
  <meta name="format-detection" content="telephone=no">
  <meta name="keywords" content="School Management, Education Admin Dashboard, Student Information System, University Dashboard, College Admin Template, Learning Management System, Education CRM, Teacher Management, Student Attendance Dashboard, Online Education Admin, Responsive Admin Template, Bootstrap 5 Education Admin, eLearning Dashboard, School ERP, Class Management Dashboard, Academic Dashboard, Education Web Application, Modern Admin Template, Admin UI Kit, ThemeForest Admin Template">
  <meta name="description" content="Edura is a professional and modern School Management & Education Admin Dashboard Template built with Bootstrap. It includes light and dark modes, and is perfect for managing students, teachers, courses, attendance, fees, and academic activities — ideal for schools, colleges, universities, and eLearning platforms.">
  <!-- end::Edura Meta Basic -->

  <!-- begin::Edura Meta Social -->
  <meta property="og:url" content="https://demos.layoutdrop.com/edura/demo/">
  <meta property="og:site_name" content="Dashboard | Edura School Management & Education Admin Dashboard Template">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_us">
  <meta property="og:title" content="Dashboard | Edura School Management & Education Admin Dashboard Template">
  <meta property="og:description" content="Edura is a professional and modern School Management & Education Admin Dashboard Template built with Bootstrap. It includes light and dark modes, and is perfect for managing students, teachers, courses, attendance, fees, and academic activities — ideal for schools, colleges, universities, and eLearning platforms.">
  <meta property="og:image" content="https://demos.layoutdrop.com/edura/demo/preview.png">
  <!-- end::Edura Meta Social -->

  <!-- begin::Edura Meta Twitter -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:site" content="@LayoutDrop">
  <meta name="twitter:creator" content="@LayoutDrop">
  <meta name="twitter:title" content="Dashboard | Edura School Management & Education Admin Dashboard Template">
  <meta name="twitter:description" content="Edura is a professional and modern School Management & Education Admin Dashboard Template built with Bootstrap. It includes light and dark modes, and is perfect for managing students, teachers, courses, attendance, fees, and academic activities — ideal for schools, colleges, universities, and eLearning platforms.">
  <meta name="twitter:image" content="https://demos.layoutdrop.com/edura/demo/preview.png">
  <!-- end::Edura Meta Twitter -->

  <!-- begin::Edura Website Page Title -->
  <title>Download Center | Omateq Digitals</title>
  <!-- end::Edura Website Page Title -->

  <!-- begin::Edura Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- end::Edura Mobile Specific -->

  <!-- begin::Edura Favicon Tags -->
  <?php echo getFaviconHtml(); ?>
  <!-- end::Edura Favicon Tags -->

  <!-- begin::Edura Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
  <!-- end::Edura Google Fonts -->

  <!-- begin::Edura Required Stylesheet -->
  <link rel="stylesheet" href="assets/libs/flaticon/css/all/all.css">
  <link rel="stylesheet" href="assets/libs/lucide/lucide.css">
  <link rel="stylesheet" href="assets/libs/fontawesome/css/all.min.css">
  <link rel="stylesheet" href="assets/libs/simplebar/simplebar.css">
  <link rel="stylesheet" href="assets/libs/node-waves/waves.css">
  <link rel="stylesheet" href="assets/libs/bootstrap-select/css/bootstrap-select.min.css">
  <!-- end::Edura Required Stylesheet -->

  <!-- begin::Edura CSS Stylesheet -->
  <link rel="stylesheet" href="assets/css/styles.css">
  <!-- end::Edura CSS Stylesheet -->
</head>

<body>
  <div class="page-layout">

    <!-- begin::Edura Page Header -->
    <header class="app-header">
      <div class="app-header-inner">
        <button class="app-toggler" type="button">
          <span></span>
          <span></span>
          <span></span>
        </button>
        <div class="app-header-start">
          <form class="d-none d-md-flex align-items-center h-100 w-lg-250px w-xxl-300px position-relative" action="index.html#">
            <button type="button" class="btn btn-sm border-0 position-absolute start-0 ms-3 p-0">
              <i class="fi fi-rr-search"></i>
            </button>
            <input type="text" class="form-control ps-5" placeholder="Search...">
          </form>
        </div>
        <div class="app-header-end">
          <div class="px-lg-3 px-2 ps-0 d-flex align-items-center">
            <a href="javascript:void(0);" class="theme-btn">
              <i class="fi fi-rr-brightness icon-light"></i>
              <div class="theme-toggle"></div>
              <i class="fi fi-rr-moon icon-dark"></i>
            </a>
          </div>
          <div class="vr my-3"></div>
          <div class="d-flex align-items-center gap-sm-2 gap-0 px-lg-4 px-sm-2 px-1">
            <div class="dropdown text-end">
              <a href="javascript:void(0);" class="btn btn-icon btn-action-gray rounded-circle waves-effect waves-light" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                <i class="fi fi-rr-envelope"></i>
              </a>
              <div class="dropdown-menu dropdown-menu-lg-end p-0 w-300px mt-2">
                <div class="px-3 py-3 border-bottom d-flex justify-content-between align-items-center">
                  <h6 class="mb-0">Messages <span class="badge badge-sm rounded-pill bg-primary ms-2">0</span></h6>
                  <i class="bi bi-x-lg cursor-pointer"></i>
                </div>
                <div class="p-2" style="height: 300px;" data-simplebar>
                  <ul class="list-group list-group-hover list-group-smooth list-group-unlined">
                    <li class="list-group-item text-center py-4">
                      <i class="fi fi-rr-envelope text-muted" style="font-size: 2rem;"></i>
                      <p class="text-muted mt-2 mb-0">No script request replies yet</p>
                    </li>
                  </ul>
                </div>
                <div class="p-2">
                  <a href="script-request.php" class="btn w-100 btn-primary waves-effect waves-light">View all replies</a>
                </div>
              </div>
            </div>
            <div class="dropdown text-end">
              <a href="javascript:void(0);" class="btn btn-icon btn-action-gray rounded-circle waves-effect waves-light" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                <i class="fi fi-rr-bell"></i>
              </a>
              <div class="dropdown-menu dropdown-menu-lg-end p-0 w-300px mt-2">
                <div class="px-3 py-3 border-bottom d-flex justify-content-between align-items-center">
                  <h6 class="mb-0">Transactions <span class="badge badge-sm rounded-pill bg-primary ms-2">0</span></h6>
                  <i class="bi bi-x-lg cursor-pointer"></i>
                </div>
                <div class="p-2" style="height: 300px;" data-simplebar>
                  <ul class="list-group list-group-hover list-group-smooth list-group-unlined">
                    <li class="list-group-item text-center py-4">
                      <i class="fi fi-rr-shopping-cart text-muted" style="font-size: 2rem;"></i>
                      <p class="text-muted mt-2 mb-0">No transactions yet</p>
                    </li>
                  </ul>
                </div>
                <div class="p-2">
                  <a href="products.php" class="btn w-100 btn-primary waves-effect waves-light">View all transactions</a>
                </div>
              </div>
            </div>
          </div>
          <div class="vr my-3"></div>
          <div class="dropdown text-end ms-2">
            <a href="javascript:void(0);" class="d-flex align-items-center py-2" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
              <div class="avatar avatar-sm rounded-circle avatar-status-success">
                <?php if ($user['avatar'] && file_exists($user['avatar'])): ?>
                  <img src="<?php echo htmlspecialchars($user['avatar']); ?>" alt="<?php echo htmlspecialchars($user['full_name']); ?>">
                <?php else: ?>
                  <img src="assets/images/avatar/avatar1.webp" alt="<?php echo htmlspecialchars($user['full_name']); ?>">
                <?php endif; ?>
              </div>
            </a>
            <ul class="dropdown-menu dropdown-menu-end w-225px mt-1">
              <li class="d-flex align-items-center p-2">
                <div class="avatar avatar-sm rounded-circle">
                  <?php if ($user['avatar'] && file_exists($user['avatar'])): ?>
                    <img src="<?php echo htmlspecialchars($user['avatar']); ?>" alt="<?php echo htmlspecialchars($user['full_name']); ?>">
                  <?php else: ?>
                    <img src="assets/images/avatar/avatar1.webp" alt="<?php echo htmlspecialchars($user['full_name']); ?>">
                  <?php endif; ?>
                </div>
                <div class="ms-2">
                  <div class="fw-bold text-dark"><?php echo htmlspecialchars($user['full_name']); ?></div>
                  <small class="text-body d-block lh-sm"><?php echo htmlspecialchars($user['email']); ?></small>
                </div>
              </li>
              <li>
                <div class="dropdown-divider my-1"></div>
              </li>
              <li>
                <a class="dropdown-item d-flex align-items-center gap-2" href="profile.php">
                  <i class="fi fi-rr-user scale-1x"></i> Profile
                </a>
              </li>
              <li>
                <a class="dropdown-item d-flex align-items-center gap-2" href="help-center.php">
                  <i class="fi fi-rs-interrogation scale-1x"></i> Help Center
                </a>
              </li>
              <li>
                <div class="dropdown-divider my-1"></div>
              </li>
              <li>
                <a class="dropdown-item d-flex align-items-center gap-2 text-danger" href="authentication/logout.php">
                  <i class="fi fi-sr-exit scale-1x"></i> Logout
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </header>
    <!-- end::Edura Page Header -->

    <!-- begin::Edura Sidebar Menu -->
    <aside class="app-menubar" id="menubar">
      <div class="app-navbar-brand">
        <a class="navbar-brand-logo" href="index.php">
          <img src="assets/images/logo.svg" alt="logo">
        </a>
        <a class="navbar-brand-mini" href="index.php">
          <img src="assets/images/logo-text-white.svg" alt="logo">
        </a>
      </div>
      <nav class="app-navbar" data-simplebar>
        <ul class="menubar">
              <li class="menu-item">
                <a class="menu-link" href="index.php">
              <i class="fi fi-rr-apps"></i>
                  <span class="menu-label">Dashboard</span>
                </a>
              </li>
              <li class="menu-item">
            <a class="menu-link" href="products.php">
              <i class="fi fi-rr-shopping-cart"></i>
              <span class="menu-label">Products</span>
                </a>
              </li>
              <li class="menu-item">
            <a class="menu-link" href="course.php">
              <i class="fi fi-rr-graduation-cap"></i>
              <span class="menu-label">Course</span>
                </a>
              </li>
              <li class="menu-item">
            <a class="menu-link" href="profile.php">
              <i class="fi fi-rr-user"></i>
              <span class="menu-label">Profile</span>
                </a>
              </li>
              
        </ul>
      </nav>
      <div class="app-footer">
        <div class="text-center py-2">
          <small class="text-white-50">
            <i class="fi fi-rr-copyright me-1"></i>
            2025 Omateq Digitals
          </small>
        </div>
        <a href="mailto:info@omateqdigitals.com" class="btn btn-outline-white waves-effect btn-app-nav w-100">
          <i class="fi fi-rs-interrogation"></i>
          <span class="nav-text">Help and Support</span>
        </a>
      </div>
    </aside>
    <!-- end::Edura Sidebar Menu -->

    <main class="app-wrapper">
      <div class="container-fluid">
        <div class="app-page-head d-flex flex-wrap gap-3 align-items-center justify-content-between">
          <div class="clearfix">
            <h1 class="app-page-title">Download Center</h1>
            <span>Download your purchased digital products</span>
          </div>
        </div>

        <!-- Content -->
        <div class="row justify-content-center">
          <div class="col-lg-8 col-xl-6">

            <!-- Success/Error Messages -->
            <?php if (!empty($payment_success)): ?>
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                  <i class="fi fi-rr-check-circle me-3" style="font-size: 2rem;"></i>
                  <div>
                    <h5 class="alert-heading mb-1">Payment Successful!</h5>
                    <p class="mb-0"><?php echo htmlspecialchars($payment_success); ?></p>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif; ?>

            <?php if (!empty($download_error)): ?>
              <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                  <i class="fi fi-rr-exclamation-triangle me-3" style="font-size: 2rem;"></i>
                  <div>
                    <h5 class="alert-heading mb-1">Download Error</h5>
                    <p class="mb-0"><?php echo htmlspecialchars($download_error); ?></p>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif; ?>

            <?php if (!$order): ?>
              <!-- Not Purchased -->
              <div class="card border-danger">
                <div class="card-body text-center py-5">
                  <i class="fi fi-rr-exclamation-triangle text-danger mb-3" style="font-size: 4rem;"></i>
                  <h3 class="text-danger mb-3">Product Not Purchased</h3>
                  <p class="text-muted mb-4">You haven't purchased this product yet. Please purchase it first to access downloads.</p>
                  <a href="products.php" class="btn btn-primary btn-lg">
                    <i class="fi fi-rr-shopping-cart me-2"></i>Browse Products
                  </a>
                </div>
              </div>
            <?php elseif (!$product['is_downloadable']): ?>
              <!-- Not Downloadable -->
              <div class="card border-warning">
                <div class="card-body text-center py-5">
                  <i class="fi fi-rr-eye text-warning mb-3" style="font-size: 4rem;"></i>
                  <h3 class="text-warning mb-3">View Only Product</h3>
                  <p class="text-muted mb-4">This product is for viewing only and doesn't have downloadable files.</p>
                  <a href="products.php" class="btn btn-primary btn-lg">
                    <i class="fi fi-rr-arrow-left me-2"></i>Back to Products
                  </a>
                </div>
              </div>
            <?php elseif (!$product['download_file_url']): ?>
              <!-- No Download File -->
              <div class="card border-warning">
                <div class="card-body text-center py-5">
                  <i class="fi fi-rr-exclamation-triangle text-warning mb-3" style="font-size: 4rem;"></i>
                  <h3 class="text-warning mb-3">Download File Not Available</h3>
                  <p class="text-muted mb-4">The download file for this product is not available. Please contact support.</p>
                  <a href="products.php" class="btn btn-primary btn-lg">
                    <i class="fi fi-rr-arrow-left me-2"></i>Back to Products
                  </a>
                </div>
              </div>
            <?php else: ?>
              <!-- Download Available -->
              <div class="card border-success">
                <div class="card-header bg-success text-white">
                  <h4 class="mb-0">
                    <i class="fi fi-rr-check-circle me-2"></i>Download Ready
                  </h4>
                </div>
                <div class="card-body">
                  <!-- Product Info -->
                  <div class="row mb-4">
                    <div class="col-md-4">
                      <?php if ($product['thumbnail_url']): ?>
                        <img src="../<?php echo htmlspecialchars($product['thumbnail_url']); ?>" alt="<?php echo htmlspecialchars($product['product_name']); ?>" class="img-fluid rounded">
                      <?php else: ?>
                        <div class="bg-light d-flex align-items-center justify-content-center rounded" style="height: 200px;">
                          <i class="fi fi-rr-image text-muted" style="font-size: 3rem;"></i>
                        </div>
                      <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                      <h3 class="mb-2"><?php echo htmlspecialchars($product['product_name']); ?></h3>
                      <p class="text-muted mb-3"><?php echo htmlspecialchars($product['product_description']); ?></p>
                      <div class="row">
                        <div class="col-sm-6">
                          <small class="text-muted d-block">Purchase Date</small>
                          <strong><?php echo date('M d, Y', strtotime($download_info['purchase_date'])); ?></strong>
                        </div>
                        <div class="col-sm-6">
                          <small class="text-muted d-block">Access Duration</small>
                          <strong><?php echo $download_info['access_duration']; ?> days</strong>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- File Info -->
                  <div class="alert alert-info">
                    <div class="row align-items-center">
                      <div class="col-md-8">
                        <h6 class="mb-1">
                          <i class="fi fi-rr-file me-2"></i><?php echo htmlspecialchars($download_info['file_name']); ?>
                        </h6>
                        <small class="text-muted">
                          <?php echo $download_info['file_type']; ?> • 
                          <?php echo formatFileSize($download_info['file_size']); ?>
                        </small>
                      </div>
                      <div class="col-md-4 text-end">
                        <?php if ($download_info['can_download']): ?>
                          <form method="POST" action="download_handler.php" class="d-inline">
                            <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                            <button type="submit" class="btn btn-success btn-lg">
                              <i class="fi fi-rr-download me-2"></i>Download Now
                            </button>
                          </form>
                        <?php else: ?>
                          <button class="btn btn-warning btn-lg" disabled>
                            <i class="fi fi-rr-ban me-2"></i>Download Limit Reached
                          </button>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>

                  <!-- Download Stats -->
                  <div class="row mb-4">
                    <div class="col-md-4">
                      <div class="text-center p-3 bg-light rounded">
                        <h5 class="text-success mb-1"><?php echo $download_info['downloads_left']; ?></h5>
                        <small class="text-muted">Downloads Remaining</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center p-3 bg-light rounded">
                        <h5 class="text-primary mb-1"><?php echo $download_info['download_count']; ?></h5>
                        <small class="text-muted">Downloads Used</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="text-center p-3 bg-light rounded">
                        <h5 class="text-info mb-1"><?php echo $download_info['max_downloads']; ?></h5>
                        <small class="text-muted">Total Downloads</small>
                      </div>
                    </div>
                  </div>

                  <!-- Download Instructions -->
                  <?php if ($download_info['instructions']): ?>
                    <div class="alert alert-warning">
                      <h6><i class="fi fi-rr-info me-2"></i>Download Instructions</h6>
                      <p class="mb-0"><?php echo nl2br(htmlspecialchars($download_info['instructions'])); ?></p>
                    </div>
                  <?php endif; ?>

                  <!-- Actions -->
                  <div class="d-flex gap-3 justify-content-center">
                    <a href="products.php" class="btn btn-outline-primary">
                      <i class="fi fi-rr-arrow-left me-2"></i>Back to Products
                    </a>
                    <?php if (!$download_info['can_download']): ?>
                      <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#repurchaseModal">
                        <i class="fi fi-rr-shopping-cart me-2"></i>Repurchase
                      </button>
                    <?php endif; ?>
                    <a href="index.php" class="btn btn-outline-secondary">
                      <i class="fi fi-rr-home me-2"></i>Dashboard
                    </a>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </main>

  </div>

  <!-- begin::Edura Scripts -->
  <script src="assets/libs/global/global.min.js"></script>
  <script src="assets/js/appSettings.js"></script>
  <script src="assets/js/main.js"></script>
  <!-- end::Edura Scripts -->

  <!-- Repurchase Modal -->
  <div class="modal fade" id="repurchaseModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Repurchase Product</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <p>You have reached the download limit for this product. Would you like to repurchase it to get more downloads?</p>
          <div class="text-center">
            <strong class="text-primary"><?php echo htmlspecialchars($product['product_name']); ?></strong><br>
            <span class="text-success h5">$<?php echo number_format($product['product_amount'], 2); ?></span>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <a href="products.php" class="btn btn-primary">Go to Products</a>
        </div>
      </div>
    </div>
  </div>

  <!-- begin::Edura Footer -->
  <footer class="footer-area">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="footer-content text-center">
            <p>&copy; <?php echo date('Y'); ?> Omateq Digitals. All rights reserved.</p>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <!-- end::Edura Footer -->

  <!-- begin::Edura Website JS -->
  <script src="../assets/js/jquery.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/swiper-bundle.min.js"></script>
  <script src="../assets/js/venobox.min.js"></script>
  <script src="../assets/js/odometer.min.js"></script>
  <script src="../assets/js/wow.min.js"></script>
  <script src="../assets/js/main.js"></script>
  <!-- end::Edura Website JS -->

  <!-- WhatsApp Chat Button -->
  <div class="whatsapp-chat-button">
    <a href="https://wa.me/2347069378861?text=Hello%20Omateq%20Digitals!%20I%20would%20like%20to%20know%20more%20about%20your%20services." 
       target="_blank" 
       rel="noopener noreferrer"
       class="whatsapp-link"
       title="Chat with us on WhatsApp">
      <i class="fab fa-whatsapp"></i>
      <span class="whatsapp-text">Chat with us</span>
    </a>
  </div>
  
  <style>
  /* WhatsApp Chat Button Styles */
  .whatsapp-chat-button {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 1000;
    animation: pulse 2s infinite;
  }
  
  .whatsapp-link {
    display: flex;
    align-items: center;
    background: #25D366;
    color: white;
    text-decoration: none;
    padding: 12px 16px;
    border-radius: 50px;
    box-shadow: 0 4px 12px rgba(37, 211, 102, 0.4);
    transition: all 0.3s ease;
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
    font-size: 14px;
  }
  
  .whatsapp-link:hover {
    background: #128C7E;
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(37, 211, 102, 0.6);
  }
  
  .whatsapp-link i {
    font-size: 24px;
    margin-right: 8px;
  }
  
  .whatsapp-text {
    white-space: nowrap;
  }
  
  @keyframes pulse {
    0% {
      box-shadow: 0 0 0 0 rgba(37, 211, 102, 0.7);
    }
    70% {
      box-shadow: 0 0 0 10px rgba(37, 211, 102, 0);
    }
    100% {
      box-shadow: 0 0 0 0 rgba(37, 211, 102, 0);
    }
  }
  
  /* Mobile responsiveness */
  @media (max-width: 768px) {
    .whatsapp-chat-button {
      bottom: 15px;
      right: 15px;
    }
    
    .whatsapp-link {
      padding: 10px 14px;
      font-size: 13px;
    }
    
    .whatsapp-link i {
      font-size: 22px;
      margin-right: 6px;
    }
    
    .whatsapp-text {
      display: none;
    }
  }
  </style>
</body>

</html>
