<?php
session_start();
require_once __DIR__ . '/config/database.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit();
}

// Get course ID from request
$course_id = $_GET['id'] ?? null;

if (!$course_id) {
    echo json_encode(['success' => false, 'message' => 'Course ID is required']);
    exit();
}

try {
    $pdo = getConnection();
    
    // Get course details
    $stmt = $pdo->prepare("SELECT * FROM courses WHERE id = ? AND status = 'active'");
    $stmt->execute([$course_id]);
    $course = $stmt->fetch();
    
    if (!$course) {
        echo json_encode(['success' => false, 'message' => 'Course not found or not available']);
        exit();
    }
    
    // Check if user is already enrolled
    $stmt = $pdo->prepare("SELECT id FROM course_enrollments WHERE user_id = ? AND course_id = ?");
    $stmt->execute([$_SESSION['user_id'], $course_id]);
    $enrollment = $stmt->fetch();
    
    // Add enrollment status to course data
    $course['isEnrolled'] = $enrollment ? true : false;
    
    echo json_encode([
        'success' => true,
        'course' => $course
    ]);
    
} catch (Exception $e) {
    error_log("Error fetching course details: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Failed to load course details']);
}
?>
