<?php
session_start();
require_once __DIR__ . '/config/database.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['course_id'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit();
}

$course_id = (int)$_POST['course_id'];
$user_id = $_SESSION['user_id'];

try {
    $pdo = getConnection();
    
    // Check if user is enrolled in the course
    $stmt = $pdo->prepare("SELECT id, status FROM course_enrollments WHERE user_id = ? AND course_id = ?");
    $stmt->execute([$user_id, $course_id]);
    $enrollment = $stmt->fetch();
    
    if (!$enrollment) {
        echo json_encode(['success' => false, 'message' => 'User not enrolled in this course']);
        exit();
    }
    
    // Check if already completed
    if ($enrollment['status'] === 'completed') {
        echo json_encode(['success' => false, 'message' => 'Course is already completed']);
        exit();
    }
    
    // Get course details
    $stmt = $pdo->prepare("SELECT title FROM courses WHERE id = ?");
    $stmt->execute([$course_id]);
    $course = $stmt->fetch();
    
    if (!$course) {
        echo json_encode(['success' => false, 'message' => 'Course not found']);
        exit();
    }
    
    // Mark course as completed
    $stmt = $pdo->prepare("
        UPDATE course_enrollments 
        SET status = 'completed', completed_at = NOW(), progress_percentage = 100
        WHERE user_id = ? AND course_id = ?
    ");
    $stmt->execute([$user_id, $course_id]);
    
    // Log the manual completion
    error_log("Course manually completed: User $user_id completed course $course_id ({$course['title']})");
    
    echo json_encode([
        'success' => true, 
        'message' => 'Course marked as complete successfully',
        'course_title' => $course['title']
    ]);
    
} catch (Exception $e) {
    error_log("Manual course completion error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error occurred']);
}
?>
