<?php
session_start();
require_once __DIR__ . '/config/exchange_rate.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit();
}

try {
    // Force refresh by clearing cache
    $cache_file = __DIR__ . '/config/exchange_rate_cache.json';
    if (file_exists($cache_file)) {
        unlink($cache_file);
    }
    
    // Get fresh exchange rate
    $exchange_rate_info = getExchangeRateWithInfo();
    
    if ($exchange_rate_info && $exchange_rate_info['rate'] > 1000) {
        echo json_encode([
            'success' => true,
            'rate' => $exchange_rate_info['rate'],
            'source' => $exchange_rate_info['source'],
            'timestamp' => $exchange_rate_info['timestamp'],
            'age_minutes' => $exchange_rate_info['age_minutes']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to fetch exchange rate'
        ]);
    }
} catch (Exception $e) {
    error_log('Exchange rate refresh error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error refreshing exchange rate'
    ]);
}
?>
